#include <stdlib.h>
#include <stdio.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <netdb.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

#include "log.h"
#include "socket.h"
#include "request.h"

#define TIMEOUT 120

int inetd;
int ipversion;
Conn_Struct conn;

static int s;

void SetInetdSocket()
{
	dup2(0,1);
	s=1;
}

int NewConn(void)
{
	struct sockaddr_in6 sa;
	socklen_t slt=sizeof(sa);
	int s2;
	char rmt[40], loc[40];
	
	if(inetd) {
		if(getpeername(s, (struct sockaddr *)&sa, &slt))
			LogError("getpeername");
		ipversion=((struct sockaddr *)&sa)->sa_family==AF_INET?4:6;
	} else {
		if((s2=accept(s, (struct sockaddr *)&sa, &slt))<0)
			LogError("accept");
		if(fork()) {
			close(s2);
			return(1);
		}
		close(s);
		s=s2;
	}
	if(ipversion==6) {
		conn.rh=sa.sin6_addr;
		conn.rp=htons(sa.sin6_port);
	} else {
		conn.rh.s6_addr32[3]=((struct sockaddr_in *)&sa)->sin_addr.s_addr;
		conn.rp=htons(((struct sockaddr_in *)&sa)->sin_port);
	}
	
	if(getsockname(s, (struct sockaddr *)&sa, &slt))
		LogError("getsockname");

	if(ipversion==6) {
		conn.lh=sa.sin6_addr;
		conn.lp=htons(sa.sin6_port);
	} else {
		conn.lh.s6_addr32[3]=((struct sockaddr_in *)&sa)->sin_addr.s_addr;
		conn.lp=htons(((struct sockaddr_in *)&sa)->sin_port);
	}
	
	// Log
	inet_ntop(ipversion==4?AF_INET:AF_INET6, &conn.rh.s6_addr32[ipversion==4?3:0], rmt, 40);
	inet_ntop(ipversion==4?AF_INET:AF_INET6, &conn.lh.s6_addr32[ipversion==4?3:0], loc, 40);
	Log("[%s]:%i -> [%s]:%i", rmt, conn.rp, loc, conn.lp);
	return(0);
}

static void BindListen(int port)
{
	socklen_t slt;
	struct sockaddr *sa;
	struct sockaddr_in sa4;
	struct sockaddr_in6 sa6;

	if(ipversion==4) {
		sa4.sin_family=AF_INET;
		sa4.sin_port=htons(port);
		sa4.sin_addr.s_addr=INADDR_ANY;
		sa=(struct sockaddr *)&sa4;
		slt=sizeof(sa4);
	} else {
		sa6.sin6_family=AF_INET6;
		sa6.sin6_port=htons(port);
		sa6.sin6_addr=in6addr_any;
		sa6.sin6_flowinfo=0;
		sa6.sin6_scope_id=0;
		sa=(struct sockaddr *)&sa6;
		slt=sizeof(sa6);
	}
	
	
	if(bind(s, sa, slt))
		LogError("bind");
	if(listen(s,3))
		LogError("listen");
	Log("Using IPv%i", ipversion);
}

void OpenListenSock(int port, int forcev4)
{
	int one=1;
	
	if (!forcev4) {
		if((s = socket(PF_INET6, SOCK_STREAM, 0)) < 0) { 
			if(errno!=EAFNOSUPPORT)
				LogError("socket");
			else
				Log("IPv6 not available");
		} else {
			if(setsockopt(s,SOL_SOCKET,SO_REUSEADDR,&one,sizeof(one)))
				LogError("setsockopt");
			ipversion=6;
			return(BindListen(port));
		}
	}
	
	if ((s = socket(PF_INET, SOCK_STREAM, 0)) < 0)
		LogError("socket");
	
	if(setsockopt(s,SOL_SOCKET,SO_REUSEADDR,&one,sizeof(one)))
		LogError("setsockopt");

	ipversion=4;
	return(BindListen(port));
}

char *ReadLine(void)
{
	static char buf[1024];
	static char line[64];
	static int len;
	int x;
	char *p;
	int l;
	fd_set rfs;
	struct timeval tv;

	while(!(p=memchr(buf, '\n', len))) {
		FD_ZERO(&rfs);
		FD_SET(s, &rfs);
		tv.tv_sec=TIMEOUT;
		tv.tv_usec=0;
		switch(select(s+1, &rfs, NULL, NULL, &tv)) {
		case -1:
			LogError("select");
		case 0:
			Log("Connection timed out");
			return(NULL);
		}
		switch((x=recv(s, buf+len, 1024-len, 0))) {
		case -1:
			LogError("recv");
		case 0:
			Log("Remote host closed connection");
			return(NULL);
		}
		len+=x;
		if(len==1024) {
			Log("Remote host flooded me");
			return(NULL);
		}
	}
	l=p-buf+1;
	if(l<4 || l>64) {
		Log("Received line to short/long");
		return(NULL);
	}
	if(*(p-1)=='\r') *(p-1)=0;
	*p=0;
	strcpy(line, buf);
	memcpy(buf, buf+l, len-l);
	len-=l;
	return(line);
}

void Reply_Error(char *error)
{
	char *buf;
	int l;
	
	l=asprintf(&buf, "%i, %i : ERROR : %s\r\n", req.lp, req.rp, error);
	if(send(s, buf, l, 0)==-1) LogError("send");
	free(buf);
}

void Reply_User(char *user)
{
	char *buf;
	int l;
	
	l=asprintf(&buf, "%i, %i : USERID : UNIX : %s\r\n", req.lp, req.rp, user);
	if(send(s, buf, l, 0)==-1) LogError("send");
	free(buf);
}
