#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>

#include "socket.h"
#include "log.h"
#include "request.h"

char *tokget(char *buf, int t)
{
	int i;
	char *p;

	p=strtok(buf, " \t");
	for(i=0; i<t; i++) {
		if(!p) return(NULL);
		p=strtok(NULL, " \t");
	}
	return(p);
}

static int isnumber(char *string)
{
	int i,l=strlen(string);
	char c;
	int x=0;
	
	for(i=0;i<l;i++) {
		c=string[i];
		if(!(isblank(c)||isdigit(c))) return(0);
		if(isblank(c)) if(x==1) x++;
		if(isdigit(c)) {
			if(!x) x++;
			else if(x==2) return(0);
		}
	}
	return(1);
}
	
int Parse_Request(char *line, int *lport, int *rport)
{
	char *tok0=line, *tok1;
	int l,r;

	tok1=index(line, ',');
	if(!tok1) return(-1);
	*tok1++=0;
	if(!(isnumber(tok0) && isnumber(tok1))) return(-1);
	l=atoi(tok0);
	r=atoi(tok1);
	if(l<=0 || l>65535 || r<=0 || r>65535) return(-1);

	*lport=l;
	*rport=r;
	return(0);
}

int tcp4(void)
{
	FILE *fd;
	char line[1024];
	char buf[34];
	char *p;
	
	if(!(fd=fopen("/proc/net/tcp","r"))) {
		Log("Unable to open /proc/net/tcp: %s", strerror(errno));
		return(-1);
	}
	snprintf(buf, 34, ": %08X:%04X %08X:%04X 01 ", conn.lh.s6_addr32[3], req.lp, conn.rh.s6_addr32[3], req.rp);
	while(fgets(line, 1024, fd)) {
		if(strstr(line, buf)) {
			if(!(p=tokget(line, 7))) {
				Log("something's wrong with /proc/net/tcp");
				fclose(fd);
				return(-1);
			}
			fclose(fd);
			return(atoi(p));
		}			
	}
	fclose(fd);
	return(-2);
}

int tcp6(void)
{
	FILE *fd;
	char line[1024];
	char buf[82];
	char *p;

	if(!(fd=fopen("/proc/net/tcp6", "r"))) {
		Log("Unable to open /proc/net/tcp6: %s", strerror(errno));
		return(-1);
	}
	snprintf(buf, 82, ": %08X%08X%08X%08X:%04X %08X%08X%08X%08X:%04X 01 ",
			conn.lh.s6_addr32[0], conn.lh.s6_addr32[1], conn.lh.s6_addr32[2],
			conn.lh.s6_addr32[3], req.lp, conn.rh.s6_addr32[0], 
			conn.rh.s6_addr32[1], conn.rh.s6_addr32[2], conn.rh.s6_addr32[3],   
			req.rp);
	while(fgets(line, 1024, fd)) {
		if(strstr(line, buf)) {
			if(!(p=tokget(line, 7))) {
				Log("something's wrong with /proc/net/tcp6");
				fclose(fd);
				return(-1);
			}
			fclose(fd);
			return(atoi(p));
		}			
	}
	fclose(fd);
	return(-2);
}

