// T3DOCV.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "t3docv.h"
#include "t3main.h"

#include <strstream>
using namespace std;

/*################################################################################################*/

gnome_docv * gnome_docv::glade_modal_dialog_owner = NULL;

gnome_docv::gnome_docv(ostream * p1, gnome_class_factory & p2) :
	docview(p1, p2), model_simple(p1, p2)
{
	child = NULL;
}

gnome_docv::~gnome_docv(void)
{
	// check the graphics_view_vector for any "detached" views, and call gtk_widget_destroy for them.
	// the "attached" views, the ones that are linked to the GtkNotebook, will be destroyed with the notebook.
	// ok, this is a bit ugly solution, but see gnome_graphics_view::popup_ViewsAttachDetach() for more comments...
	
	for (i32u n1 = 0;n1 < graphics_view_vector.size();n1++)
	{
		gnome_graphics_view * gv = dynamic_cast<gnome_graphics_view *>(graphics_view_vector[n1]);
		if (gv != NULL && gv->detached != NULL) gtk_widget_destroy(GTK_WIDGET(gv->detached));
	}
}

// this is effectively a ctor for gnome_docv, but it's moved here to avoid pure virtual function calls
// (GetFullProjectFileName(), at least). This must be called right after ctor returns, and only once!!!

// any SMARTER and MORE SECURE ways to do this???

void gnome_docv::InitGnomeMDIChild(void)
{
	if (child != NULL)
	{
		cout << "PANIC: multiple calls to gnome_docv::InitGnomeMDIChild()!!!" << endl;
		exit(EXIT_FAILURE);
	}
	
	child = gnome_mdi_generic_child_new(GetFullProjectFileName());
	
	gpointer userdata = (docview *) this;
	gtk_object_set_user_data(GTK_OBJECT(child), userdata);
	//cout << "SET_USER_DATA " << userdata << endl;
	
	gtk_signal_connect(GTK_OBJECT(child), "destroy", GTK_SIGNAL_FUNC(gnome_mdi_app::DestroyChildHandler), NULL);
	
	gnome_mdi_generic_child_set_config_func(child, GetConfigString, NULL);
	gnome_mdi_generic_child_set_view_creator(child, GnomeViewCreator, NULL);
	
//gnome_mdi_child_set_menu_template(GNOME_MDI_CHILD(child), ???);	// we use the popup-menu...

	gnome_mdi_add_child(gnome_mdi_app::GetInstance()->mdi, GNOME_MDI_CHILD(child));
	gnome_mdi_add_view(gnome_mdi_app::GetInstance()->mdi, GNOME_MDI_CHILD(child));
	
	// always add a treelist view and a graphics view by default.
	// add the treelist one first so that the graphics one remains on top...
	
	CreateTreeListView();
	AddGraphicsView();
	
	char messagebuffer[256];
	const char * ext = GetProjectFileNameExtension();
	ostrstream str(messagebuffer, sizeof(messagebuffer));
	str << "A new project created; " << ext << " (";
	if (!strcmp("mm2gp", ext)) str << "simplified forcefield)." << endl << ends;
	else if (dynamic_cast<qm1_mdl *>(this) != NULL) str << "quantum mechanics)." << endl << ends;
	else if (dynamic_cast<mm1_mdl *>(this) != NULL) str << "molecular mechanics)." << endl << ends;
	else str << "???)." << endl << ends;
	PrintToLog(messagebuffer);
}

char * gnome_docv::GetConfigString(GnomeMDIChild * child, gpointer)
{
	return g_strdup(child->name);
}

GtkWidget * gnome_docv::GnomeViewCreator(GnomeMDIChild * child, gpointer)
{
	gpointer userdata = gtk_object_get_user_data(GTK_OBJECT(child));
	//cout << "GET_USER_DATA " << userdata << endl;
	
	docview * docv1 = (docview *) userdata;
	gnome_docv * docv2 = dynamic_cast<gnome_docv *>(docv1);
	
	if (docv2 == NULL)
	{
		cout << "fatal error : cast failed at gnome_docv::GnomeViewCreator()." << endl;
		exit(EXIT_FAILURE);
	}
	
	// the viewing widget is a vertically paned widget.
	// it contains the notebook and the text log.
	
	docv2->paned_widget = GTK_WIDGET(gtk_vpaned_new());
	
	docv2->notebook = gtk_notebook_new();
	
	docv2->logpos = 0;	// the position counter for gtk_editable_insert_text.
	docv2->scroll_widget = gtk_scrolled_window_new(NULL, NULL);
//docv2->log_buffer = gtk_text_buffer_new(NULL);	in GTK2
//gtk_text_view_new_with_buffer(docv2->log_buffer);	in GTK2
	docv2->log_widget = gtk_text_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(docv2->scroll_widget), GTK_WIDGET(docv2->log_widget));
	gtk_widget_show(GTK_WIDGET(docv2->log_widget)); gtk_widget_show(GTK_WIDGET(docv2->scroll_widget));
	
	gtk_paned_add1(GTK_PANED(docv2->paned_widget), GTK_WIDGET(docv2->notebook));
	gtk_paned_add2(GTK_PANED(docv2->paned_widget), GTK_WIDGET(docv2->scroll_widget));
	
	return docv2->paned_widget;
}

void gnome_docv::UpdateAllWindowTitles()
{
	// mdi_child_name and view titles are somewhat different issues now; check this!!!
	// we should change mdi_child_name when the project name changes, but this function is for setting the view titles.
	
	static char childnamebuff[256];
	ostrstream cnstr(childnamebuff, sizeof(childnamebuff));
	
	cnstr << GetProjectFileName(true);
	if (dynamic_cast<qm1_mdl *>(this) != NULL) cnstr << " (a QM project)";
	if (dynamic_cast<mm1_mdl *>(this) != NULL) cnstr << " (a MM project)";
	cnstr << ends;
	
	gnome_mdi_child_set_name(GNOME_MDI_CHILD(child), childnamebuff);
	docview::UpdateAllWindowTitles();
	
	event_SelectedObjectChanged();		// update the statusbar too
}

void gnome_docv::event_SelectedObjectChanged(void)
{
	// here we just set the new selection information for all statusbars...
	
	for (i32u n1 = 0;n1 < gnome_mdi_app::app_vector.size();n1++)
	{
		char txtbuff[256];
		ostrstream str(txtbuff, sizeof(txtbuff));
		
		str << project_filename << "." << GetProjectFileNameExtension() << " : ";
		if (selected_object) str << "selected object = " << selected_object->GetObjectName() << "." << ends;
		else str << "no selected object." << ends;
		
		GtkWidget * sb = gnome_mdi_app::app_vector[n1].statusbar;
		i32u context_id = gnome_mdi_app::app_vector[n1].context_id;
		
		gtk_statusbar_pop(GTK_STATUSBAR(sb), context_id);
		gtk_statusbar_push(GTK_STATUSBAR(sb), context_id, txtbuff);
	}
}

void gnome_docv::PrintToLog(const char * message)
{
	gtk_editable_insert_text(GTK_EDITABLE(log_widget), message, strlen(message), & logpos);
}

/*################################################################################################*/

// eof
