// T3DIALOG.CPP

// Copyright (C) 1999 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "t3dialog.h"

#include "utility.h"

/*################################################################################################*/

element_dialog * element_dialog::current_object = NULL;
GtkWidget * element_dialog::dialog = NULL;
GtkWidget * element_dialog::current_element_widget = NULL;

element_dialog::element_dialog(void)
{
	current_object = this;
	dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);		// request a modal window.
	
	gtk_window_set_title(GTK_WINDOW(dialog), "Set Current Element");
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
	
	GtkWidget * table = gtk_table_new(21, 38, TRUE);
	gtk_container_add(GTK_CONTAINER(dialog), table);
	
	int attachdata[ELEMENT_SYMBOLS][2] =
	{
		{ 1, 1 }, { 35, 1 }, { 1, 3 }, { 3, 3 }, { 25, 3 },		// B
		{ 27, 3 }, { 29, 3 }, { 31, 3 }, { 33, 3 }, { 35, 3 },		// Ne
		{ 1, 5 }, { 3, 5 }, { 25, 5 }, { 27, 5 }, { 29, 5 },		// P
		{ 31, 5 }, { 33, 5 }, { 35, 5 }, { 1, 7 }, { 3, 7 },		// Ca
		{ 5, 7 }, { 7, 7 }, { 9, 7 }, { 11, 7 }, { 13, 7 },		// Mn
		{ 15, 7 }, { 17, 7 }, { 19, 7 }, { 21, 7 }, { 23, 7 },		// Zn
		{ 25, 7 }, { 27, 7 }, { 29, 7 }, { 31, 7 }, { 33, 7 },		// Br
		{ 35, 7 }, { 1, 9 }, { 3, 9 }, { 5, 9 }, { 7, 9 },		// Zr
		{ 9, 9 }, { 11, 9 }, { 13, 9 }, { 15, 9 }, { 17, 9 },		// Rh
		{ 19, 9 }, { 21, 9 }, { 23, 9 }, { 25, 9 }, { 27, 9 },		// Sn
		{ 29, 9 }, { 31, 9 }, { 33, 9 }, { 35, 9 }, { 1, 11 },		// Cs
		{ 3, 11 }, { 5, 11 }, { 9, 16 }, { 11, 16 }, { 13, 16 },	// Nd
		{ 15, 16 }, { 17, 16 }, { 19, 16 }, { 21, 16 }, { 23, 16 },	// Tb
		{ 25, 16 }, { 27, 16 }, { 29, 16 }, { 31, 16 }, { 33, 16 },	// Yb
		{ 35, 16 }, { 7, 11 }, { 9, 11 }, { 11, 11 }, { 13, 11 },	// Re
		{ 15, 11 }, { 17, 11 }, { 19, 11 }, { 21, 11 }, { 23, 11 },	// Hg
		{ 25, 11 }, { 27, 11 }, { 29, 11 }, { 31, 11 }, { 33, 11 },	// At
		{ 35, 11 }, { 1, 13 }, { 3, 13 }, { 5, 13 }, { 9, 18 },		// Th
		{ 11, 18 }, { 13, 18 }, { 15, 18 }, { 17, 18 }, { 19, 18 },	// Am
		{ 21, 18 }, { 23, 18 }, { 25, 18 }, { 27, 18 }, { 29, 18 },	// Fm
		{ 31, 18 }, { 33, 18 }, { 35, 18 }, { 7, 13 }, { 9, 13 },	// Db
		{ 11, 13 }, { 13, 13 }, { 15, 13 }, { 17, 13 }, { 19, 13 }
	};
	
	GtkSignalFunc sf = (GtkSignalFunc) element_dialog::SignalHandler;
	GtkWidget * button;
	
	for (int n1 = 0; n1 < ELEMENT_SYMBOLS; n1++)
	{
		element tmp_element(n1 + 1);
		button = gtk_toggle_button_new_with_label(tmp_element.GetSymbol());
		
		if (n1 + 1 == element::current_element.GetAtomicNumber())
		{
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), true);
			current_element_widget = button;	// do we need this???
		}
		
		gtk_signal_connect(GTK_OBJECT(button), "clicked", sf, (void *) (n1 + 1));
		gtk_widget_show(button);

		int x = attachdata[n1][0]; int y = attachdata[n1][1];
		gtk_table_attach_defaults(GTK_TABLE(table), button, x, x + 2, y, y + 2);
	}
	
	gtk_widget_show(table);
	gtk_widget_show(dialog);
}

element_dialog::~element_dialog(void)
{
}

void element_dialog::SignalHandler(GtkWidget *, int signal)
{
	element::current_element = element(signal);
	cout << "current element is now " << element::current_element.GetSymbol() << endl;	// which docv???
	
	gtk_widget_destroy(dialog);
	delete current_object;		// the object was created with new!!!
}

/*################################################################################################*/

bondtype_dialog * bondtype_dialog::current_object = NULL;
GtkWidget * bondtype_dialog::dialog = NULL;
GtkWidget * bondtype_dialog::current_bond_widget = NULL;

bondtype_dialog::bondtype_dialog(void)
{
	current_object = this;
	dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);		// request a modal window.
	
	gtk_window_set_title(GTK_WINDOW(dialog), "Set Current Bondtype");
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
	
	GtkWidget * table = gtk_table_new((2 + 4), 6, TRUE);
	gtk_container_add(GTK_CONTAINER(dialog), table);
	
	char bt_symbols[4] = { 'S', 'C', 'D', 'T' };
	
	GtkSignalFunc sf = (GtkSignalFunc) bondtype_dialog::SignalHandler;
	GtkWidget * button;
	
	for (int n1 = 0;n1 < 4;n1++)
	{
		bondtype tmp_bondtype(bt_symbols[n1]);
		button = gtk_toggle_button_new_with_label(tmp_bondtype.GetString());
		
		if (bt_symbols[n1] == bondtype::current_bondtype.GetSymbol1())
		{
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), true);
			current_bond_widget = button;		// do we need this??
		}

		i32s long_bt_symbol = bt_symbols[n1];	// convert 8bit -> 32bit
		gtk_signal_connect(GTK_OBJECT(button), "clicked", sf, (void *) long_bt_symbol);
		gtk_widget_show(button);
		
		int x = 1; int y = n1 + 1;
		gtk_table_attach_defaults(GTK_TABLE(table), button, x, x + 4, y, y + 1);
	}
	
	gtk_widget_show(table);
	gtk_widget_show(dialog);
}

bondtype_dialog::~bondtype_dialog(void)
{
}

void bondtype_dialog::SignalHandler(GtkWidget *, int signal)
{
	bondtype::current_bondtype = bondtype((char) signal);
	cout << "current bondtype is now " << bondtype::current_bondtype.GetString() << endl;	// which docv???
	
	gtk_widget_destroy(dialog);
	delete current_object;		// the object was created with new!!!
}

/*################################################################################################*/

GtkWidget * file_dialog::dialog;

file_dialog::file_dialog(const char * title, const char * filter, const char * def_fn)
{
	dialog = gtk_file_selection_new(title);
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);		// request a modal window.
	
	if (filter != NULL) gtk_file_selection_complete(GTK_FILE_SELECTION(dialog), filter);
	if (def_fn != NULL) gtk_file_selection_set_filename(GTK_FILE_SELECTION(dialog), def_fn);
	
	gtk_signal_connect(GTK_OBJECT(dialog),
		"destroy", GTK_SIGNAL_FUNC(DestroyHandler), this);
		
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(dialog)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(OkButtonHandler), this);
		
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(dialog)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(CancelButtonHandler), this);
		
	gtk_widget_show(dialog);
}

file_dialog::~file_dialog(void)
{
}

void file_dialog::DestroyHandler(GtkWidget *, gpointer data)
{
	file_dialog * ref = (file_dialog *) data;
	
	delete ref;	// the object was created using new!!!
}

void file_dialog::OkButtonHandler(GtkWidget *, gpointer data)
{
	file_dialog * ref = (file_dialog *) data;
	
	// do not close the dialog if we had for example wrong file type...
	
	if (ref->OkEvent(gtk_file_selection_get_filename(GTK_FILE_SELECTION(dialog))))
	{
		gtk_widget_destroy(dialog);
	}
}

void file_dialog::CancelButtonHandler(GtkWidget *, gpointer data)
{
	file_dialog * ref = (file_dialog *) data;
	ref->CancelEvent();
	
	gtk_widget_destroy(dialog);
}

/*################################################################################################*/

gnome_docv * command_dialog::docv;
graphics_view * command_dialog::gv;

GtkWidget * command_dialog::dialog;
GtkWidget * command_dialog::entry;

command_dialog::command_dialog(gnome_docv * p1, graphics_view * p2, const char * def_str)
{
	docv = p1; gv = p2;
	
	dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);		// request a modal window.
	
	gtk_window_set_title(GTK_WINDOW(dialog), "Command Interpreter");
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_default_size(GTK_WINDOW(dialog), 400, 50);
	
	gtk_container_set_border_width(GTK_CONTAINER(dialog), 10);
	
	gtk_signal_connect(GTK_OBJECT(dialog), "destroy", GTK_SIGNAL_FUNC(DestroyHandler), this);
	
	GtkWidget * vbox = gtk_vbox_new(TRUE, 5);
	gtk_container_add(GTK_CONTAINER(dialog), vbox);
	
	entry = gtk_entry_new();
	if (def_str != NULL) gtk_entry_set_text(GTK_ENTRY(entry), def_str);
	
	GtkWidget * hbox = gtk_hbox_new(TRUE, 5);
	
	gtk_box_pack_start(GTK_BOX(vbox), entry, FALSE, TRUE, 0);
	gtk_widget_show(entry);
	
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
	
	GtkWidget * button_ok = gtk_button_new_with_label("OK");
	gtk_signal_connect(GTK_OBJECT(button_ok), "clicked", GTK_SIGNAL_FUNC(OkButtonHandler), this);
	
	GtkWidget * button_cancel = gtk_button_new_with_label("Cancel");
	gtk_signal_connect(GTK_OBJECT(button_cancel), "clicked", GTK_SIGNAL_FUNC(CancelButtonHandler), this);
	
	gtk_box_pack_start(GTK_BOX(hbox), button_ok, FALSE, TRUE, 0);
	gtk_widget_show(button_ok);
	
	gtk_box_pack_start(GTK_BOX(hbox), button_cancel, FALSE, TRUE, 0);
	gtk_widget_show(button_cancel);
	
	gtk_widget_show(hbox);
	gtk_widget_show(vbox);
	
	gtk_widget_show(dialog);
}

command_dialog::~command_dialog(void)
{
}

void command_dialog::DestroyHandler(GtkWidget *, gpointer data)
{
	command_dialog * ref = (command_dialog *) data;
	
	delete ref;	// the object was created using new!!!
}

void command_dialog::OkButtonHandler(GtkWidget *, gpointer data)
{
	command_dialog * ref = (command_dialog *) data;
	
	const char * command = gtk_entry_get_text(GTK_ENTRY(ref->entry));
	if (strlen(command) > 0) docv->ProcessCommandString(gv, command);
	
	gtk_widget_destroy(dialog);
}

void command_dialog::CancelButtonHandler(GtkWidget *, gpointer data)
{
	command_dialog * ref = (command_dialog *) data;
	
	gtk_widget_destroy(dialog);
}

/*################################################################################################*/

// eof
