// GLADE_DIALOG.CPP

// Copyright (C) 2002 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "glade_dialog.h"

#include "model.h"

#include <iostream>
#include <strstream>
using namespace std;

/*################################################################################################*/

glade_dialog::glade_dialog(const char * xmlfile)
{
	const char * path1 = model_simple::GetFullPrimaryFN(xmlfile);
	xml = glade_xml_new(path1, NULL);
	
	if (xml == NULL)
	{
		cout << "WARNING : primary path failed for glade XML file : " << xmlfile << endl;
		
		const char * path2 = model_simple::GetFullSecondaryFN("../src/target3/", xmlfile);
		xml = glade_xml_new(path2, NULL);
		
		if (xml == NULL)
		{
			cout << "ERROR: secondary path failed for glade XML file : " << xmlfile << endl;
			exit(EXIT_FAILURE);
		}
	}
}

glade_dialog::~glade_dialog(void)
{
	// need to do anything here to clean the xml object???
	// need to do anything here to clean the xml object???
	// need to do anything here to clean the xml object???
}

/*################################################################################################*/

// eof
