// MOLDYN_DIALOG.CPP

// Copyright (C) 2002 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "moldyn_dialog.h"

#include "t3mm1docv.h"
#include "t3mm2docv.h"

#include <gnome.h>

#include <iostream>
#include <strstream>
using namespace std;

/*################################################################################################*/

moldyn_dialog::moldyn_dialog(void) : glade_dialog("glade/moldyn_dialog.glade")
{
	dialog = glade_xml_get_widget(xml, "moldyn_dialog");
	if (dialog == NULL) { cout << "moldyn_dialog : glade_xml_get_widget() failed!!!" << endl; return; }
	
	// initialize the widgets...
	
	entry_nsteps = glade_xml_get_widget(xml, "entry_nsteps");
	entry_temperature = glade_xml_get_widget(xml, "entry_temperature");
	entry_timestep = glade_xml_get_widget(xml, "entry_timestep");
	
	char buffer[256];
	int value1 = 0; float value2 = 0.0; float value3 = 0.0;
	
	gnome_mm1_docv * owner_mm1 = dynamic_cast<gnome_mm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (owner_mm1 != NULL && owner_mm1->mdparam != NULL)
	{
		value1 = owner_mm1->mdparam->nsteps;
		value2 = owner_mm1->mdparam->temperature;
		value3 = owner_mm1->mdparam->timestep;
	}
	
	gnome_mm2_docv * owner_mm2 = dynamic_cast<gnome_mm2_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (owner_mm2 != NULL && owner_mm2->mdparam != NULL)
	{
		value1 = owner_mm2->mdparam->nsteps;
		value2 = owner_mm2->mdparam->temperature;
		value3 = owner_mm2->mdparam->timestep;
	}
	
	ostrstream str_nsteps(buffer, sizeof(buffer));
	str_nsteps << value1 << ends;
	gtk_entry_set_text(GTK_ENTRY(entry_nsteps), buffer);
	
	ostrstream str_grad(buffer, sizeof(buffer));
	str_grad << value2 << ends;
	gtk_entry_set_text(GTK_ENTRY(entry_temperature), buffer);
	
	ostrstream str_delta_e(buffer, sizeof(buffer));
	str_delta_e << value3 << ends;
	gtk_entry_set_text(GTK_ENTRY(entry_timestep), buffer);
	
	// connect the handlers...
	
	glade_xml_signal_connect_data(xml, "on_dialog_destroy", (GtkSignalFunc) handler_Destroy, (gpointer) this);
	
	glade_xml_signal_connect_data(xml, "on_button_ok_clicked", (GtkSignalFunc) handler_ButtonOK, (gpointer) this);
	glade_xml_signal_connect_data(xml, "on_button_cancel_clicked", (GtkSignalFunc) handler_ButtonCancel, (gpointer) this);
	
 	gnome_dialog_run(GNOME_DIALOG(dialog));		// MODAL
}

moldyn_dialog::~moldyn_dialog(void)
{
}

void moldyn_dialog::handler_Destroy(GtkWidget *, gpointer data)
{
	moldyn_dialog * ref = (moldyn_dialog *) data;
	cout << "handler_Destroy() : ref = " << ref << endl;
	
	delete ref;	// the object was created with new!!!
}

void moldyn_dialog::handler_ButtonOK(GtkWidget *, gpointer data)
{
	moldyn_dialog * ref = (moldyn_dialog *) data;
	cout << "handler_ButtonOK() : ref = " << ref << endl;
	
	// read the user's settings from widgets...
	
	GtkWidget * fileentry_fn = glade_xml_get_widget(ref->xml, "fileentry_fn");
	
	gchar * buffer;
	
	buffer = gtk_entry_get_text(GTK_ENTRY(ref->entry_nsteps));
	istrstream istr1(buffer, strlen(buffer) + 1);
	int value1; istr1 >> value1;
	
	buffer = gtk_entry_get_text(GTK_ENTRY(ref->entry_temperature));
	istrstream istr2(buffer, strlen(buffer) + 1);
	float value2; istr2 >> value2;
	
	buffer = gtk_entry_get_text(GTK_ENTRY(ref->entry_timestep));
	istrstream istr3(buffer, strlen(buffer) + 1);
	float value3; istr3 >> value3;
	
	buffer = gnome_file_entry_get_full_path(GNOME_FILE_ENTRY(fileentry_fn), FALSE);
	
	// store the values...
	
	gnome_mm1_docv * owner_mm1 = dynamic_cast<gnome_mm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (owner_mm1 != NULL && owner_mm1->mdparam != NULL)
	{
		owner_mm1->mdparam->confirm = true;
		
		owner_mm1->mdparam->nsteps = value1;
		owner_mm1->mdparam->temperature = value2;
		owner_mm1->mdparam->timestep = value3;
		strcpy(owner_mm1->mdparam->filename, buffer);
	}
	
	gnome_mm2_docv * owner_mm2 = dynamic_cast<gnome_mm2_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (owner_mm2 != NULL && owner_mm2->mdparam != NULL)
	{
		owner_mm2->mdparam->confirm = true;
		
		owner_mm2->mdparam->nsteps = value1;
		owner_mm2->mdparam->temperature = value2;
		owner_mm2->mdparam->timestep = value3;
		strcpy(owner_mm2->mdparam->filename, buffer);
	}
	
	// close the dialog...
	
	gtk_widget_destroy(ref->dialog);
}

void moldyn_dialog::handler_ButtonCancel(GtkWidget *, gpointer data)
{
	moldyn_dialog * ref = (moldyn_dialog *) data;
	cout << "handler_ButtonCancel() : ref = " << ref << endl;
	
	// close the dialog...
	
	gtk_widget_destroy(ref->dialog);
}

/*################################################################################################*/

// eof
