// GEOMOPT_DIALOG.CPP

// Copyright (C) 2002 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "geomopt_dialog.h"

#include "t3qm1docv.h"
#include "t3mm1docv.h"
#include "t3mm2docv.h"

#include <gnome.h>

#include <iostream>
#include <strstream>
using namespace std;

/*################################################################################################*/

geomopt_dialog::geomopt_dialog(void) : glade_dialog("glade/geomopt_dialog.glade")
{
	dialog = glade_xml_get_widget(xml, "geomopt_dialog");
	if (dialog == NULL) { cout << "geomopt_dialog : glade_xml_get_widget() failed!!!" << endl; return; }
	
	// initialize the widgets...
	
	entry_nsteps = glade_xml_get_widget(xml, "entry_nsteps");
	entry_grad = glade_xml_get_widget(xml, "entry_grad");
	entry_delta_e = glade_xml_get_widget(xml, "entry_delta_e");
	
	char buffer[64];
	
	int value1 = 0; // steps
	f64 value2 = 0.0; // grad
	f64 value3 = 0.0; // delta E
	
	gnome_mm1_docv * owner_mm1 = dynamic_cast<gnome_mm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (owner_mm1 != NULL && owner_mm1->goparam != NULL)
	{
		value1 = owner_mm1->goparam->treshold_nsteps;
		value2 = owner_mm1->goparam->treshold_grad;
		value3 = owner_mm1->goparam->treshold_delta_e;
	}
	
	gnome_mm2_docv * owner_mm2 = dynamic_cast<gnome_mm2_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (owner_mm2 != NULL && owner_mm2->goparam != NULL)
	{
		value1 = owner_mm2->goparam->treshold_nsteps;
		value2 = owner_mm2->goparam->treshold_grad;
		value3 = owner_mm2->goparam->treshold_delta_e;
	}
	
	gnome_qm1_docv * owner_qm1 = dynamic_cast<gnome_qm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (owner_qm1 != NULL && owner_qm1->goparam != NULL)
	{
		value1 = owner_qm1->goparam->treshold_nsteps;
		value2 = owner_qm1->goparam->treshold_grad;
		value3 = owner_qm1->goparam->treshold_delta_e;
	}
	
	ostrstream str_nsteps(buffer, sizeof(buffer));
	str_nsteps << value1 << ends;
	gtk_entry_set_text(GTK_ENTRY(entry_nsteps), buffer);
	
	ostrstream str_grad(buffer, sizeof(buffer));
	str_grad << value2 << ends;
	gtk_entry_set_text(GTK_ENTRY(entry_grad), buffer);
	
	ostrstream str_delta_e(buffer, sizeof(buffer));
	str_delta_e << value3 << ends;
	gtk_entry_set_text(GTK_ENTRY(entry_delta_e), buffer);
	
	// connect the handlers...
	
	glade_xml_signal_connect_data(xml, "on_dialog_destroy", (GtkSignalFunc) handler_Destroy, (gpointer) this);
	
	glade_xml_signal_connect_data(xml, "on_button_ok_clicked", (GtkSignalFunc) handler_ButtonOK, (gpointer) this);
	glade_xml_signal_connect_data(xml, "on_button_cancel_clicked", (GtkSignalFunc) handler_ButtonCancel, (gpointer) this);
	
 	gnome_dialog_run(GNOME_DIALOG(dialog));		// MODAL
}

geomopt_dialog::~geomopt_dialog(void)
{
}

void geomopt_dialog::handler_Destroy(GtkWidget *, gpointer data)
{
	geomopt_dialog * ref = (geomopt_dialog *) data;
	cout << "handler_Destroy() : ref = " << ref << endl;
	
	delete ref;	// the object was created with new!!!
}

void geomopt_dialog::handler_ButtonOK(GtkWidget *, gpointer data)
{
	geomopt_dialog * ref = (geomopt_dialog *) data;
	cout << "handler_ButtonOK() : ref = " << ref << endl;
	
	// read the user's settings from widgets...
	
	GtkWidget * cb_nsteps = glade_xml_get_widget(ref->xml, "checkbutton_nsteps");
	GtkWidget * cb_grad = glade_xml_get_widget(ref->xml, "checkbutton_grad");
	GtkWidget * cb_delta_e = glade_xml_get_widget(ref->xml, "checkbutton_delta_e");
	
	bool flag1 = true;	// nsteps
	i32s value1 = 0;
	
	bool flag2 = true;	// grad
	f64 value2 = 0.0;
	
	bool flag3 = true;	// delta_e
	f64 value3 = 0.0;
	
	gchar * buffer;
	
	flag1 = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cb_nsteps));
	buffer = gtk_entry_get_text(GTK_ENTRY(ref->entry_nsteps));
	istrstream istr1(buffer, strlen(buffer) + 1);
	istr1 >> value1;
	
	flag2 = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cb_grad));
	buffer = gtk_entry_get_text(GTK_ENTRY(ref->entry_grad));
	istrstream istr2(buffer, strlen(buffer) + 1);
	istr2 >> value2;
	
	flag3 = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cb_delta_e));
	buffer = gtk_entry_get_text(GTK_ENTRY(ref->entry_delta_e));
	istrstream istr3(buffer, strlen(buffer) + 1);
	istr3 >> value3;
	
	if (!flag1 && !flag2 && !flag3)
	{
		flag1 = true;
		cout << "WARNING: all termination tests were disabled!!! the nsteps test is forced." << endl;
	}
	
	// store the values...
	
	gnome_mm1_docv * owner_mm1 = dynamic_cast<gnome_mm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (owner_mm1 != NULL && owner_mm1->goparam != NULL)
	{
		owner_mm1->goparam->confirm = true;
		
		owner_mm1->goparam->enable_nsteps = flag1;
		owner_mm1->goparam->treshold_nsteps = value1;
		owner_mm1->goparam->enable_grad = flag2;
		owner_mm1->goparam->treshold_grad = value2;
		owner_mm1->goparam->enable_delta_e = flag3;
		owner_mm1->goparam->treshold_delta_e = value3;
	}
	
	gnome_mm2_docv * owner_mm2 = dynamic_cast<gnome_mm2_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (owner_mm2 != NULL && owner_mm2->goparam != NULL)
	{
		owner_mm2->goparam->confirm = true;
		
		owner_mm2->goparam->enable_nsteps = flag1;
		owner_mm2->goparam->treshold_nsteps = value1;
		owner_mm2->goparam->enable_grad = flag2;
		owner_mm2->goparam->treshold_grad = value2;
		owner_mm2->goparam->enable_delta_e = flag3;
		owner_mm2->goparam->treshold_delta_e = value3;
	}
	
	gnome_qm1_docv * owner_qm1 = dynamic_cast<gnome_qm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (owner_qm1 != NULL && owner_qm1->goparam != NULL)
	{
		owner_qm1->goparam->confirm = true;
		
		owner_qm1->goparam->enable_nsteps = flag1;
		owner_qm1->goparam->treshold_nsteps = value1;
		owner_qm1->goparam->enable_grad = flag2;
		owner_qm1->goparam->treshold_grad = value2;
		owner_qm1->goparam->enable_delta_e = flag3;
		owner_qm1->goparam->treshold_delta_e = value3;
	}
	
	// close the dialog...
	
	gtk_widget_destroy(ref->dialog);
}

void geomopt_dialog::handler_ButtonCancel(GtkWidget *, gpointer data)
{
	geomopt_dialog * ref = (geomopt_dialog *) data;
	cout << "handler_ButtonCancel() : ref = " << ref << endl;
	
	// close the dialog...
	
	gtk_widget_destroy(ref->dialog);
}

/*################################################################################################*/

// eof
