// FILE_EXPORT_DIALOG.CPP

// Copyright (C) 2002 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "file_export_dialog.h"

#include "filetrans.h"
#include "t3mm1docv.h"
#include "t3docv.h"

#include <gnome.h>

#include <iostream>
#include <strstream>
using namespace std;

/*################################################################################################*/

file_export_dialog::file_export_dialog(void) : glade_dialog("glade/file_export_dialog.glade")
{
	dialog = glade_xml_get_widget(xml, "file_export_dialog");
	if (dialog == NULL) { cout << "file_export_dialog : glade_xml_get_widget() failed!!!" << endl; return; }
	
	// initialize the widgets...
	
	GtkWidget * optmenu = glade_xml_get_widget(xml, "optionmenu1");
	GtkWidget * submenu = gtk_menu_new(); GtkWidget * item;
	
	item = gtk_menu_item_new_with_label("Automatic");			// insert item "automatic"...
	gtk_widget_show(item); gtk_menu_append(GTK_MENU(submenu), item);
	
	file_trans ft;
	for (unsigned int i = 0;i < ft.NumExports();i++)			// insert other items...
	{
		item = gtk_menu_item_new_with_label((char *) ft.GetExportDescription(i).c_str());
		gtk_widget_show(item); gtk_menu_append(GTK_MENU(submenu), item);
	}
	
	gtk_option_menu_set_menu(GTK_OPTION_MENU(optmenu), submenu);
	
	// connect the handlers...
	
	glade_xml_signal_connect_data(xml, "on_dialog_destroy", (GtkSignalFunc) handler_Destroy, (gpointer) this);
	
	glade_xml_signal_connect_data(xml, "on_button_ok_clicked", (GtkSignalFunc) handler_ButtonOK, (gpointer) this);
	glade_xml_signal_connect_data(xml, "on_button_cancel_clicked", (GtkSignalFunc) handler_ButtonCancel, (gpointer) this);
	
	gnome_dialog_run(GNOME_DIALOG(dialog));		// MODAL
}

file_export_dialog::~file_export_dialog(void)
{
}

void file_export_dialog::handler_Destroy(GtkWidget *, gpointer data)
{
	file_export_dialog * ref = (file_export_dialog *) data;
	cout << "handler_Destroy() : ref = " << ref << endl;
	
	delete ref;	// the object was created with new!!!
}

void file_export_dialog::handler_ButtonOK(GtkWidget *, gpointer data)
{
	file_export_dialog * ref = (file_export_dialog *) data;
	cout << "handler_ButtonOK() : ref = " << ref << endl;

	gnome_mm1_docv * owner = dynamic_cast<gnome_mm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (!owner) cout << "ERROR: cast failed in file_export_dialog::handler_ButtonOK()." << endl;
	
	// export...
	
	GtkWidget * optmenu = glade_xml_get_widget(ref->xml, "optionmenu1");
	GtkWidget * submenu = gtk_option_menu_get_menu(GTK_OPTION_MENU(optmenu));
	GtkWidget * item = gtk_menu_get_active(GTK_MENU(submenu));
	int index = g_list_index(GTK_MENU_SHELL(submenu)->children, item);
	
	GtkWidget * fileentry = glade_xml_get_widget(ref->xml, "fileentry1");
	gchar * filename = gnome_file_entry_get_full_path(GNOME_FILE_ENTRY(fileentry), FALSE);
	
	ofstream ofile;
	strstream intermed;
	file_trans translator;
	
	owner->WriteStream(intermed);
	istrstream interInput(intermed.str());
	
	if (index == 0) 	// Automatic detection
	{
		if (!translator.CanExport(filename))
		{
			owner->err->ErrorMessage("Cannot export that file type.");
			return;
		}
		
		ofile.open(filename, ios::out);
		translator.Export(filename, interInput, ofile);
		ofile.close();
	}
	else			// By type picked by the user
	{
		ofile.open(filename, ios::out);
		translator.Export(filename, index - 1, interInput, ofile);
		ofile.close();
	}
	
	owner->ParseProjectFileNameAndPath(filename);
	owner->UpdateAllWindowTitles();
	
	// close the dialog...
	
	gtk_widget_destroy(ref->dialog);
}

void file_export_dialog::handler_ButtonCancel(GtkWidget *, gpointer data)
{
	file_export_dialog * ref = (file_export_dialog *) data;
	cout << "handler_ButtonCancel() : ref = " << ref << endl;
	
	// close the dialog...
	
	gtk_widget_destroy(ref->dialog);
}

/*################################################################################################*/

// eof
