// MM3DOCV.H : a graphical user interface for mm3-models (just a viewer).

// Copyright (C) 2000 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MM3DOCV_H
#define MM3DOCV_H

#ifdef ENABLE_GRAPHICS

class mm3_docv;

/*################################################################################################*/

#include "docview.h"
#include "mm3mdl.h"

/*################################################################################################*/

class mm3_docv : virtual public docview, public mm3_mdl
{
	public:
	
	public:
	
	mm3_docv(ostream *, graphics_class_factory &);
	virtual ~mm3_docv(void);

	fGL GetDefaultFocus(void);		// virtual
	
	const char * GetType(void);			// virtual
	color_mode * GetDefaultColorMode(void);		// virtual
	
	void SelectAll(void);				// virtual
	void InvertSelection(void);			// virtual
	
	void InitGL(void);				// virtual
	void Render(graphics_view *, rmode);		// virtual
	
	void Center(transformer *);			// virtual
	void Transform(transformer *);			// virtual
	
	void DrawEvent(graphics_view *, vector<iGLu> &);	// virtual
	void EraseEvent(graphics_view *, vector<iGLu> &);	// virtual
	void SelectEvent(graphics_view *, vector<iGLu> &);	// virtual
	void MeasureEvent(graphics_view *, vector<iGLu> &);	// virtual
	
	void ProcessCommandString(graphics_view *, const char *);	// virtual
};

/*################################################################################################*/

#endif	// ENABLE_GRAPHICS
#endif	// MM3DOCV_H

// eof
