#include "queue.h"

// constructor. initialize all values
queue::queue()
{
    first=0;
    last=0;
    maxlen=-1;
    len=0;
    iterator=0;
}

// delete an element given by a ptr to the element itself (NOT a copy)
int queue::del(void *elem)
{
    queueelem *p, *prev;
    
    if (!elem)
        return 0;
    if (!first)
        return 0;

    // if it is the first element
    if (elem==first->elem)
    {
        first=first->next;
        iterator=0; // if iterator was on the first element, set to 0 --> next call will give the new first element
        if (!first)
            last=0;
        return 1;
    }

    // we know it cant be the first element!!!
    prev=0;
    p=first;
    while (p)
    {
        if (p->elem==elem)
        {
            if (prev) // should always be true (as elem!=first)
            {
                prev->next=p->next;
                if (last==p)
                    last=prev;
                if (iterator==p) // update iterator
                    iterator=prev;
                delete(p);
                return 1;
            }
        }
        prev=p;
        p=p->next;
    }
    return 0;
}

// add an element to the queue
int queue::add(void *elem)
{
    class queueelem *qe;

    if (!elem)
        return 0;
    // is queue full ?
    if ((len>=maxlen) && (maxlen!=-1))
        return 0;

    qe=new queueelem;
    if (qe==0)
        return 0;

    qe->elem=elem;
    qe->next=0;
    if (!last)
	first=last=qe;
    else
    {
    	last->next=qe;
        last=qe;
    }
    len++;
    return 1;
}

// set a maximum size for a queue (WARNING: does not delete elements if queue is already > maxlen)
void queue::setLength(int newmaxlen)
{
    maxlen=newmaxlen;
}

// get an element AND remove it from the queue
void *queue::get()
{
    // queue empty?
    if (!first)
        return 0;

    class queueelem *temp;
    void *elem=first->elem;

    temp=first;
    first=first->next;
    if (!first)
        last=0;
    delete(temp);

    len--;

    return elem;
}

// reset global iterator
void queue::rewind()
{
    iterator=0;
}

// get next element of queue without deleteing it from the queue. Using global iterator
// only one global iterator may be used for one queue at one time.
void *queue::next_element()
{
    if (!iterator)
        iterator=first;
    else
        iterator=iterator->next;

    if (iterator)
        return iterator->elem;
    else
        return 0;
}

bool queue::isFull()
{
    return ((len>=maxlen) && (maxlen!=-1));
}
