/***************************************************************************
                          FLGroupByQuery.h  -  description
                             -------------------
    begin                : dom jun 23 2002
    copyright            : (C) 2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLGROUPBYQUERY_H
#define FLGROUPBYQUERY_H

#include <qstring.h>

/** Representa un nivel de agrupamiento de una consulta.

    Esta clase sirve para adaptar el contenido de una consulta a los niveles de
    agrupamiento que requiere la librera Kugar.

    @author Federico Albujer Zornoza
    @version 0.4 */
class FLGroupByQuery
{

    public:

    /** constructor.

        @param  l   Nivel de agrupamiento
        @param  f   Nombre del campo por el que se agrupa */
    FLGroupByQuery( const int l, const QString & f );

    /** destructor */
    ~FLGroupByQuery();

    /** Obtiene el nivel de agrupamiento.

        @return Nivel de agrupamiento */
    const int level() const
    {
        return level_;
    }

    /** Obtiene el nombre del campo por el que se agrupa.

        @return Nombre del campo */
    const QString & field () const
    {
        return field_;
    }

    private:

    /** Nivel de agrupamiento */
    int level_;

    /** Nombre del campo por el que se agrupa */
    QString field_;
};

#endif
