#include <gtk/gtk.h>
#include "entity.h"
#include "gtk-common.h"


static gint
rendgtk_gtkmain_do_iteration (ENode * node, EBuf * attr, EBuf * value)
{
    if (ebuf_equal_str (value, "true")) {
        while (gtk_events_pending ())
            gtk_main_iteration ();
    }

    enode_attrib_quiet (node, attr->str, ebuf_new_with_str (""));

    return (TRUE);
}

void
gtkmain_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    element = g_new0 (Element, 1);

    element->render_func = NULL;
    element->destroy_func = NULL;
    element->parent_func = NULL;
    element->tag = "gtk-main";
    element->description =
	"Create a link to the gtk mainloop.";
    element_register (element);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "do-iteration";
    e_attr->description = "Execute an iteration of the gtk mainloop, allowing any queued events to be handled.";
    e_attr->value_desc = "boolean";
    e_attr->possible_values = "true,false";
    e_attr->set_attr_func = rendgtk_gtkmain_do_iteration;
    element_register_attrib (element, e_attr);
}



