/*
 *  ---------
 * |.**> <**.|  CardContact
 * |*       *|  Software & System Consulting
 * |*       *|  Minden, Germany
 * |**> <**|  Copyright (c) 1999. All rights reserved
 *  --------- 
 *
 * See file LICENSE for details on licensing
 *
 * Abstract :       Defines types/names for ECO5000 handling
 *
 * Author :         Frank Thater (FTH)
 *
 * Last modified:   03/23/2000
 *
 *****************************************************************************/
 
#ifndef _ECO5000_H_
#define _ECO5000_H_

#include "sercom.h"                     /* For definition of HANDLE          */

                             
/* Structure for handling one ECO5000                                        */

#define MAX_ATR     34
#define HBSIZE      15
#define FWSIZE      5
#define MAX_READER  8

#define SYNC_ICC    0x0000
#define ASYNC_ICC   0x0001                           
#define UNKNOWN     0x0002

#define MC_2WBP     0x0A
#define MC_3WBP     0x09
#define MC_SDAP     0x08

#define ON          0x04
#define OFF         0x05

#define ERR_TIMEOUT -10
#define ERR_EDC     -11
 

/* Pointer to specific CD_DATA handler                                       */

struct eco5000_t {
    unsigned short    ctn;                /* Card terminal number               */
    HANDLE            fh;                 /* File handle for serial port        */
    int               Baud;               /* Current baudrate                   */
    int               RXStatus;           /* Current status of RX processing    */
    unsigned char     Firmware[FWSIZE+1]; /* Holds Reader Firmware Version      */
    unsigned char     ATR[MAX_ATR];       /* Last ATR received from the card    */
    unsigned char     LenOfATR;           /* Length of ATR                      */
    unsigned char     NumOfHB;            /* Number of HB                       */
    unsigned char     HCC[HBSIZE];        /* History Bytes                      */
    unsigned char     Type;               /* Type of inserted Card              */
    unsigned char     disableRX_ON;       /* indicates support for NEW T=0 prot */
    int               AvailProt;          /* Protocols indicated in ATR         */
    int               Protocol;           /* Handler module providing protocol  */
    int               Indirect;           /* Use indirect character convention  */
    int               Specific;           /* Specific mode indicator            */
    int               D;                  /* Baud rate conversion factor        */
    int               DI;                 /* Indicated baud rate conversion     */
    int               FI;                 /* Indicated clock conversion rate    */
    unsigned char     T0_WI;              /* Work waiting time index            */
    unsigned char     T1_IFSC;            /* Information field size             */
    unsigned char     T1_CWI;             /* Character waiting time index       */
    unsigned char     T1_BWI;             /* Block waiting time index           */
    int               (*CTModFunc)(struct eco5000_t *,
				   unsigned int,         /* length of command  */
				   unsigned char *,      /* command            */
				   unsigned int *,       /* length of response */
				   unsigned char *);     /* response           */
    union {
	struct ecoT0_t      *t0;
	struct ecoT1_t      *t1;
	struct memorycard_t *card;
    }                 Data;
};

typedef int (*CTModFunc_t) (struct eco5000_t *,        /* specified ECO Data */
                            unsigned int,              /* length of command  */
                            unsigned char *,           /* command            */
                            unsigned int *,            /* length of response */
                            unsigned char *);          /* response           */


/* Version ID String of ECO firmware */

#define ECO_V201        "V2.01"
#define ECO_V223        "V2.23"

                                    
/* Status response values for commands                                       */

#define ACK             0x80
#define ACK_CVCC_OFF    0x81
#define ACK_CVCC_ON     0x82
#define NACK_PAR        0x8E
#define NACK_CMD        0x8F


/* various ECO5000 commands */
#define RESET                   0x00
#define POWER_ON                0x01
#define POWER_OFF               0x02
#define SET_RESET               0x03
#define CLR_RESET               0x04
#define CLOCK_ON                0x05
#define CLOCK_OFF               0x06
#define SET_CLOCK               0x07
#define CLR_CLOCK               0x08
#define SET_IO                  0x09
#define CLR_IO                  0x0A
#define READ_IO                 0x0B
#define SET_T0                  0x0C
#define SET_T1                  0x0D
#define RX_ON                   0x0E
#define RX_OFF                  0x0F
#define READ_POWER              0x10
#define READ_CARD_IN            0x11
#define READ_RESET              0x12
#define READ_CLOCK              0x13
#define GET_VERSION             0x14
#define SET_DIRECT_CONVENTION   0x15
#define SET_INDIRECT_CONVENTION 0x16
#define SET_CTS                 0x17
#define CLR_CTS                 0x18
#define SYNC_ATR                0x19
#define SET_P05                 0x1A
#define CLR_P05                 0x1B
#define SET_P06                 0x1C
#define CLR_P06                 0x1D
#define SET_RESET_RX_ON         0x1E
#define SET_BAUDRATE            0x1F
#define READ_BYTE_I2C           0x24
#define READ_16BYTE_I2C         0x25
#define WRITE_BYTE_I2C          0x26
#define READ_BYTE_I2C_64K       0x27
#define READ_16BYTE_I2C_64K     0x28
#define WRITE_BYTE_I2C_64K      0x29
#define RESET_4442              0x30
#define COMMAND_4442            0x31
#define READ_4442               0x32
#define CLOCK_4442              0x33
#define CLOCK_ON_RX_ON          0x3D
#define READ_P05                0x3E
#define READ_P06                0x3F
#define COMMAND_4428            0x40
#define READ_4428               0x41
#define CLOCK_4428              0x42

/* Commands for new ECO firmware */
#define WRITE_BLOCK_I2C_64K     0x2A
#define READ_BLOCK_I2C_64K      0x2B
#define WRITE_BYTE_INT_I2C      0x2C
#define READ_BYTE_INT_I2C       0x2D 
#define SET_T0_NEW              0x34

#endif


