/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.utils.NodeVector;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class NodeSetDTM
extends NodeVector
implements DTMIterator,
Cloneable {
    DTMManager m_manager;
    protected transient int m_next = 0;
    protected transient boolean m_mutable = true;
    protected transient boolean m_cacheNodes = true;
    protected int m_root = -1;
    private transient int m_last = 0;

    public NodeSetDTM(int n, int n2, DTMManager dTMManager) {
        super(n);
        this.m_manager = dTMManager;
    }

    public NodeSetDTM(int n, DTMManager dTMManager) {
        this.m_manager = dTMManager;
        this.addNode(n);
    }

    public NodeSetDTM(DTMIterator dTMIterator) {
        this.m_manager = dTMIterator.getDTMManager();
        this.m_root = dTMIterator.getRoot();
        this.addNodes(dTMIterator);
    }

    public NodeSetDTM(DTMManager dTMManager) {
        this.m_manager = dTMManager;
    }

    public NodeSetDTM(NodeSetDTM nodeSetDTM) {
        this.m_manager = nodeSetDTM.getDTMManager();
        this.m_root = nodeSetDTM.getRoot();
        this.addNodes(nodeSetDTM);
    }

    public NodeSetDTM(NodeList nodeList, XPathContext xPathContext) {
        this.m_manager = xPathContext.getDTMManager();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            int n3 = xPathContext.getDTMHandleFromNode(node);
            this.addNodeInDocOrder(n3, xPathContext);
            ++n2;
        }
    }

    public NodeSetDTM(NodeIterator nodeIterator, XPathContext xPathContext) {
        Node node;
        this.m_manager = xPathContext.getDTMManager();
        while ((node = nodeIterator.nextNode()) != null) {
            int n = xPathContext.getDTMHandleFromNode(node);
            this.addNodeInDocOrder(n, xPathContext);
        }
    }

    public void addElement(int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        super.addElement(n);
    }

    public void addNode(int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        this.addElement(n);
    }

    public int addNodeInDocOrder(int n, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        return this.addNodeInDocOrder(n, true, xPathContext);
    }

    public int addNodeInDocOrder(int n, boolean bl, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        int n2 = -1;
        if (bl) {
            int n3 = this.size();
            int n4 = n3 - 1;
            while (n4 >= 0) {
                int n5 = this.elementAt(n4);
                if (n5 == n) {
                    n4 = -2;
                    break;
                }
                DTM dTM = xPathContext.getDTM(n);
                if (!dTM.isNodeAfter(n, n5)) break;
                --n4;
            }
            if (n4 != -2) {
                n2 = n4 + 1;
                this.insertElementAt(n, n2);
            }
        } else {
            n2 = this.size();
            boolean bl2 = false;
            int n6 = 0;
            while (n6 < n2) {
                if (n6 == n) {
                    bl2 = true;
                    break;
                }
                ++n6;
            }
            if (!bl2) {
                this.addElement(n);
            }
        }
        return n2;
    }

    public void addNodes(DTMIterator dTMIterator) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        if (dTMIterator != null) {
            int n;
            while ((n = dTMIterator.nextNode()) != -1) {
                this.addElement(n);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addNodesInDocOrder(DTMIterator var1_1, XPathContext var2_2) {
        if (this.m_mutable) ** GOTO lbl5
        throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
lbl-1000:
        // 1 sources

        {
            this.addNodeInDocOrder(var3_3, var2_2);
lbl5:
            // 2 sources

            ** while ((var3_3 = var1_1.nextNode()) != -1)
        }
lbl6:
        // 1 sources

    }

    public void allowDetachToRelease(boolean bl) {
    }

    public void appendNodes(NodeVector nodeVector) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        super.appendNodes(nodeVector);
    }

    public Object clone() throws CloneNotSupportedException {
        NodeSetDTM nodeSetDTM = (NodeSetDTM)super.clone();
        return nodeSetDTM;
    }

    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        NodeSetDTM nodeSetDTM = (NodeSetDTM)this.clone();
        nodeSetDTM.reset();
        return nodeSetDTM;
    }

    public boolean contains(int n) {
        this.runTo(-1);
        return super.contains(n);
    }

    public void detach() {
    }

    public int elementAt(int n) {
        this.runTo(n);
        return super.elementAt(n);
    }

    public int getAxis() {
        return -1;
    }

    public int getCurrentNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSetDTM can not do indexing or counting functions!");
        }
        int n = this.m_next;
        int n2 = this.m_next < this.m_firstFree ? this.elementAt(this.m_next) : -1;
        this.m_next = n;
        return n2;
    }

    public int getCurrentPos() {
        return this.m_next;
    }

    public DTM getDTM(int n) {
        return this.m_manager.getDTM(n);
    }

    public DTMManager getDTMManager() {
        return this.m_manager;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public DTMFilter getFilter() {
        return null;
    }

    public int getLast() {
        return this.m_last;
    }

    public int getLength() {
        this.runTo(-1);
        return this.size();
    }

    public int getRoot() {
        if (this.m_root == -1) {
            if (this.size() > 0) {
                return this.item(0);
            }
            return -1;
        }
        return this.m_root;
    }

    public boolean getShouldCacheNodes() {
        return this.m_cacheNodes;
    }

    public int getWhatToShow() {
        return -17;
    }

    public int indexOf(int n) {
        this.runTo(-1);
        return super.indexOf(n);
    }

    public int indexOf(int n, int n2) {
        this.runTo(-1);
        return super.indexOf(n, n2);
    }

    public void insertElementAt(int n, int n2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        super.insertElementAt(n, n2);
    }

    public void insertNode(int n, int n2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        this.insertElementAt(n, n2);
    }

    public boolean isDocOrdered() {
        return true;
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public boolean isMutable() {
        return this.m_mutable;
    }

    public int item(int n) {
        this.runTo(n);
        return this.elementAt(n);
    }

    public int nextNode() {
        if (this.m_next < this.size()) {
            int n = this.elementAt(this.m_next);
            ++this.m_next;
            return n;
        }
        return -1;
    }

    public int previousNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSetDTM can not iterate to a previous node!");
        }
        if (this.m_next - 1 > 0) {
            --this.m_next;
            return this.elementAt(this.m_next);
        }
        return -1;
    }

    public void removeAllElements() {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        super.removeAllElements();
    }

    public boolean removeElement(int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        return super.removeElement(n);
    }

    public void removeElementAt(int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        super.removeElementAt(n);
    }

    public void removeNode(int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        this.removeElement(n);
    }

    public void reset() {
        this.m_next = 0;
    }

    public void runTo(int n) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSetDTM can not do indexing or counting functions!");
        }
        this.m_next = n >= 0 && this.m_next < this.m_firstFree ? n : this.m_firstFree - 1;
    }

    public void setCurrentPos(int n) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSetDTM can not do indexing or counting functions!");
        }
        this.m_next = n;
    }

    public void setElementAt(int n, int n2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        super.setElementAt(n, n2);
    }

    public void setEnvironment(Object object) {
    }

    public void setItem(int n, int n2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        super.setElementAt(n, n2);
    }

    public void setLast(int n) {
        this.m_last = n;
    }

    public void setRoot(int n, Object object) {
    }

    public void setShouldCacheNodes(boolean bl) {
        if (!this.isFresh()) {
            throw new RuntimeException("Can not call setShouldCacheNodes after nextNode has been called!");
        }
        this.m_cacheNodes = bl;
        this.m_mutable = true;
    }

    public int size() {
        return super.size();
    }
}

