/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultErrorHandler
implements ErrorHandler,
ErrorListener {
    PrintWriter m_pw;

    public DefaultErrorHandler() {
        this.m_pw = new PrintWriter(System.err, true);
    }

    public DefaultErrorHandler(PrintStream printStream) {
        this.m_pw = new PrintWriter(printStream, true);
    }

    public DefaultErrorHandler(PrintWriter printWriter) {
        this.m_pw = printWriter;
    }

    public static void ensureLocationSet(TransformerException transformerException) {
        SourceLocator sourceLocator = null;
        Throwable throwable = transformerException;
        do {
            SourceLocator sourceLocator2;
            if (throwable instanceof SAXParseException) {
                sourceLocator = new SAXSourceLocator((SAXParseException)throwable);
                continue;
            }
            if (!(throwable instanceof TransformerException) || (sourceLocator2 = throwable.getLocator()) == null) continue;
            sourceLocator = sourceLocator2;
        } while ((throwable = throwable instanceof TransformerException ? throwable.getCause() : (throwable instanceof SAXException ? ((SAXException)throwable).getException() : null)) != null);
        transformerException.setLocator(sourceLocator);
    }

    public void error(TransformerException transformerException) throws TransformerException {
        throw transformerException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        throw transformerException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public static void printLocation(PrintStream printStream, TransformerException transformerException) {
        DefaultErrorHandler.printLocation(new PrintWriter(printStream), (Throwable)transformerException);
    }

    public static void printLocation(PrintWriter printWriter, Throwable throwable) {
        Object object;
        SourceLocator sourceLocator = null;
        Throwable throwable2 = throwable;
        do {
            if (throwable2 instanceof SAXParseException) {
                sourceLocator = new SAXSourceLocator((SAXParseException)throwable2);
                continue;
            }
            if (!(throwable2 instanceof TransformerException) || (object = ((TransformerException)throwable2).getLocator()) == null) continue;
            sourceLocator = object;
        } while ((throwable2 = throwable2 instanceof TransformerException ? ((TransformerException)throwable2).getCause() : (throwable2 instanceof WrappedRuntimeException ? ((WrappedRuntimeException)throwable2).getException() : (throwable2 instanceof SAXException ? ((SAXException)throwable2).getException() : null))) != null);
        if (sourceLocator != null) {
            object = sourceLocator.getPublicId() != sourceLocator.getPublicId() ? sourceLocator.getPublicId() : (sourceLocator.getSystemId() != null ? sourceLocator.getSystemId() : "SystemId Unknown");
            printWriter.print(String.valueOf(object) + "; Line " + sourceLocator.getLineNumber() + "; Column " + sourceLocator.getColumnNumber() + "; ");
        } else {
            printWriter.print("(Location of error unknown)");
        }
    }

    public void warning(TransformerException transformerException) throws TransformerException {
        DefaultErrorHandler.printLocation(this.m_pw, (Throwable)transformerException);
        this.m_pw.println(transformerException.getMessage());
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        DefaultErrorHandler.printLocation(this.m_pw, sAXParseException);
        this.m_pw.println("Parser warning: " + sAXParseException.getMessage());
    }
}

