/* This program reads a .wav file and gives the location of the first strong
 * (non-zero) sample.  This takes into account the 44-byte header, so for
 * example if the first sample of the file is non-zero (i.e. there is no
 * digital silence),  this program will return 0 and not 46.
 * Useful for using in conjunction with sox -e trim to trim off beginning
 * silence from a .wav file.
 *
 * Returns offset in bytes from the beginning of the data (end of .wav
 *  header) to the beginning of the non-zero data.
 */

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>

int main(int argc, char *argv[])
{
FILE *f1;
unsigned short ch0, ch1;
int val = 0, threshold = 0;
long pos;

if (argc != 2)
{
        printf("Usage: wav_find_beginning <in.file>\n");
        exit(-1);
}
if ((f1=fopen(argv[1], "r")) == NULL)
{
        printf("wav_find_beginning: Unable to open %s.\n", argv[1]);
        exit(-1);
}

/* Skip to the 44th byte (position) of the file and start reading */
pos = 0;
while (pos < 44) { ch0=getc(f1); pos++; }

ch0 = 0;  ch1 = 0;
while (abs(val) <= threshold) {
        ch0 = getc(f1);  ch1 = getc(f1);
        pos += 2;
	val = ((int)ch0);
	val = val << 8;
	val = val | (int)ch1;
/* printf("%d\n\n", val); */
}

fclose(f1);

pos = pos - 46;

printf("%ld\n", pos);

}


