/* mem_load.h */
#ifndef MEM_LOAD_H
#define MEM_LOAD_H
/*******************************************
 *
 * Copyright 2001, Red Hat, Inc., all rights reserved.
 *
 * Author:  Bob Matthews <bmatthews@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *******************************************/

#define MB (1024 * 1024)           /* 2^20 bytes */
#define KB 1024
#define MAX_MEM_IN_MB (1024 * 64)  /* 64 GB */

/* Tuning parameter.  Increase if you are getting an 'unreasonable' load 
 * on the VM subsystem. */
#define DEFAULT_RESERVE 64

#define MIN(a,b)    ((a) < (b) ? (a) : (b))

int do_mem_load(void);
int *grab_and_touch(char *block[], int i);
unsigned long compute_allocable_mem(unsigned long , unsigned long , int);

#endif	/* MEM_LOAD_H */
