#ifndef COIN_SOTEXTUREUNIT_H
#define COIN_SOTEXTUREUNIT_H

/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2004 by Systems in Motion.  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *
 *  For using Coin with software that can not be combined with the GNU
 *  GPL, and for taking advantage of the additional benefits of our
 *  support services, please contact Systems in Motion about acquiring
 *  a Coin Professional Edition License.
 *
 *  See <URL:http://www.coin3d.org/> for more information.
 *
 *  Systems in Motion, Teknobyen, Abels Gate 5, 7030 Trondheim, NORWAY.
 *  <URL:http://www.sim.no/>.
 *
\**************************************************************************/

#include <Inventor/nodes/SoSubNode.h>
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/fields/SoSFEnum.h>

class COIN_DLL_API SoTextureUnit : public SoNode {
  typedef SoNode inherited;

  SO_NODE_HEADER(SoTextureUnit);

public:
  static void initClass(void);
  SoTextureUnit(void);

  enum MappingMethod {
    BUMP_MAPPING,
    IMAGE_MAPPING
  };
  
  SoSFInt32 unit;
  SoSFEnum mappingMethod;

  virtual void doAction(SoAction * action);
  virtual void callback(SoCallbackAction * action);
  virtual void GLRender(SoGLRenderAction * action);
  virtual void pick(SoPickAction * action);

  static uint32_t getMaxTextureUnit(void);
protected:
  virtual ~SoTextureUnit();
};

#endif // !COIN_SOTEXTUREUNIT_H
