;;;
;;; GLSPIN.LSP
;;;
;;; Translation of "spin.c" by Brian Paul
;;;

(defvar Xrot nil)
(defvar Xstep nil)
(defvar Yrot nil)
(defvar Ystep nil)
(defvar Zrot nil)
(defvar Zstep nil)
(defvar Step 5.0)
(defvar Scale 1.0)
(defvar Object nil)
(defvar animate? nil)

(defun make-object ()
 (let ((list (gl:glgenlists 1)))
  (gl:glnewlist list GL:GL_COMPILE)
  ;;
  (gl:glBegin GL:GL_LINE_LOOP)
  (gl:glVertex3f 1.0 0.5 -0.4)
  (gl:glVertex3f 1.0 -0.5 -0.4)
  (gl:glVertex3f -1.0 -0.5 -0.4)
  (gl:glVertex3f -1.0 0.5 -0.4)
  (gl:glEnd)
  ;;
  (gl:glBegin GL:GL_LINE_LOOP)
  (gl:glVertex3f 1.0 0.5 0.4)
  (gl:glVertex3f 1.0 -0.5 0.4)
  (gl:glVertex3f -1.0 -0.5 0.4)
  (gl:glVertex3f -1.0 0.5 0.4)
  (gl:glEnd)
  ;;
  (gl:glBegin GL:GL_LINES)
  (gl:glVertex3f 1.0 0.5 -0.4)   (gl:glVertex3f 1.0 0.5 0.4)
  (gl:glVertex3f 1.0 -0.5 -0.4)  (gl:glVertex3f 1.0 -0.5 0.4)
  (gl:glVertex3f -1.0 -0.5 -0.4) (gl:glVertex3f -1.0 -0.5 0.4)
  (gl:glVertex3f -1.0 0.5 -0.4)  (gl:glVertex3f -1.0 0.5 0.4)
  (gl:glEnd)
  ;;
  (gl:glEndList)
  ;;
  list))

(defun reshape (width height)
 (gl:glViewport 0 0 width height)
 (gl:glMatrixMode GL:GL_PROJECTION)
 (gl:glLoadIdentity)
 (gl:glFrustum -1.0 1.0 -1.0 1.0 5.0 15.0)
 (gl:glMatrixMode GL:GL_MODELVIEW))

(defun draw (display window)
 (gl:glClear GL:GL_COLOR_BUFFER_BIT)
 (gl:glPushMatrix)
 (gl:glTranslatef 0 0 -10)
 (gl:glScalef Scale Scale Scale)
 (cond
   ((> xstep 0)
    (gl:glrotatef xrot 1 0 0))
   ((> ystep 0)
    (gl:glrotatef yrot 0 1 0))
   ((> zstep 0)
    (gl:glrotatef zrot 0 0 1)))
 ;;
 (gl:glcalllist object)
 ;;
 (gl:glpopmatrix)
 ;;
 (gl:glflush)
 (gl:glxswapbuffers display window))

(defun animate (display window)
 ;;
 (setf xrot (+ xrot xstep))
 (setf yrot (+ yrot ystep))
 (setf zrot (+ zrot zstep))
 ;;
 (cond
  ((>= xrot 360.0)
   (setf xrot 0)
   (setf xstep 0)
   (setf ystep step))
  ((>= yrot 360.0)
   (setf yrot 0)
   (setf ystep 0)
   (setf zstep step))
  ((>= zrot 360.0)
   (setf zrot 0)
   (setf zstep 0)
   (setf xstep step)))
 (draw display window))

(defun event-loop (display window)
 (let ((done? nil)
       (debug t)
       (event (xlib:make-xevent)))
  ;;
  ;; Main event loop
  (loop
   ;;
   ;; If we are animating, calc and redraw each frame until an event occurs
   (when animate?
    (when debug (format t "Animate...~%"))
    (loop
     (animate display window)
     (usleep 10000)
     (when (> (xlib:xeventsqueued display xlib:queuedafterflush) 0)
      (return))))
   ;;
   ;; Handle events.  If we are not animating, we wait here for event.
   (when debug (format t "Waiting for event..."))
   (xlib:xnextevent display event)
   (let ((event-type (xlib:xanyevent-type event)))
    (when debug (format t "Event:~a~%" event-type))
    (cond
      ;;
      ;; Expose
      ((eq event-type xlib:expose)
       ;;
       ;; Gobble all other expose events
       (loop
	(when (zerop (xlib:xeventsqueued display xlib:queuedalready))
	 (return))
	(xlib:xnextevent display event)
	(let ((event-type (xlib:xanyevent-type event)))
	 (unless (eq event-type xlib:expose)
	  (xlib:xputbackevent display event)
	  (return)))
	(when debug (format t "Gobble event:~a~%" event-type)))
       (draw display window))
      ;;
      ;; Resize
      ((eq event-type xlib:configurenotify)
       (reshape (xlib:xconfigureevent-width event)
		(xlib:xconfigureevent-height event)))
      ((eq event-type xlib:buttonpress)
       (let ((button (xlib:xbuttonevent-button event)))
	(when debug (format t "Button:~a~%" button))
	(cond ((eq button xlib:button1)
	       (setf animate? (not animate?)))
	      ((eq button xlib:button3)
	       (setf done? t)))))))
   ;;
   (when done? (return)))))

(defun bind-gl-to-window (display screen window)
 (let ((debug t))
  (when debug (format t "Bind-gl-to-current-window.~%"))
  ;;
  (when debug (format t "XGetWindowAttributes..."))
  (let* ((attr (xlib:make-xwindowattributes))
         (foo (xlib:xgetwindowattributes display window attr))
         (class (xlib:xwindowattributes-class attr))
         (depth (xlib:xwindowattributes-depth attr))
         (visual (xlib:xwindowattributes-visual attr))
         (visual-class (xlib:visual-class visual)))
   (when debug
    (format t "screen:~a, " screen)
    (format t "class:~a, depth:~a, " class depth)
    (format t "visual-class:~a~%" visual-class))
   ;;
   (when debug (format t "XMatchVisualInfo..."))
   (let* ((visualinfo (xlib:make-xvisualinfo))
          (num-visuals (xlib:xmatchvisualinfo display screen depth
                                               visual-class visualinfo)))
    (unless (> num-visuals 0)
     (error "BIND-GL-TO-WINDOW: Could not get visual of class:~a, depth~a!"
	    visual-class depth))
    (when debug (format t "~a visuals found.~%" num-visuals))
    ;;
    (when debug (format t "glXCreateContext..."))
    (let ((glx-context (gl:glxcreatecontext display visualinfo
                                             XLIB:NULL GL:GL_TRUE)))
     (when debug (format t "~%glXMakeCurrent..."))
     (gl:glxmakecurrent display window glx-context))))
  (when debug (format t "~%Done.~%"))))

(defun create-gl-simple-window (display width height)
 (let* ((screen (xlib:xdefaultscreen display))
        (root (xlib:xrootwindow display screen))
        (black-pixel (xlib:xblackpixel display screen))
        (white-pixel (xlib:xwhitepixel display screen))
        (window (xlib:xcreatesimplewindow display root 0 0 width height
					  1 black-pixel white-pixel)))
  ;; Enable events
  (xlib:xselectinput display window
		     (+ xlib:structurenotifymask
			xlib:exposuremask
                        xlib:buttonpressmask))
  ;; Bind to GL
  (bind-gl-to-window display screen window)
  ;; Map window
  (xlib:xmapwindow display window)
  (xlib:xflush display)
  ;; Return window
  window))

(defun main ()
 ;;
 (let* ((display (xlib:xopendisplay ""))
	(window (create-gl-simple-window display 300 300)))
  ;; used by draw routine.
  (setf object (make-object))
  ;;
  (gl:glcullface GL:GL_BACK)
  (gl:glenable GL:GL_CULL_FACE)
  (gl:gldisable GL:GL_DITHER)
  (gl:glshademodel GL:GL_FLAT)
  (gl:glcolor3f 1 1 1)
  ;;
  ;; Initial state of animation.
  (setf xrot 0)  (setf yrot 0)  (setf zrot 0)
  (setf xstep step)  (setf ystep 0)  (setf zstep 0)
  (setf animate? t)
  ;;
  (event-loop display window)))
