(in-package :clim-user)

(defparameter *info* '(
 (*ABORT-GESTURES* . :variable)
 (*ACCELERATOR-GESTURES* . :variable)
 (*ACTIVATION-GESTURES* . :variable)
 (*APPLICATION-FRAME* . :variable)
 (*COMMAND-ARGUMENT-DELIMITERS* . :variable)
 (*COMMAND-DISPATCHERS* . :variable)
 (*COMMAND-NAME-DELIMITERS* . :variable)
 (*COMMAND-PARSER* . :variable)
 (*COMMAND-UNPARSER* . :variable)
 (*COMPLETION-GESTURES* . :variable)
 (*DEFAULT-FRAME-MANAGER* . :variable)
 (*DEFAULT-SERVER-PATH* . :variable)
 (*DEFAULT-TEXT-STYLE* . :constant)
 (*DELIMITER-GESTURES* . :variable)
 (*HELP-GESTURES* . :variable)
 (*INPUT-CONTEXT* . :variable)
 (*INPUT-WAIT-HANDLER* . :variable)
 (*INPUT-WAIT-TEST* . :variable)
 (*NULL-PRESENTATION* . :constant)
 (*NUMERIC-ARGUMENT-MARKER* . :variable)
 (*ORIGINAL-STREAM* . :variable)
 (*PARTIAL-COMMAND-PARSER* . :variable)
 (*POINTER-BUTTON-PRESS-HANDLER* . :variable)
 (*POINTER-DOCUMENTATION-OUTPUT* . :variable)
 (*POSSIBILITIES-GESTURES* . :variable)
 (*STANDARD-ACTIVATION-GESTURES* . :variable)
 (*UNDEFINED-TEXT-STYLE* . :constant)
 (*UNSUPPLIED-ARGUMENT-MARKER* . :variable)
 (+BACKGROUND-INK+ . :constant)
 (+BLACK+ . :constant)
 (+BLUE+ . :constant)
 (+CONTROL-KEY+ . :constant)
 (+CYAN+ . :constant)
 (+EVERYWHERE+ . :constant)
 (+FILL+ . :constant)
 (+FLIPPING-INK+ . :constant)
 (+FOREGROUND-INK+ . :constant)
 (+GADGET-DIALOG-VIEW+ . :constant)
 (+GADGET-MENU-VIEW+ . :constant)
 (+GADGET-VIEW+ . :constant)
 (+GREEN+ . :constant)
 (+HYPER-KEY+ . :constant)
 (+IDENTITY-TRANSFORMATION+ . :constant)
 (+MAGENTA+ . :constant)
 (+META-KEY+ . :constant)
 (+NOWHERE+ . :constant)
 (+POINTER-DOCUMENTATION-VIEW+ . :constant)
 (+POINTER-LEFT-BUTTON+ . :constant)
 (+POINTER-MIDDLE-BUTTON+ . :constant)
 (+POINTER-RIGHT-BUTTON+ . :constant)
 (+RED+ . :constant)
 (+SHIFT-KEY+ . :constant)
 (+SUPER-KEY+ . :constant)
 (+TEXTUAL-DIALOG-VIEW+ . :constant)
 (+TEXTUAL-MENU-VIEW+ . :constant)
 (+TEXTUAL-VIEW+ . :constant)
 (+TRANSPARENT-INK+ . :constant)
 (+WHITE+ . :constant)
 (+YELLOW+ . :constant)
 (ABORT-GESTURE . :condition)
 (ABORT-GESTURE-EVENT . :generic)
 (ACCELERATOR-GESTURE . :condition)
 (ACCELERATOR-GESTURE-EVENT . :generic)
 (ACCELERATOR-GESTURE-NUMERIC-ARGUMENT . :generic)
 (ACCEPT . :presentation-method)
 (ACCEPT . :function)
 (ACCEPT-1 . :function)
 (ACCEPT-FROM-STRING . :function)
 (ACCEPT-PRESENT-DEFAULT . :presentation-method)
 (ACCEPT-VALUES . :frame)
 (ACCEPT-VALUES-COMMAND-BUTTON . :macro)
 (ACCEPT-VALUES-RESYNCHRONIZE . :generic)
 (ACCEPTING-VALUES . :macro)
 (ACTION-GADGET . :class)
 (ACTIVATE-CALLBACK . :callback)
 (ACTIVATE-GADGET . :generic)
 (ACTIVATION-GESTURE-P . :function)
 (ADD-CHARACTER-OUTPUT-TO-TEXT-RECORD . :generic)
 (ADD-COMMAND-TO-COMMAND-TABLE . :function)
 (ADD-GESTURE-NAME . :function)
 (ADD-INPUT-EDITOR-COMMAND . :function)
 (ADD-KEYSTROKE-TO-COMMAND-TABLE . :function)
 (ADD-MENU-ITEM-TO-COMMAND-TABLE . :function)
 (ADD-OUTPUT-RECORD . :generic)
 (ADD-PRESENTATION-TRANSLATOR-TO-COMMAND-TABLE . :function)
 (ADD-STRING-OUTPUT-TO-TEXT-RECORD . :generic)
 (ADJUST-ITEM-LIST-CELLS . :generic)
 (ADJUST-MULTIPLE-COLUMNS . :generic)
 (ADJUST-TABLE-CELLS . :generic)
 (ADOPT-FRAME . :generic)
 (ALLOCATE-MEDIUM . :generic)
 (ALLOCATE-PIXMAP . :generic)
 (ALLOCATE-SPACE . :generic)
 (AND . :presentation-type)
 (APPLICATION-FRAME . :protocol-class)
 (APPLICATION-FRAME-P . :function)
 (APPLICATION-PANE . :pane)
 (APPLY-PRESENTATION-GENERIC-FUNCTION . :macro)
 (AREA . :protocol-class)
 (AREAP . :function)
 (ARMED-CALLBACK . :callback)
 (AUGMENT-DRAW-SET . :generic)
 (BASIC-GADGET . :class)
 (BASIC-MEDIUM . :class)
 (BASIC-PANE . :class)
 (BASIC-PORT . :class)
 (BASIC-SHEET . :class)
 (BBOARD-PANE . :pane)
 (BEEP . :generic)
 (BLANK-AREA . :presentation-type)
 (BOOLEAN . :presentation-type)
 (BOUNDING-RECTANGLE . :protocol-class)
 (BOUNDING-RECTANGLE . :generic)
 (BOUNDING-RECTANGLE* . :generic)
 (BOUNDING-RECTANGLE-HEIGHT . :generic)
 (BOUNDING-RECTANGLE-MAX-X . :generic)
 (BOUNDING-RECTANGLE-MAX-Y . :generic)
 (BOUNDING-RECTANGLE-MIN-X . :generic)
 (BOUNDING-RECTANGLE-MIN-Y . :generic)
 (BOUNDING-RECTANGLE-P . :function)
 (BOUNDING-RECTANGLE-POSITION . :generic)
 (BOUNDING-RECTANGLE-SIZE . :generic)
 (BOUNDING-RECTANGLE-WIDTH . :generic)
 (BURY-FRAME . :generic)
 (BURY-MIRROR . :generic)
 (BURY-SHEET . :generic)
 (CACHE-OUTPUT-RECORD . :generic)
 (CALL-PRESENTATION-MENU . :function)
 (CALL-PRESENTATION-TRANSLATOR . :function)
 (CELL-ALIGN-X . :generic)
 (CELL-ALIGN-Y . :generic)
 (CELL-MIN-HEIGHT . :generic)
 (CELL-MIN-WIDTH . :generic)
 (CELL-OUTPUT-RECORD . :protocol-class)
 (CELL-OUTPUT-RECORD-P . :function)
 (CHANGE-SPACE-REQUIREMENTS . :generic)
 (CHANGING-SPACE-REQUIREMENTS . :macro)
 (CHARACTER . :presentation-type)
 (CHECK-BOX . :class)
 (CHECK-BOX-CURRENT-SELECTION . :generic)
 (CHECK-BOX-PANE . :class)
 (CHECK-BOX-SELECTIONS . :generic)
 (CHILD-CONTAINING-POSITION . :generic)
 (CHILDREN-OVERLAPPING-RECTANGLE* . :generic)
 (CHILDREN-OVERLAPPING-REGION . :generic)
 (CLASS-PRESENTATION-TYPE-NAME . :function)
 (CLEAR-OUTPUT-RECORD . :generic)
 (CLIM-STREAM-PANE . :pane)
 (CLOSE . :generic)
 (COLOR . :protocol-class)
 (COLOR-IHS . :generic)
 (COLOR-RGB . :generic)
 (COLORP . :function)
 (COLUMN-OUTPUT-RECORD . :protocol-class)
 (COLUMN-OUTPUT-RECORD-P . :function)
 (COMMAND . :presentation-type)
 (COMMAND-ACCESSIBLE-IN-COMMAND-TABLE-P . :function)
 (COMMAND-ALREADY-PRESENT . :condition)
 (COMMAND-ARGUMENTS . :function)
 (COMMAND-ENABLED . :generic)
 (COMMAND-LINE-COMMAND-PARSER . :function)
 (COMMAND-LINE-COMMAND-UNPARSER . :function)
 (COMMAND-LINE-NAME-FOR-COMMAND . :function)
 (COMMAND-LINE-READ-REMAINING-ARGUMENTS-FOR-PARTIAL-COMMAND . :function)
 (COMMAND-MENU-ITEM-OPTIONS . :function)
 (COMMAND-MENU-ITEM-TYPE . :function)
 (COMMAND-MENU-ITEM-VALUE . :function)
 (COMMAND-MENU-PANE . :pane)
 (COMMAND-NAME . :presentation-type)
 (COMMAND-NAME . :function)
 (COMMAND-NAME-FROM-SYMBOL . :function)
 (COMMAND-NOT-ACCESSIBLE . :condition)
 (COMMAND-NOT-PRESENT . :condition)
 (COMMAND-OR-FORM . :presentation-type)
 (COMMAND-PRESENT-IN-COMMAND-TABLE-P . :function)
 (COMMAND-TABLE . :protocol-class)
 (COMMAND-TABLE-ALREADY-EXISTS . :condition)
 (COMMAND-TABLE-COMPLETE-INPUT . :function)
 (COMMAND-TABLE-ERROR . :condition)
 (COMMAND-TABLE-INHERIT-FROM . :generic)
 (COMMAND-TABLE-NAME . :generic)
 (COMMAND-TABLE-NOT-FOUND . :condition)
 (COMMAND-TABLE-P . :function)
 (COMPLETE-FROM-GENERATOR . :function)
 (COMPLETE-FROM-POSSIBILITIES . :function)
 (COMPLETE-INPUT . :function)
 (COMPLETING-FROM-SUGGESTIONS . :macro)
 (COMPLETION . :presentation-type)
 (COMPLEX . :presentation-type)
 (COMPOSE-IN . :generic)
 (COMPOSE-OUT . :generic)
 (COMPOSE-OVER . :generic)
 (COMPOSE-ROTATION-WITH-TRANSFORMATION . :function)
 (COMPOSE-SCALING-WITH-TRANSFORMATION . :function)
 (COMPOSE-SPACE . :generic)
 (COMPOSE-TRANSFORMATION-WITH-ROTATION . :function)
 (COMPOSE-TRANSFORMATION-WITH-SCALING . :function)
 (COMPOSE-TRANSFORMATION-WITH-TRANSLATION . :function)
 (COMPOSE-TRANSFORMATIONS . :generic)
 (COMPOSE-TRANSLATION-WITH-TRANSFORMATION . :function)
 (COMPUTE-DIFFERENCE-SET . :generic)
 (COMPUTE-NEW-OUTPUT-RECORDS . :generic)
 (CONTRASTING-DASH-PATTERN-LIMIT . :generic)
 (CONTRASTING-INKS-LIMIT . :generic)
 (COORDINATE . :type)
 (COORDINATE . :function)
 (COPY-AREA . :generic)
 (COPY-FROM-PIXMAP . :function)
 (COPY-TEXTUAL-OUTPUT-HISTORY . :function)
 (COPY-TO-PIXMAP . :function)
 (CURSOR . :protocol-class)
 (CURSOR-ACTIVE . :generic)
 (CURSOR-FOCUS . :generic)
 (CURSOR-POSITION . :generic)
 (CURSOR-SHEET . :generic)
 (CURSOR-STATE . :generic)
 (CURSOR-VISIBILITY . :generic)
 (CURSORP . :function)
 (DEACTIVATE-GADGET . :generic)
 (DEALLOCATE-MEDIUM . :generic)
 (DEALLOCATE-PIXMAP . :generic)
 (DECACHE-CHILD-OUTPUT-RECORD . :generic)
 (DEFAULT-DESCRIBE-PRESENTATION-TYPE . :function)
 (DEFAULT-FRAME-TOP-LEVEL . :generic)
 (DEFINE-APPLICATION-FRAME . :macro)
 (DEFINE-BORDER-TYPE . :macro)
 (DEFINE-COMMAND . :macro)
 (DEFINE-COMMAND-TABLE . :macro)
 (DEFINE-DEFAULT-PRESENTATION-METHOD . :macro)
 (DEFINE-DRAG-AND-DROP-TRANSLATOR . :macro)
 (DEFINE-GESTURE-NAME . :macro)
 (DEFINE-GRAPH-TYPE . :macro)
 (DEFINE-PRESENTATION-ACTION . :macro)
 (DEFINE-PRESENTATION-GENERIC-FUNCTION . :macro)
 (DEFINE-PRESENTATION-METHOD . :macro)
 (DEFINE-PRESENTATION-TO-COMMAND-TRANSLATOR . :macro)
 (DEFINE-PRESENTATION-TRANSLATOR . :macro)
 (DEFINE-PRESENTATION-TYPE . :macro)
 (DEFINE-PRESENTATION-TYPE-ABBREVIATION . :macro)
 (DEGRAFT-MEDIUM . :generic)
 (DELEGATE-SHEET-DELEGATE . :generic)
 (DELEGATE-SHEET-INPUT-MIXIN . :class)
 (DELETE-GESTURE-NAME . :function)
 (DELETE-OUTPUT-RECORD . :generic)
 (DELIMITER-GESTURE-P . :function)
 (DESCRIBE-PRESENTATION-TYPE . :presentation-method)
 (DESCRIBE-PRESENTATION-TYPE . :function)
 (DESIGN . :protocol-class)
 (DESIGNP . :function)
 (DESTROY-FRAME . :generic)
 (DESTROY-MIRROR . :generic)
 (DESTROY-PORT . :generic)
 (DEVICE-EVENT . :class)
 (DISABLE-FRAME . :generic)
 (DISARMED-CALLBACK . :callback)
 (DISOWN-FRAME . :generic)
 (DISPATCH-EVENT . :generic)
 (DISPLAY-COMMAND-MENU . :generic)
 (DISPLAY-COMMAND-TABLE-MENU . :generic)
 (DISPLAY-EXIT-BOXES . :generic)
 (DISPLAYED-OUTPUT-RECORD . :protocol-class)
 (DISPLAYED-OUTPUT-RECORD-INK . :generic)
 (DISPLAYED-OUTPUT-RECORD-P . :function)
 (DISTRIBUTE-EVENT . :generic)
 (DO-COMMAND-TABLE-INHERITANCE . :macro)
 (DOCUMENT-PRESENTATION-TRANSLATOR . :function)
 (DRAG-CALLBACK . :callback)
 (DRAG-CALLBACK . :callback)
 (DRAG-OUTPUT-RECORD . :generic)
 (DRAGGING-OUTPUT . :macro)
 (DRAW-ARROW . :function)
 (DRAW-ARROW* . :function)
 (DRAW-CIRCLE . :function)
 (DRAW-CIRCLE* . :function)
 (DRAW-DESIGN . :generic)
 (DRAW-ELLIPSE . :function)
 (DRAW-ELLIPSE* . :function)
 (DRAW-LINE . :function)
 (DRAW-LINE* . :function)
 (DRAW-LINES . :function)
 (DRAW-LINES* . :function)
 (DRAW-OVAL . :function)
 (DRAW-OVAL* . :function)
 (DRAW-PATTERN* . :function)
 (DRAW-POINT . :function)
 (DRAW-POINT* . :function)
 (DRAW-POINTS . :function)
 (DRAW-POINTS* . :function)
 (DRAW-POLYGON . :function)
 (DRAW-POLYGON* . :function)
 (DRAW-RECTANGLE . :function)
 (DRAW-RECTANGLE* . :function)
 (DRAW-RECTANGLES . :function)
 (DRAW-RECTANGLES* . :function)
 (DRAW-STANDARD-MENU . :function)
 (DRAW-TEXT . :function)
 (DRAW-TEXT* . :function)
 (ELLIPSE . :protocol-class)
 (ELLIPSE-CENTER-POINT . :generic)
 (ELLIPSE-CENTER-POINT* . :generic)
 (ELLIPSE-END-ANGLE . :generic)
 (ELLIPSE-RADII . :generic)
 (ELLIPSE-START-ANGLE . :generic)
 (ELLIPSEP . :function)
 (ELLIPTICAL-ARC . :protocol-class)
 (ELLIPTICAL-ARC-P . :function)
 (ENABLE-FRAME . :generic)
 (ENCAPSULATING-STREAM . :protocol-class)
 (ENCAPSULATING-STREAM-P . :function)
 (ENCAPSULATING-STREAM-STREAM . :generic)
 (ENGRAFT-MEDIUM . :generic)
 (ERASE-INPUT-BUFFER . :generic)
 (ERASE-OUTPUT-RECORD . :generic)
 (EVEN-SCALING-TRANSFORMATION-P . :generic)
 (EVENT . :protocol-class)
 (EVENT-LISTEN . :generic)
 (EVENT-MATCHES-GESTURE-NAME-P . :function)
 (EVENT-MODIFIER-STATE . :generic)
 (EVENT-PEEK . :generic)
 (EVENT-READ . :generic)
 (EVENT-READ-NO-HANG . :generic)
 (EVENT-SHEET . :generic)
 (EVENT-TIMESTAMP . :generic)
 (EVENT-TYPE . :generic)
 (EVENT-UNREAD . :generic)
 (EVENTP . :function)
 (EXECUTE-FRAME-COMMAND . :generic)
 (EXPAND-PRESENTATION-TYPE-ABBREVIATION . :function)
 (EXPAND-PRESENTATION-TYPE-ABBREVIATION-1 . :function)
 (EXPRESSION . :presentation-type)
 (EXTENDED-INPUT-STREAM . :protocol-class)
 (EXTENDED-INPUT-STREAM-P . :function)
 (EXTENDED-OUTPUT-STREAM . :protocol-class)
 (EXTENDED-OUTPUT-STREAM-P . :function)
 (FILLING-OUTPUT . :macro)
 (FIND-APPLICABLE-TRANSLATORS . :function)
 (FIND-CACHED-OUTPUT-RECORD . :generic)
 (FIND-CHILD-OUTPUT-RECORD . :generic)
 (FIND-COMMAND-FROM-COMMAND-LINE-NAME . :function)
 (FIND-COMMAND-TABLE . :function)
 (FIND-FRAME-MANAGER . :function)
 (FIND-GRAFT . :function)
 (FIND-INNERMOST-APPLICABLE-PRESENTATION . :function)
 (FIND-KEYSTROKE-ITEM . :function)
 (FIND-MENU-ITEM . :function)
 (FIND-PANE-FOR-FRAME . :generic)
 (FIND-PANE-NAMED . :generic)
 (FIND-PORT . :function)
 (FIND-PRESENTATION-TRANSLATOR . :function)
 (FIND-PRESENTATION-TRANSLATORS . :function)
 (FIND-PRESENTATION-TYPE-CLASS . :function)
 (FLOAT . :presentation-type)
 (FORM . :presentation-type)
 (FORMAT-GRAPH-FROM-ROOTS . :function)
 (FORMAT-ITEMS . :function)
 (FORMAT-TEXTUAL-LIST . :function)
 (FORMATTING-CELL . :macro)
 (FORMATTING-COLUMN . :macro)
 (FORMATTING-ITEM-LIST . :macro)
 (FORMATTING-ROW . :macro)
 (FORMATTING-TABLE . :macro)
 (FRAME-ALL-LAYOUTS . :generic)
 (FRAME-CALLING-FRAME . :generic)
 (FRAME-COMMAND-TABLE . :generic)
 (FRAME-CURRENT-LAYOUT . :generic)
 (FRAME-CURRENT-PANES . :generic)
 (FRAME-DOCUMENT-HIGHLIGHTED-PRESENTATION . :generic)
 (FRAME-DRAG-AND-DROP-FEEDBACK . :generic)
 (FRAME-DRAG-AND-DROP-HIGHLIGHTING . :generic)
 (FRAME-ERROR-OUTPUT . :generic)
 (FRAME-EXIT . :condition)
 (FRAME-EXIT . :generic)
 (FRAME-EXIT-FRAME . :generic)
 (FRAME-FIND-INNERMOST-APPLICABLE-PRESENTATION . :generic)
 (FRAME-INPUT-CONTEXT-BUTTON-PRESS-HANDLER . :generic)
 (FRAME-MAINTAIN-PRESENTATION-HISTORIES . :generic)
 (FRAME-MANAGER . :protocol-class)
 (FRAME-MANAGER . :generic)
 (FRAME-MANAGER-FRAMES . :generic)
 (FRAME-MANAGER-MENU-CHOOSE . :generic)
 (FRAME-MANAGER-NOTIFY-USER . :generic)
 (FRAME-MANANGER-P . :function)
 (FRAME-NAME . :generic)
 (FRAME-PANES . :generic)
 (FRAME-PARENT . :generic)
 (FRAME-POINTER-DOCUMENTATION-OUTPUT . :generic)
 (FRAME-PRETTY-NAME . :generic)
 (FRAME-PROPERTIES . :generic)
 (FRAME-QUERY-IO . :generic)
 (FRAME-REPLAY . :generic)
 (FRAME-STANDARD-INPUT . :generic)
 (FRAME-STANDARD-OUTPUT . :generic)
 (FRAME-STATE . :generic)
 (FRAME-TOP-LEVEL-SHEET . :generic)
 (FUNCALL-PRESENTATION-GENERIC-FUNCTION . :macro)
 (FUNDAMENTAL-BINARY-INPUT-STREAM . :class)
 (FUNDAMENTAL-BINARY-OUTPUT-STREAM . :class)
 (FUNDAMENTAL-BINARY-STREAM . :class)
 (FUNDAMENTAL-CHARACTER-INPUT-STREAM . :class)
 (FUNDAMENTAL-CHARACTER-OUTPUT-STREAM . :class)
 (FUNDAMENTAL-CHARACTER-STREAM . :class)
 (FUNDAMENTAL-INPUT-STREAM . :class)
 (FUNDAMENTAL-OUTPUT-STREAM . :class)
 (FUNDAMENTAL-STREAM . :class)
 (GADGET . :protocol-class)
 (GADGET-ACTIVATE-CALLBACK . :generic)
 (GADGET-ACTIVE-P . :generic)
 (GADGET-ARMED-CALLBACK . :generic)
 (GADGET-CLIENT . :generic)
 (GADGET-DIALOG-VIEW . :class)
 (GADGET-DISARMED-CALLBACK . :generic)
 (GADGET-ID . :generic)
 (GADGET-LABEL . :generic)
 (GADGET-LABEL-ALIGN-X . :generic)
 (GADGET-LABEL-ALIGN-Y . :generic)
 (GADGET-MAX-VALUE . :generic)
 (GADGET-MENU-VIEW . :class)
 (GADGET-MIN-VALUE . :generic)
 (GADGET-ORIENTATION . :generic)
 (GADGET-OUTPUT-RECORD . :class)
 (GADGET-RANGE . :generic)
 (GADGET-RANGE* . :generic)
 (GADGET-SHOW-VALUE-P . :generic)
 (GADGET-VALUE . :generic)
 (GADGET-VALUE-CHANGED-CALLBACK . :generic)
 (GADGET-VIEW . :class)
 (GADGETP . :function)
 (GENERATE-GRAPH-NODES . :generic)
 (GENERATE-PANES . :generic)
 (GENERIC-LIST-PANE . :class)
 (GENERIC-OPTION-PANE . :class)
 (GET-FRAME-PANE . :generic)
 (GLOBAL-COMMAND-TABLE . :command-table)
 (GRAFT . :generic)
 (GRAFT-HEIGHT . :generic)
 (GRAFT-ORIENTATION . :generic)
 (GRAFT-PIXELS-PER-INCH . :function)
 (GRAFT-PIXELS-PER-MILLIMETER . :function)
 (GRAFT-UNITS . :generic)
 (GRAFT-WIDTH . :generic)
 (GRAPH-NODE-CHILDREN . :generic)
 (GRAPH-NODE-OBJECT . :generic)
 (GRAPH-NODE-OUTPUT-RECORD . :protocol-class)
 (GRAPH-NODE-OUTPUT-RECORD-P . :function)
 (GRAPH-NODE-PARENTS . :generic)
 (GRAPH-OUTPUT-RECORD . :protocol-class)
 (GRAPH-OUTPUT-RECORD-P . :function)
 (GRAPH-ROOT-NODES . :generic)
 (GRAPHICS-DISPLAYED-OUTPUT-RECORD . :protocol-class)
 (GRAPHICS-DISPLAYED-OUTPUT-RECORD-P . :function)
 (GRID-PANE . :pane)
 (HANDLE-EVENT . :generic)
 (HANDLE-REPAINT . :generic)
 (HBOX-PANE . :pane)
 (HIGHLIGHT-APPLICABLE-PRESENTATION . :function)
 (HIGHLIGHT-OUTPUT-RECORD . :generic)
 (HIGHLIGHT-PRESENTATION . :presentation-method)
 (HORIZONTALLY . :macro)
 (HRACK-PANE . :pane)
 (IDENTITY-TRANSFORMATION-P . :generic)
 (IMMEDIATE-REPAINTING-MIXIN . :class)
 (IMMEDIATE-RESCAN . :generic)
 (IMMEDIATE-SHEET-INPUT-MIXIN . :class)
 (INCREMENTAL-REDISPLAY . :generic)
 (INDENTING-OUTPUT . :macro)
 (INPUT-CONTEXT-TYPE . :function)
 (INPUT-EDITING-STREAM . :protocol-class)
 (INPUT-EDITING-STREAM-P . :function)
 (INPUT-EDITOR-FORMAT . :generic)
 (INPUT-NOT-OF-REQUIRED-TYPE . :condition)
 (INPUT-NOT-OF-REQUIRED-TYPE . :function)
 (INPUT-STREAM-P . :generic)
 (INTEGER . :presentation-type)
 (INTERACTIVE-STREAM-P . :function)
 (INTERACTOR-PANE . :pane)
 (INVALIDATE-CACHED-REGIONS . :generic)
 (INVALIDATE-CACHED-TRANSFORMATIONS . :generic)
 (INVERT-TRANSFORMATION . :generic)
 (INVERTIBLE-TRANSFORMATION-P . :generic)
 (INVOKE-UPDATING-OUTPUT . :generic)
 (INVOKE-WITH-DRAWING-OPTIONS . :generic)
 (INVOKE-WITH-NEW-OUTPUT-RECORD . :generic)
 (INVOKE-WITH-OUTPUT-RECORDING-OPTIONS . :generic)
 (INVOKE-WITH-OUTPUT-TO-OUTPUT-RECORD . :generic)
 (INVOKE-WITH-TEXT-STYLE . :generic)
 (ITEM-LIST-OUTPUT-RECORD . :protocol-class)
 (ITEM-LIST-OUTPUT-RECORD-P . :function)
 (KEY-PRESS-EVENT . :class)
 (KEY-RELEASE-EVENT . :class)
 (KEYBOARD-EVENT . :class)
 (KEYBOARD-EVENT-CHARACTER . :generic)
 (KEYBOARD-EVENT-KEY-NAME . :generic)
 (KEYWORD . :presentation-type)
 (LABEL-PANE . :pane)
 (LABELLED-GADGET-MIXIN . :class)
 (LABELLING . :macro)
 (LAYOUT-FRAME . :generic)
 (LAYOUT-GRAPH-EDGES . :generic)
 (LAYOUT-GRAPH-NODES . :generic)
 (LINE . :protocol-class)
 (LINE-END-POINT . :generic)
 (LINE-END-POINT* . :generic)
 (LINE-START-POINT . :generic)
 (LINE-START-POINT* . :generic)
 (LINE-STYLE . :protocol-class)
 (LINE-STYLE-CAP-SHAPE . :generic)
 (LINE-STYLE-DASHES . :generic)
 (LINE-STYLE-JOINT-SHAPE . :generic)
 (LINE-STYLE-P . :function)
 (LINE-STYLE-THICKNESS . :generic)
 (LINE-STYLE-UNIT . :generic)
 (LINEP . :function)
 (LIST-PANE . :class)
 (LOOKUP-KEYSTROKE-COMMAND-ITEM . :function)
 (LOOKUP-KEYSTROKE-ITEM . :function)
 (MAKE-3-POINT-TRANSFORMATION . :function)
 (MAKE-3-POINT-TRANSFORMATION* . :function)
 (MAKE-APPLICATION-FRAME . :function)
 (MAKE-BOUNDING-RECTANGLE . :function)
 (MAKE-CLIM-APPLICATION-PANE . :function)
 (MAKE-CLIM-INTERACTOR-PANE . :function)
 (MAKE-CLIM-STREAM-PANE . :function)
 (MAKE-COMMAND-TABLE . :function)
 (MAKE-CONTRASTING-DASH-PATTERNS . :function)
 (MAKE-CONTRASTING-INKS . :function)
 (MAKE-DESIGN-FROM-OUTPUT-RECORD . :generic)
 (MAKE-DEVICE-FONT-TEXT-STYLE . :function)
 (MAKE-ELLIPSE . :function)
 (MAKE-ELLIPSE* . :function)
 (MAKE-ELLIPTICAL-ARC . :function)
 (MAKE-ELLIPTICAL-ARC* . :function)
 (MAKE-FLIPPING-INK . :function)
 (MAKE-GRAY-COLOR . :function)
 (MAKE-IHS-COLOR . :function)
 (MAKE-LINE . :function)
 (MAKE-LINE* . :function)
 (MAKE-LINE-STYLE . :function)
 (MAKE-MEDIUM . :generic)
 (MAKE-MODIFIER-STATE . :function)
 (MAKE-OPACITY . :function)
 (MAKE-PANE . :function)
 (MAKE-PANE-1 . :generic)
 (MAKE-PATTERN . :function)
 (MAKE-PATTERN-FROM-BITMAP-FILE . :function)
 (MAKE-POINT . :function)
 (MAKE-POLYGON . :function)
 (MAKE-POLYGON* . :function)
 (MAKE-POLYLINE . :function)
 (MAKE-POLYLINE* . :function)
 (MAKE-PRESENTATION-TYPE-SPECIFIER . :function)
 (MAKE-RECTANGLE . :function)
 (MAKE-RECTANGLE* . :function)
 (MAKE-RECTANGULAR-TILE . :function)
 (MAKE-REFLECTION-TRANSFORMATION . :function)
 (MAKE-REFLECTION-TRANSFORMATION* . :function)
 (MAKE-RGB-COLOR . :function)
 (MAKE-ROTATION-TRANSFORMATION . :function)
 (MAKE-ROTATION-TRANSFORMATION* . :function)
 (MAKE-SCALING-TRANSFORMATION . :function)
 (MAKE-SCALING-TRANSFORMATION* . :function)
 (MAKE-SPACE-REQUIREMENT . :function)
 (MAKE-STENCIL . :function)
 (MAKE-TEXT-STYLE . :function)
 (MAKE-TRANSFORMATION . :function)
 (MAKE-TRANSLATION-TRANSFORMATION . :function)
 (MAP-OVER-COMMAND-TABLE-COMMANDS . :function)
 (MAP-OVER-COMMAND-TABLE-KEYSTROKES . :function)
 (MAP-OVER-COMMAND-TABLE-MENU-ITEMS . :function)
 (MAP-OVER-COMMAND-TABLE-NAMES . :function)
 (MAP-OVER-COMMAND-TABLE-TRANSLATORS . :function)
 (MAP-OVER-FRAMES . :function)
 (MAP-OVER-GRAFTS . :function)
 (MAP-OVER-ITEM-LIST-CELLS . :generic)
 (MAP-OVER-OUTPUT-RECORDS . :generic)
 (MAP-OVER-OUTPUT-RECORDS-CONTAINING-POSITION . :generic)
 (MAP-OVER-OUTPUT-RECORDS-OVERLAPPING-REGION . :generic)
 (MAP-OVER-POLYGON-COORDINATES . :generic)
 (MAP-OVER-POLYGON-SEGMENTS . :generic)
 (MAP-OVER-PORTS . :function)
 (MAP-OVER-PRESENTATION-TYPE-SUPERTYPES . :presentation-method)
 (MAP-OVER-PRESENTATION-TYPE-SUPERTYPES . :function)
 (MAP-OVER-REGION-SET-REGIONS . :generic)
 (MAP-OVER-ROW-CELLS . :generic)
 (MAP-OVER-ROW-CELLS . :generic)
 (MAP-OVER-SHEETS . :generic)
 (MAP-OVER-SHEETS-CONTAINING-POSITION . :generic)
 (MAP-OVER-SHEETS-OVERLAPPING-REGION . :generic)
 (MAP-OVER-TABLE-ELEMENTS . :generic)
 (MAP-SHEET-POSITION-TO-CHILD . :generic)
 (MAP-SHEET-POSITION-TO-PARENT . :generic)
 (MAP-SHEET-RECTANGLE*-TO-CHILD . :generic)
 (MAP-SHEET-RECTANGLE*-TO-PARENT . :generic)
 (MATCH-OUTPUT-RECORDS . :generic)
 (MEDIUM . :protocol-class)
 (MEDIUM-BACKGROUND . :generic)
 (MEDIUM-BACKGROUND . :generic)
 (MEDIUM-BEEP . :generic)
 (MEDIUM-BUFFERING-OUTPUT-P . :generic)
 (MEDIUM-CLEAR-AREA . :generic)
 (MEDIUM-CLIPPING-REGION . :generic)
 (MEDIUM-CLIPPING-REGION . :generic)
 (MEDIUM-COPY-AREA . :generic)
 (MEDIUM-CURRENT-TEXT-STYLE . :generic)
 (MEDIUM-DEFAULT-TEXT-STYLE . :generic)
 (MEDIUM-DEFAULT-TEXT-STYLE . :generic)
 (MEDIUM-DRAW-ELLIPSE* . :generic)
 (MEDIUM-DRAW-LINE* . :generic)
 (MEDIUM-DRAW-LINES* . :generic)
 (MEDIUM-DRAW-POINT* . :generic)
 (MEDIUM-DRAW-POINTS* . :generic)
 (MEDIUM-DRAW-POLYGON* . :generic)
 (MEDIUM-DRAW-RECTANGLE* . :generic)
 (MEDIUM-DRAW-RECTANGLES* . :generic)
 (MEDIUM-DRAW-TEXT* . :generic)
 (MEDIUM-DRAWABLE . :generic)
 (MEDIUM-FINISH-OUTPUT . :generic)
 (MEDIUM-FORCE-OUTPUT . :generic)
 (MEDIUM-FOREGROUND . :generic)
 (MEDIUM-FOREGROUND . :generic)
 (MEDIUM-INK . :generic)
 (MEDIUM-INK . :generic)
 (MEDIUM-LINE-STYLE . :generic)
 (MEDIUM-LINE-STYLE . :generic)
 (MEDIUM-MERGED-TEXT-STYLE . :generic)
 (MEDIUM-SHEET . :generic)
 (MEDIUM-TEXT-STYLE . :generic)
 (MEDIUM-TEXT-STYLE . :generic)
 (MEDIUM-TRANSFORMATION . :generic)
 (MEDIUM-TRANSFORMATION . :generic)
 (MEDIUMP . :function)
 (MEMBER . :presentation-type-abbrev)
 (MEMBER-ALIST . :presentation-type-abbrev)
 (MEMBER-SEQUENCE . :presentation-type-abbrev)
 (MENU-BUTTON . :class)
 (MENU-BUTTON-PANE . :class)
 (MENU-CHOOSE . :generic)
 (MENU-CHOOSE-COMMAND-FROM-COMMAND-TABLE . :function)
 (MENU-CHOOSE-FROM-DRAWER . :generic)
 (MENU-COMMAND-PARSER . :function)
 (MENU-ITEM-DISPLAY . :function)
 (MENU-ITEM-OPTIONS . :function)
 (MENU-ITEM-VALUE . :function)
 (MENU-READ-REMAINING-ARGUMENTS-FOR-PARTIAL-COMMAND . :function)
 (MERGE-TEXT-STYLES . :generic)
 (MIRRORED-SHEET-MIXIN . :class)
 (MODIFIER-STATE-MATCHES-GESTURE-NAME-P . :function)
 (MOVE-AND-RESIZE-SHEET . :generic)
 (MOVE-SHEET . :generic)
 (NEW-PAGE . :function)
 (NIL . :presentation-type)
 (NOTE-COMMAND-DISABLED . :generic)
 (NOTE-COMMAND-ENABLED . :generic)
 (NOTE-FRAME-DEICONIFIED . :generic)
 (NOTE-FRAME-DISABLED . :generic)
 (NOTE-FRAME-ENABLED . :generic)
 (NOTE-FRAME-ICONIFIED . :generic)
 (NOTE-GADGET-ACTIVATED . :generic)
 (NOTE-GADGET-DEACTIVATED . :generic)
 (NOTE-OUTPUT-RECORD-CHILD-CHANGED . :generic)
 (NOTE-SHEET-ADOPTED . :generic)
 (NOTE-SHEET-DEGRAFTED . :generic)
 (NOTE-SHEET-DISABLED . :generic)
 (NOTE-SHEET-DISOWNED . :generic)
 (NOTE-SHEET-ENABLED . :generic)
 (NOTE-SHEET-GRAFTED . :generic)
 (NOTE-SHEET-REGION-CHANGED . :generic)
 (NOTE-SHEET-TRANSFORMATION-CHANGED . :generic)
 (NOTE-SPACE-REQUIREMENTS-CHANGED . :generic)
 (NOTIFY-USER . :generic)
 (NULL . :presentation-type)
 (NULL-OR-TYPE . :presentation-type-abbrev)
 (NUMBER . :presentation-type)
 (OPACITY . :protocol-class)
 (OPACITY-VALUE . :generic)
 (OPACITYP . :function)
 (OPEN-STREAM-P . :generic)
 (OPEN-WINDOW-STREAM . :function)
 (OPTION-PANE . :class)
 (OR . :presentation-type)
 (ORIENTED-GADGET-MIXIN . :class)
 (OUTLINED-PANE . :pane)
 (OUTLINING . :macro)
 (OUTPUT-RECORD . :protocol-class)
 (OUTPUT-RECORD-CACHE-VALUE . :generic)
 (OUTPUT-RECORD-CHILDREN . :generic)
 (OUTPUT-RECORD-CONTENTS-OK . :generic)
 (OUTPUT-RECORD-COUNT . :generic)
 (OUTPUT-RECORD-DISPLAYER . :generic)
 (OUTPUT-RECORD-END-CURSOR-POSITION . :generic)
 (OUTPUT-RECORD-FIXED-POSITION . :generic)
 (OUTPUT-RECORD-HIT-DETECTION-RECTANGLE* . :generic)
 (OUTPUT-RECORD-P . :function)
 (OUTPUT-RECORD-PARENT . :generic)
 (OUTPUT-RECORD-POSITION . :generic)
 (OUTPUT-RECORD-REFINED-POSITION-TEST . :generic)
 (OUTPUT-RECORD-START-CURSOR-POSITION . :generic)
 (OUTPUT-RECORD-UNIQUE-ID . :generic)
 (OUTPUT-RECORDING-STREAM . :protocol-class)
 (OUTPUT-RECORDING-STREAM-P . :function)
 (OUTPUT-STREAM-P . :generic)
 (PANE . :protocol-class)
 (PANE-BACKGROUND . :generic)
 (PANE-FOREGROUND . :generic)
 (PANE-FRAME . :generic)
 (PANE-NAME . :generic)
 (PANE-NEEDS-REDISPLAY . :generic)
 (PANE-SCROLLER . :generic)
 (PANE-TEXT-STYLE . :generic)
 (PANE-VIEWPORT . :generic)
 (PANE-VIEWPORT-REGION . :generic)
 (PANEP . :function)
 (PARSE-TEXT-STYLE . :function)
 (PARTIAL-COMMAND-P . :function)
 (PATH . :protocol-class)
 (PATHNAME . :presentation-type)
 (PATHP . :function)
 (PATTERN-HEIGHT . :generic)
 (PATTERN-WIDTH . :generic)
 (PERMANENT-MEDIUM-SHEET-OUTPUT-MIXIN . :class)
 (PIXMAP-DEPTH . :generic)
 (PIXMAP-HEIGHT . :generic)
 (PIXMAP-WIDTH . :generic)
 (POINT . :protocol-class)
 (POINT-POSITION . :generic)
 (POINT-X . :generic)
 (POINT-Y . :generic)
 (POINTER . :protocol-class)
 (POINTER-BOUNDARY-EVENT . :class)
 (POINTER-BOUNDARY-EVENT-KIND . :generic)
 (POINTER-BUTTON-EVENT . :class)
 (POINTER-BUTTON-HOLD-EVENT . :class)
 (POINTER-BUTTON-PRESS-EVENT . :class)
 (POINTER-BUTTON-RELEASE-EVENT . :class)
 (POINTER-BUTTON-STATE . :generic)
 (POINTER-CLICK-AND-HOLD-EVENT . :class)
 (POINTER-CLICK-EVENT . :class)
 (POINTER-CURSOR . :generic)
 (POINTER-DOCUMENTATION-PANE . :pane)
 (POINTER-DOCUMENTATION-VIEW . :class)
 (POINTER-DOUBLE-CLICK-EVENT . :class)
 (POINTER-ENTER-EVENT . :class)
 (POINTER-EVENT . :class)
 (POINTER-EVENT-BUTTON . :generic)
 (POINTER-EVENT-NATIVE-X . :generic)
 (POINTER-EVENT-NATIVE-Y . :generic)
 (POINTER-EVENT-POINTER . :generic)
 (POINTER-EVENT-X . :generic)
 (POINTER-EVENT-Y . :generic)
 (POINTER-EXIT-EVENT . :class)
 (POINTER-MOTION-EVENT . :class)
 (POINTER-POSITION . :generic)
 (POINTER-SHEET . :generic)
 (POINTERP . :function)
 (POINTP . :function)
 (POLYGON . :protocol-class)
 (POLYGON-POINTS . :generic)
 (POLYGONP . :function)
 (POLYLINE . :protocol-class)
 (POLYLINE-CLOSED . :generic)
 (POLYLINEP . :function)
 (PORT . :protocol-class)
 (PORT . :generic)
 (PORT-KEYBOARD-INPUT-FOCUS . :generic)
 (PORT-NAME . :generic)
 (PORT-PROPERTIES . :generic)
 (PORT-SERVER-PATH . :generic)
 (PORT-TYPE . :generic)
 (PORTP . :function)
 (PRESENT . :presentation-method)
 (PRESENT . :function)
 (PRESENT-TO-STRING . :function)
 (PRESENTATION . :protocol-class)
 (PRESENTATION-DEFAULT-PREPROCESSOR . :presentation-method)
 (PRESENTATION-MATCHES-CONTEXT-TYPE . :function)
 (PRESENTATION-MODIFIER . :generic)
 (PRESENTATION-OBJECT . :generic)
 (PRESENTATION-REFINED-POSITION-TEST . :presentation-method)
 (PRESENTATION-REPLACE-INPUT . :generic)
 (PRESENTATION-SINGLE-BOX . :generic)
 (PRESENTATION-SUBTYPEP . :presentation-method)
 (PRESENTATION-SUBTYPEP . :function)
 (PRESENTATION-TYPE . :generic)
 (PRESENTATION-TYPE-DIRECT-SUPERTYPES . :function)
 (PRESENTATION-TYPE-HISTORY . :presentation-method)
 (PRESENTATION-TYPE-NAME . :function)
 (PRESENTATION-TYPE-OF . :function)
 (PRESENTATION-TYPE-OPTIONS . :function)
 (PRESENTATION-TYPE-PARAMETERS . :function)
 (PRESENTATION-TYPE-SPECIFIER-P . :presentation-method)
 (PRESENTATION-TYPE-SPECIFIER-P . :function)
 (PRESENTATION-TYPEP . :presentation-method)
 (PRESENTATION-TYPEP . :function)
 (PRESENTATIONP . :function)
 (PRINT-MENU-ITEM . :function)
 (PROCESS-NEXT-EVENT . :generic)
 (PROMPT-FOR-ACCEPT . :generic)
 (PROMPT-FOR-ACCEPT-1 . :function)
 (PROPAGATE-OUTPUT-RECORD-CHANGES . :generic)
 (PROPAGATE-OUTPUT-RECORD-CHANGES-P . :generic)
 (PUSH-BUTTON . :class)
 (PUSH-BUTTON-PANE . :class)
 (PUSH-BUTTON-SHOW-AS-DEFAULT . :generic)
 (QUEUE-EVENT . :generic)
 (QUEUE-REPAINT . :generic)
 (QUEUE-RESCAN . :generic)
 (RADIO-BOX . :class)
 (RADIO-BOX-CURRENT-SELECTION . :generic)
 (RADIO-BOX-PANE . :class)
 (RADIO-BOX-SELECTIONS . :generic)
 (RAISE-FRAME . :generic)
 (RAISE-MIRROR . :generic)
 (RAISE-SHEET . :generic)
 (RANGE-GADGET-MIXIN . :class)
 (RATIO . :presentation-type)
 (RATIONAL . :presentation-type)
 (READ-BITMAP-FILE . :generic)
 (READ-COMMAND . :function)
 (READ-COMMAND-USING-KEYSTROKES . :function)
 (READ-FRAME-COMMAND . :generic)
 (READ-GESTURE . :function)
 (READ-TOKEN . :function)
 (REAL . :presentation-type)
 (REALIZE-MIRROR . :generic)
 (RECOMPUTE-CONTENTS-OK . :generic)
 (RECOMPUTE-EXTENT-FOR-CHANGED-CHILD . :generic)
 (RECOMPUTE-EXTENT-FOR-NEW-CHILD . :generic)
 (RECTANGLE . :protocol-class)
 (RECTANGLE-EDGES* . :generic)
 (RECTANGLE-HEIGHT . :generic)
 (RECTANGLE-MAX-POINT . :generic)
 (RECTANGLE-MAX-X . :generic)
 (RECTANGLE-MAX-Y . :generic)
 (RECTANGLE-MIN-POINT . :generic)
 (RECTANGLE-MIN-X . :generic)
 (RECTANGLE-MIN-Y . :generic)
 (RECTANGLE-SIZE . :generic)
 (RECTANGLE-WIDTH . :generic)
 (RECTANGLEP . :function)
 (RECTILINEAR-TRANSFORMATION-P . :generic)
 (REDISPLAY . :function)
 (REDISPLAY-FRAME-PANE . :generic)
 (REDISPLAY-FRAME-PANES . :generic)
 (REDISPLAY-OUTPUT-RECORD . :generic)
 (REDISPLAYABLE-STREAM-P . :generic)
 (REDRAW-INPUT-BUFFER . :generic)
 (REFLECTION-TRANSFORMATION-P . :generic)
 (REFLECTION-UNDERSPECIFIED . :condition)
 (REGION . :protocol-class)
 (REGION-CONTAINS-POSITION-P . :generic)
 (REGION-CONTAINS-REGION-P . :generic)
 (REGION-DIFFERENCE . :generic)
 (REGION-EQUAL . :generic)
 (REGION-INTERSECTION . :generic)
 (REGION-INTERSECTS-REGION-P . :generic)
 (REGION-SET . :protocol-class)
 (REGION-SET-P . :function)
 (REGION-SET-REGIONS . :generic)
 (REGION-UNION . :generic)
 (REGIONP . :function)
 (REMOVE-COMMAND-FROM-COMMAND-TABLE . :function)
 (REMOVE-KEYSTROKE-FROM-COMMAND-TABLE . :function)
 (REMOVE-MENU-ITEM-FROM-COMMAND-TABLE . :function)
 (REMOVE-PRESENTATION-TRANSLATOR-FROM-COMMAND-TABLE . :function)
 (REORDER-SHEETS . :generic)
 (REPAINT-SHEET . :generic)
 (REPLACE-INPUT . :generic)
 (REPLAY . :function)
 (REPLAY-OUTPUT-RECORD . :generic)
 (RESCAN-IF-NECESSARY . :generic)
 (RESET-FRAME . :generic)
 (RESET-SCAN-POINTER . :generic)
 (RESIZE-SHEET . :generic)
 (RESTART-PORT . :generic)
 (RESTRAINING . :macro)
 (RESTRAINING-PANE . :pane)
 (RIGID-TRANSFORMATION-P . :generic)
 (ROW-OUTPUT-RECORD . :protocol-class)
 (ROW-OUTPUT-RECORD-P . :function)
 (RUN-FRAME-TOP-LEVEL . :generic)
 (SCALING-TRANSFORMATION-P . :generic)
 (SCROLL-BAR . :class)
 (SCROLL-BAR-DRAG-CALLBACK . :generic)
 (SCROLL-BAR-PANE . :class)
 (SCROLL-BAR-SCROLL-DOWN-LINE-CALLBACK . :generic)
 (SCROLL-BAR-SCROLL-DOWN-PAGE-CALLBACK . :generic)
 (SCROLL-BAR-SCROLL-TO-BOTTOM-CALLBACK . :generic)
 (SCROLL-BAR-SCROLL-TO-TOP-CALLBACK . :generic)
 (SCROLL-BAR-SCROLL-UP-LINE-CALLBACK . :generic)
 (SCROLL-BAR-SCROLL-UP-PAGE-CALLBACK . :generic)
 (SCROLL-DOWN-LINE-CALLBACK . :callback)
 (SCROLL-DOWN-PAGE-CALLBACK . :callback)
 (SCROLL-EXTENT . :generic)
 (SCROLL-TO-BOTTOM-CALLBACK . :callback)
 (SCROLL-TO-TOP-CALLBACK . :callback)
 (SCROLL-UP-LINE-CALLBACK . :callback)
 (SCROLL-UP-PAGE-CALLBACK . :callback)
                                        ;"SCROLLER-PANE"                      ;pane
                                        ;"SCROLLING"                          ;macro
 (SEQUENCE . :presentation-type)
 (SEQUENCE-ENUMERATED . :presentation-type)
 (SET-HIGHLIGHTED-PRESENTATION . :function)
 (SHEET . :protocol-class)
 (SHEET-ADOPT-CHILD . :generic)
 (SHEET-ALLOCATED-REGION . :generic)
 (SHEET-ANCESTOR-P . :generic)
 (SHEET-CHILDREN . :generic)
 (SHEET-DELTA-TRANSFORMATION . :generic)
 (SHEET-DEVICE-REGION . :generic)
 (SHEET-DEVICE-TRANSFORMATION . :generic)
 (SHEET-DIRECT-MIRROR . :generic)
 (SHEET-DISOWN-CHILD . :generic)
 (SHEET-ENABLED-CHILDREN . :generic)
 (SHEET-ENABLED-P . :generic)
 (SHEET-EVENT-QUEUE . :generic)
 (SHEET-GRAFTED-P . :generic)
 (SHEET-IDENTITY-TRANSFORMATION-MIXIN . :class)
 (SHEET-LEAF-MIXIN . :class)
 (SHEET-MEDIUM . :generic)
 (SHEET-MIRROR . :generic)
 (SHEET-MIRRORED-ANCESTOR . :generic)
 (SHEET-MULTIPLE-CHILD-MIXIN . :class)
 (SHEET-MUTE-INPUT-MIXIN . :class)
 (SHEET-MUTE-OUTPUT-MIXIN . :class)
 (SHEET-MUTE-REPAINTING-MIXIN . :class)
 (SHEET-NATIVE-REGION . :generic)
 (SHEET-NATIVE-TRANSFORMATION . :generic)
 (SHEET-OCCLUDING-SHEETS . :generic)
 (SHEET-PARENT . :generic)
 (SHEET-PARENT-MIXIN . :class)
 (SHEET-REGION . :generic)
 (SHEET-SIBLINGS . :generic)
 (SHEET-SINGLE-CHILD-MIXIN . :class)
 (SHEET-TRANSFORMATION . :generic)
 (SHEET-TRANSFORMATION-MIXIN . :class)
 (SHEET-TRANSLATION-MIXIN . :class)
 (SHEET-VIEWABLE-P . :generic)
 (SHEET-WITH-MEDIUM-MIXIN . :class)
 (SHEET-Y-INVERTING-TRANSFORMATION-MIXIN . :class)
 (SHEETP . :function)
 (SHRINK-FRAME . :generic)
 (SIMPLE-COMPLETION-ERROR . :condition)
 (SIMPLE-PARSE-ERROR . :condition)
 (SIMPLE-PARSE-ERROR . :function)
 (SINGULAR-TRANSFORMATION . :condition)
 (SLIDER . :class)
 (SLIDER-DRAG-CALLBACK . :generic)
 (SLIDER-PANE . :class)
 (SPACE-REQUIREMENT . :class)
 (SPACE-REQUIREMENT+ . :function)
 (SPACE-REQUIREMENT+* . :function)
 (SPACE-REQUIREMENT-COMBINE . :function)
 (SPACE-REQUIREMENT-COMPONENTS . :generic)
 (SPACE-REQUIREMENT-HEIGHT . :generic)
 (SPACE-REQUIREMENT-MAX-HEIGHT . :generic)
 (SPACE-REQUIREMENT-MAX-WIDTH . :generic)
 (SPACE-REQUIREMENT-MIN-HEIGHT . :generic)
 (SPACE-REQUIREMENT-MIN-WIDTH . :generic)
 (SPACE-REQUIREMENT-WIDTH . :generic)
 (STANDARD-APPLICATION-FRAME . :class)
 (STANDARD-BOUNDING-RECTANGLE . :class)
 (STANDARD-CELL-OUTPUT-RECORD . :class)
 (STANDARD-COLUMN-OUTPUT-RECORD . :class)
 (STANDARD-COMMAND-TABLE . :class)
 (STANDARD-ELLIPSE . :class)
 (STANDARD-ELLIPTICAL-ARC . :class)
 (STANDARD-ENCAPSULATING-STREAM . :class)
 (STANDARD-EXTENDED-INPUT-STREAM . :class)
 (STANDARD-EXTENDED-OUTPUT-STREAM . :class)
 (STANDARD-GRAPH-NODE-OUTPUT-RECORD . :class)
 (STANDARD-GRAPH-OUTPUT-RECORD . :class)
 (STANDARD-INPUT-EDITING-STREAM . :class)
 (STANDARD-INPUT-STREAM . :class)
 (STANDARD-ITEM-LIST-OUTPUT-RECORD . :class)
 (STANDARD-LINE . :class)
 (STANDARD-LINE-STYLE . :class)
 (STANDARD-OUTPUT-RECORDING-STREAM . :class)
 (STANDARD-OUTPUT-STREAM . :class)
 (STANDARD-POINT . :class)
 (STANDARD-POINTER . :class)
 (STANDARD-POLYGON . :class)
 (STANDARD-POLYLINE . :class)
 (STANDARD-PRESENTATION . :class)
 (STANDARD-RECTANGLE . :class)
 (STANDARD-REGION-DIFFERENCE . :class)
 (STANDARD-REGION-INTERSECTION . :class)
 (STANDARD-REGION-UNION . :class)
 (STANDARD-REPAINTING-MIXIN . :class)
 (STANDARD-ROW-OUTPUT-RECORD . :class)
 (STANDARD-SEQUENCE-OUTPUT-HISTORY . :class)
 (STANDARD-SEQUENCE-OUTPUT-RECORD . :class)
 (STANDARD-SHEET-INPUT-MIXIN . :class)
 (STANDARD-SHEET-OUTPUT-MIXIN . :class)
 (STANDARD-TABLE-OUTPUT-RECORD . :class)
 (STANDARD-TEXT-CURSOR . :class)
 (STANDARD-TEXT-STYLE . :class)
 (STANDARD-TREE-OUTPUT-HISTORY . :class)
 (STANDARD-TREE-OUTPUT-RECORD . :class)
 (STANDARD-UPDATING-OUTPUT-RECORD . :class)
 (STREAM-ACCEPT . :generic)
 (STREAM-ADD-CHARACTER-OUTPUT . :generic)
 (STREAM-ADD-OUTPUT-RECORD . :generic)
 (STREAM-ADD-STRING-OUTPUT . :generic)
 (STREAM-ADVANCE-TO-COLUMN . :generic)
 (STREAM-ADVANCE-TO-COLUMN . :generic)
 (STREAM-BASELINE . :generic)
 (STREAM-CHARACTER-WIDTH . :generic)
 (STREAM-CLEAR-INPUT . :generic)
 (STREAM-CLEAR-INPUT . :generic)
 (STREAM-CLEAR-OUTPUT . :generic)
 (STREAM-CLEAR-OUTPUT . :generic)
 (STREAM-CLOSE-TEXT-OUTPUT-RECORD . :generic)
 (STREAM-CURRENT-OUTPUT-RECORD . :generic)
 (STREAM-CURSOR-POSITION . :generic)
 (STREAM-DEFAULT-VIEW . :generic)
 (STREAM-DRAWING-P . :generic)
 (STREAM-ELEMENT-TYPE . :generic)
 (STREAM-END-OF-LINE-ACTION . :generic)
 (STREAM-END-OF-PAGE-ACTION . :generic)
 (STREAM-FINISH-OUTPUT . :generic)
 (STREAM-FINISH-OUTPUT . :generic)
 (STREAM-FORCE-OUTPUT . :generic)
 (STREAM-FORCE-OUTPUT . :generic)
 (STREAM-FRESH-LINE . :generic)
 (STREAM-FRESH-LINE . :generic)
 (STREAM-INCREMENT-CURSOR-POSITION . :generic)
 (STREAM-INPUT-BUFFER . :generic)
 (STREAM-INPUT-WAIT . :generic)
 (STREAM-INSERTION-POINTER . :generic)
 (STREAM-LINE-COLUMN . :generic)
 (STREAM-LINE-COLUMN . :generic)
 (STREAM-LINE-HEIGHT . :generic)
 (STREAM-LISTEN . :generic)
 (STREAM-LISTEN . :generic)
 (STREAM-OUTPUT-HISTORY . :generic)
 (STREAM-OUTPUT-HISTORY-MIXIN . :class)
 (STREAM-PATHNAME . :generic)
 (STREAM-PEEK-CHAR . :generic)
 (STREAM-PEEK-CHAR . :generic)
 (STREAM-POINTER-POSITION . :generic)
 (STREAM-PRESENT . :generic)
 (STREAM-PROCESS-GESTURE . :generic)
 (STREAM-READ-BYTE . :generic)
 (STREAM-READ-CHAR . :generic)
 (STREAM-READ-CHAR . :generic)
 (STREAM-READ-CHAR-NO-HANG . :generic)
 (STREAM-READ-CHAR-NO-HANG . :generic)
 (STREAM-READ-GESTURE . :generic)
 (STREAM-READ-LINE . :generic)
 (STREAM-READ-LINE . :generic)
 (STREAM-RECORDING-P . :generic)
 (STREAM-REDISPLAYING-P . :generic)
 (STREAM-REPLAY . :generic)
 (STREAM-RESCANNING-P . :generic)
 (STREAM-SCAN-POINTER . :generic)
 (STREAM-SET-INPUT-FOCUS . :generic)
 (STREAM-START-LINE-P . :generic)
 (STREAM-START-LINE-P . :generic)
 (STREAM-STRING-WIDTH . :generic)
 (STREAM-TERPRI . :generic)
 (STREAM-TERPRI . :generic)
 (STREAM-TEXT-CURSOR . :generic)
 (STREAM-TEXT-MARGIN . :generic)
 (STREAM-TEXT-OUTPUT-RECORD . :generic)
 (STREAM-TRUENAME . :generic)
 (STREAM-UNREAD-CHAR . :generic)
 (STREAM-UNREAD-CHAR . :generic)
 (STREAM-UNREAD-GESTURE . :generic)
 (STREAM-VERTICAL-SPACING . :generic)
 (STREAM-WRITE-BYTE . :generic)
 (STREAM-WRITE-CHAR . :generic)
 (STREAM-WRITE-CHAR . :generic)
 (STREAM-WRITE-STRING . :generic)
 (STREAM-WRITE-STRING . :generic)
 (STREAMP . :generic)
 (STRING . :presentation-type)
 (SUBSET . :presentation-type-abbrev)
 (SUBSET-ALIST . :presentation-type-abbrev)
 (SUBSET-COMPLETION . :presentation-type)
 (SUBSET-SEQUENCE . :presentation-type-abbrev)
 (SUBSTITUTE-NUMERIC-ARGUMENT-MARKER . :function)
 (SUGGEST . :function)
 (SURROUNDING-OUTPUT-WITH-BORDER . :macro)
 (SYMBOL . :presentation-type)
 (T . :presentation-type)
 (TABLE-OUTPUT-RECORD . :protocol-class)
 (TABLE-OUTPUT-RECORD-P . :function)
 (TABLE-PANE . :pane)
 (TABLING . :macro)
 (TEMPORARY-MEDIUM-SHEET-OUTPUT-MIXIN . :class)
 (TEST-PRESENTATION-TRANSLATOR . :function)
 (TEXT-DISPLAYED-OUTPUT-RECORD . :protocol-class)
 (TEXT-DISPLAYED-OUTPUT-RECORD-P . :function)
 (TEXT-DISPLAYED-OUTPUT-RECORD-STRING . :generic)
 (TEXT-EDITOR . :class)
 (TEXT-EDITOR-PANE . :class)
 (TEXT-FIELD . :class)
 (TEXT-FIELD-PANE . :class)
 (TEXT-SIZE . :generic)
 (TEXT-STYLE . :protocol-class)
 (TEXT-STYLE-ASCENT . :generic)
 (TEXT-STYLE-COMPONENTS . :generic)
 (TEXT-STYLE-DESCENT . :generic)
 (TEXT-STYLE-FACE . :generic)
 (TEXT-STYLE-FAMILY . :generic)
 (TEXT-STYLE-FIXED-WIDTH-P . :generic)
 (TEXT-STYLE-HEIGHT . :generic)
 (TEXT-STYLE-MAPPING . :generic)
 (TEXT-STYLE-P . :function)
 (TEXT-STYLE-SIZE . :generic)
 (TEXT-STYLE-WIDTH . :generic)
 (TEXTUAL-DIALOG-VIEW . :class)
 (TEXTUAL-MENU-VIEW . :class)
 (TEXTUAL-VIEW . :class)
 (THROW-HIGHLIGHTED-PRESENTATION . :function)
 (TIMER-EVENT . :class)
 (TITLE-PANE . :pane)
 (TOGGLE-BUTTON . :class)
 (TOGGLE-BUTTON-INDICATOR-TYPE . :generic)
 (TOGGLE-BUTTON-PANE . :class)
 (TOKEN-OR-TYPE . :presentation-type-abbrev)
 (TRACKING-POINTER . :macro)
 (TRANSFORM-DISTANCE . :generic)
 (TRANSFORM-POSITION . :generic)
 (TRANSFORM-RECTANGLE* . :generic)
 (TRANSFORM-REGION . :generic)
 (TRANSFORMATION . :protocol-class)
 (TRANSFORMATION-EQUAL . :generic)
 (TRANSFORMATION-ERROR . :condition)
 (TRANSFORMATION-UNDERSPECIFIED . :condition)
 (TRANSFORMATIONP . :function)
 (TRANSLATION-TRANSFORMATION-P . :generic)
 (TREE-RECOMPUTE-EXTENT . :generic)
 (TYPE-OR-STRING . :presentation-type-abbrev)
 (UNHIGHLIGHT-HIGHLIGHTED-PRESENTATION . :function)
 (UNREAD-GESTURE . :function)
 (UNTRANSFORM-DISTANCE . :generic)
 (UNTRANSFORM-POSITION . :generic)
 (UNTRANSFORM-RECTANGLE* . :generic)
 (UNTRANSFORM-REGION . :generic)
 (UPDATING-OUTPUT . :macro)
 (UPDATING-OUTPUT-RECORD . :protocol-class)
 (UPDATING-OUTPUT-RECORD-P . :function)
 (USER-COMMAND-TABLE . :command-table)
 (VALUE-CHANGED-CALLBACK . :callback)
 (VALUE-GADGET . :class)
 (VBOX-PANE . :pane)
 (VERTICALLY . :macro)
 (VIEW . :protocol-class)
 (VIEWP . :function)
 (VRACK-PANE . :pane)
 (WINDOW-CLEAR . :generic)
 (WINDOW-CONFIGURATION-EVENT . :class)
 (WINDOW-ERASE-VIEWPORT . :generic)
 (WINDOW-EVENT . :class)
 (WINDOW-EVENT-MIRRORED-SHEET . :generic)
 (WINDOW-EVENT-NATIVE-REGION . :generic)
 (WINDOW-EVENT-REGION . :generic)
 (WINDOW-MANAGER-DELETE-EVENT . :class)
 (WINDOW-MANAGER-EVENT . :class)
 (WINDOW-REFRESH . :generic)
 (WINDOW-REPAINT-EVENT . :class)
 (WINDOW-VIEWPORT . :generic)
 (WINDOW-VIEWPORT-POSITION . :generic)
 (WITH-ACCEPT-HELP . :macro)
 (WITH-ACTIVATION-GESTURES . :macro)
 (WITH-APPLICATION-FRAME . :macro)
 (WITH-BOUNDING-RECTANGLE* . :macro)
 (WITH-COMMAND-TABLE-KEYSTROKES . :macro)
 (WITH-DELIMITER-GESTURES . :macro)
 (WITH-DRAWING-OPTIONS . :macro)
 (WITH-END-OF-LINE-ACTION . :macro)
 (WITH-END-OF-PAGE-ACTION . :macro)
 (WITH-FIRST-QUADRANT-COORDINATES . :macro)
 (WITH-FRAME-MANAGER . :macro)
 (WITH-GRAFT-LOCKED . :macro)
 (WITH-IDENTITY-TRANSFORMATION . :macro)
 (WITH-INPUT-CONTEXT . :macro)
 (WITH-INPUT-EDITING . :macro)
 (WITH-INPUT-EDITOR-TYPEOUT . :macro)
 (WITH-INPUT-FOCUS . :macro)
 (WITH-LOCAL-COORDINATES . :macro)
 (WITH-LOOK-AND-FEEL-REALIZATION . :macro)
 (WITH-MENU . :macro)
 (WITH-NEW-OUTPUT-RECORD . :macro)
 (WITH-OUTPUT-AS-GADGET . :macro)
 (WITH-OUTPUT-AS-PRESENTATION . :macro)
 (WITH-OUTPUT-BUFFERED . :macro)
 (WITH-OUTPUT-RECORDING-OPTIONS . :macro)
 (WITH-OUTPUT-TO-OUTPUT-RECORD . :macro)
 (WITH-OUTPUT-TO-PIXMAP . :macro)
 (WITH-OUTPUT-TO-POSTSCRIPT-STREAM . :macro)
 (WITH-PORT-LOCKED . :macro)
 (WITH-PRESENTATION-TYPE-DECODED . :macro)
 (WITH-PRESENTATION-TYPE-OPTIONS . :macro)
 (WITH-PRESENTATION-TYPE-PARAMETERS . :macro)
 (WITH-RADIO-BOX . :macro)
 (WITH-ROOM-FOR-GRAPHICS . :macro)
 (WITH-ROTATION . :macro)
 (WITH-SCALING . :macro)
 (WITH-SHEET-MEDIUM . :macro)
 (WITH-SHEET-MEDIUM-BOUND . :macro)
 (WITH-TEXT-FACE . :macro)
 (WITH-TEXT-FAMILY . :macro)
 (WITH-TEXT-SIZE . :macro)
 (WITH-TEXT-STYLE . :macro)
 (WITH-TRANSLATION . :macro)
 (WRITE-TOKEN . :function)
                       ))

(defgeneric check-symbol (symbol category))

(defun check ()
  (loop for (symbol . category) in *info*
     do (unless (check-symbol symbol category)
          (format t "~&Error: ~S ~S.~%" symbol category))))

(defmethod check-symbol (symbol (category (eql :function)))
  (fboundp symbol))

(defmethod check-symbol (symbol (category (eql :macro)))
  (macro-function symbol))

(defmethod check-symbol (symbol (category (eql :variable)))
  t)

(defmethod check-symbol (symbol (category (eql :constant)))
  (boundp symbol))

(defmethod check-symbol (symbol (category (eql :condition)))
  (subtypep symbol 'condition))

(defmethod check-symbol (symbol (category (eql :generic)))
  (and (fboundp symbol)
       (typep (symbol-function symbol) 'generic-function)))

(defmethod check-symbol (symbol (category (eql :class)))
  (find-class symbol nil))

(defmethod check-symbol (symbol (category (eql :protocol-class)))
  (check-symbol symbol :class))

(defmethod check-symbol (symbol (category (eql :command-table)))
  (find-command-table symbol :errorp nil))


(defmethod check-symbol (symbol (category (eql :presentation-method)))
  t)

(defmethod check-symbol (symbol (category (eql :presentation-type)))
  t)

(defmethod check-symbol (symbol (category (eql :frame)))
  t)

(defmethod check-symbol (symbol (category (eql :callback)))
  t)

(defmethod check-symbol (symbol (category (eql :pane)))
  t)

(defmethod check-symbol (symbol (category (eql :type)))
  t)

(defmethod check-symbol (symbol (category (eql :presentation-type-abbrev)))
  t)