/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          property_bridge_view.h  -  description
                             -------------------
    begin                : Tue Dec 3 2002
    copyright            : (C) 2002 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROPERTY_BRIDGE_VIEW_H
#define PROPERTY_BRIDGE_VIEW_H

#include <gtkmm/box.h>
#include <gtkmm/separator.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/scale.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/checkbutton.h>
#include "components/data/property_bridges.h"

/**
  *@author Juan Linietsky
  */

class Bridge_View_Int : public Gtk::HBox  {

	Gtk::Label label;
	Gtk::HSeparator separator;
	Gtk::Adjustment adj;
	Gtk::SpinButton spin;

	Int_Property_Bridge *bridge;

	void adj_value_changed();

public: 

	void set_bridge(Int_Property_Bridge *p_bridge);
	Bridge_View_Int();
};

class Bridge_View_Int_Slider : public Gtk::VBox  {

	Gtk::Label label;
	Gtk::Adjustment adj;
	Gtk::HScale slider;

	Int_Property_Bridge *bridge;

	void adj_value_changed();

public: 

	void set_bridge(Int_Property_Bridge *p_bridge);
	Bridge_View_Int_Slider();
};


class Bridge_View_Bool : public Gtk::HBox  {


	Gtk::Label label;
	Gtk::HSeparator separator;
	Gtk::CheckButton check;
	Bool_Property_Bridge *bridge;

	void value_changed();

public:

	void set_bridge(Bool_Property_Bridge *p_bridge);
	Bridge_View_Bool();
};


class Bridge_View_String : public Gtk::HBox  {


	Gtk::Label label;
	Gtk::Entry entry;
	String_Property_Bridge *bridge;

	void value_changed();

public:

	void set_bridge(String_Property_Bridge *p_bridge);
	Bridge_View_String();
};

#endif
