/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          interface_widget_sample_display.cpp  -  description
                             -------------------
    begin                : Fri Jul 5 2002
    copyright            : (C) 2002 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface_widget_sample_display.h"

int Widget_Sample_Display::color_values[] = {
    10, 20, 30,
    250, 100, 100,
    250, 250, 250

};
void Widget_Sample_Display::allocate_colormap () {

	Gdk::Color tmpcolor;
	int i;
	for (i=0;i<Max_Colors*3;i+=3) {

		colors[i/3].set_red( color_values[i] * 0xFFFF / 0xFF );
		colors[i/3].set_green(  color_values[i+1] * 0xFFFF / 0xFF );
		colors[i/3].set_blue ( color_values[i+2] * 0xFFFF / 0xFF );
	        get_colormap()->alloc_color(colors[i/3]);
	}

}

void Widget_Sample_Display::init_colors() {

	allocate_colormap();


	for (int i=0;i<(Max_Colors);i++) {

		GC[i]=Gdk::GC::create(get_window());
		GC[i]->set_foreground(colors[i]);

	}

	//add_events(Gdk::ALL_EVENTS_MASK);

}

void Widget_Sample_Display::set_sample_data(Sample_Data *p_sample_data) {

 	sample_data=p_sample_data;
	queue_draw();
}

Widget_Sample_Display::Widget_Sample_Display(){
	
	signal_realize().connect(slot(*this,&Widget_Sample_Display::init_colors));
}

Widget_Sample_Display::~Widget_Sample_Display(){
}

