/*
** Routine for setting the background color by RGB values.
** ff, 1998.
*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>

void set_rgb(int red, int green, int blue)
{
	XColor		color;
	Colormap	cmap;
	Display		*display;
	Window		window;
	int		screen;

	display = XOpenDisplay(NULL);

	screen = DefaultScreen(display);
	window = DefaultRootWindow(display);

	cmap = DefaultColormap(display, screen);

	color.red = red;
	color.green = green;
	color.blue = blue;
	color.flags = DoRed | DoGreen | DoBlue;

	XAllocColor(display, cmap, &color);

	XSetWindowBackground(display, window, color.pixel);
	XClearWindow(display, window);

	XFreeColormap(display, cmap);

	XCloseDisplay(display);
}
