/****************************************************************************
                         Hyper's CD Catalog
         A multiplatform qt and xml based catalog program
		     
      Author    : Peter Deak (hyperr@freemail.hu)
      License   : GPL
      Copyright : (C) 2003 Peter Deak
****************************************************************************/

#ifndef SELREADABLE_H
#define SELREADABLE_H

#include <qvariant.h>
#include <qdialog.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QCheckBox;
class QFrame;
class QLabel;
class QLineEdit;
class QPushButton;
class QSpinBox;
class CdCatConfig;
class QButtonGroup;
class QRadioButton;

class SelReadable : public QDialog
{
    Q_OBJECT

public:
    SelReadable( CdCatConfig *confp,QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~SelReadable();

    CdCatConfig *conf;
    QCheckBox* cbTag;
    QCheckBox* cbInfo;
    QFrame* line0;
    QCheckBox* cbaInfo;
    QFrame* line1;
    QCheckBox* cbCont;
    QLineEdit* lineFiles;
    QLabel* textLabel1;
    QSpinBox* maxSpinBox;
    QLabel* textLabel2;
    QFrame* line2;
    QPushButton* buttonOK;
    QPushButton* buttonCancel;
    QButtonGroup* tagselector;
    QRadioButton *rad_v1,*rad_v2;
    

public slots:
    int schanged(int state);
    int sok(void);
    int scan(void);

protected:
    QVBoxLayout* SelReadableLayout;
    QHBoxLayout* layout12;
    QVBoxLayout* layout11;
    QHBoxLayout* layout9;
    QHBoxLayout* layout10;
    QHBoxLayout* layout3;
    QHBoxLayout* layout1;

protected slots:
    virtual void languageChange();
};

#endif // SELREADABLE_H
