(* $Id: server.ml 182 2004-05-25 16:49:11Z gerd $
 * ----------------------------------------------------------------------
 *
 *)

open Rtypes
open Xdr
open Rpc
open Rpc_server
open Sample_aux

let server_port = ref 0;;
  (* this variable will contain the Internet port where this server is
   * listening
   *)



(***** Implementation of the procedures *****)



let plus1 session n reply =
  reply (n+1)
;;


(***** Building a server *****)



let main() =
  let esys = Unixqueue.create_unix_event_system() in

  let server =
    Sample_srv.P.V1.create_async_server
      ~proc_plus1: plus1
      Rpc_server.Portmapped          (* register with the portmapper *)
      Tcp
      Socket
      esys
  in

  (* Set signal handler. Signals are the only way to stop the server;
   * the default behaviour does not clean up the server, so we define
   * appropriate handlers.
   * Clean-up to do is mostly unregistering the program with the portmapper.
   *)

  List.iter
    (fun signal ->
      Sys.set_signal
        signal
	(Sys.Signal_handle (fun _ -> Rpc_server.stop_server server)))
    [ Sys.sighup; Sys.sigint; Sys.sigquit; Sys.sigterm ];

  (* Initialize the 'server_port' variable *)

  server_port := Rpc_portmapper.port_of_program
                   Sample_aux.program_P'V1 "localhost" Tcp;

  (* Now start serving *)

  Unixqueue.run esys
;;


(***** running the server *****)


main();;
