/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: camas_global_addressbook.pike,v 1.1.2.1 2004/01/23 18:41:09 vida Exp $
 */

#include <module.h>
#include <camas/globals.h>
inherit "module";

//
//! module: CAMAS: Global AddressBook
//!  This module handle storage of the Global AddressBook Option for Camas.
//!  <br/>It is needed only if the Global AddressBook Option has been activated
//!  in the CAMAS main module. If it is not activated, you can remove safely
//!  this module from the Caudium Configuration Interface.
//! inherits: module
//! type: MODULE_PROVIDER
//! cvs_version: $Id: camas_global_addressbook.pike,v 1.1.2.1 2004/01/23 18:41:09 vida Exp $
//

constant cvs_version   = "$Id: camas_global_addressbook.pike,v 1.1.2.1 2004/01/23 18:41:09 vida Exp $";
constant module_type   = MODULE_PROVIDER;
constant module_name   = "CAMAS: Old global addressBook (DEPRECATED)";
constant module_doc    = "This module storage of the Global AddressBook Option "
                         "for CAMAS.<br />"
                         "It is a compatibility addressbook for poeple using IMHO screens and tags "
                         "and should not be used";
constant module_unique = 1;
constant thread_safe   = 1;

#if constant(thread_create)
// Lock for sessions
object global_lock = Thread.Mutex();
#endif

// Global addressbook used with CAMAS main module...
string global_addressbook = "";

void create () {
#ifdef CAMAS_DEBUG
  defvar ("debug", 0, "Debug", TYPE_FLAG,
          "When on, debug messages will be logged in Caudium's debug logfile. "
          "This information is very useful to the developers when fixing bugs.");
#endif
  // configurations for global addressbook
  defvar("globaladdressbook", "", "Addresses", TYPE_TEXT_FIELD,
         "List of addresses which will appear in all users' address books. "
         "Format: \"&lt;name&gt;:&lt;address&gt;\", e.g \"CAMAS:camas@caudium.net\".\n");
  // Replace this one in TYPE_FILE ?
  defvar("globaladdressbookfile", "", "File", TYPE_STRING,
         "A file containing global addressbook addresses. Can be in LDIF, "
         "Pine or CSV (Outlook Export, Excel) format. (File in real file "
         " system or empty.)");
}

// Loads the address book from configinterface or file
private void load_global_addressbook() {
#if constant(thread_create)
  object lock = global_lock->lock();
#endif
  mixed err = catch {
    global_addressbook = "";
    array (string) entries = replace(QUERY (globaladdressbook),"\r\n","\n") / "\n";
    string fn = QUERY (globaladdressbookfile);
    string filebook = "";
    if (sizeof(fn) > 0)
      filebook=Stdio.read_bytes(fn) || "";
    filebook = CAMAS.AddressBook.impabook(filebook);
    entries += replace(filebook,"\r\n","\n") / "\n";
    entries = sort(entries);
    foreach(entries, string entry) {
      if (sizeof(entry) > 0)
        global_addressbook += (sizeof(global_addressbook)==0?"":"\n")+entry;
    }
  };
#if constant(thread_create)
  destruct(lock);
#endif
  if(err)
    report_error("error in camas_global_addressbook.pike: %s\n", describe_backtrace(err));
}

string query_provides ()
{
  return ("camas_gabook");
}

void start()
{
  load_global_addressbook();
}


/* START AUTOGENERATED DEFVAR DOCS */

//! defvar: debug
//! When on, debug messages will be logged in Caudium's debug logfile. This information is very useful to the developers when fixing bugs.
//!  type: TYPE_FLAG
//!  name: Debug
//
//! defvar: globaladdressbook
//! List of addresses which will appear in all users' address books. Format: "&lt;name&gt;:&lt;address&gt;", e.g "CAMAS:camas@caudium.net".
//!
//!  type: TYPE_TEXT_FIELD
//!  name: Addresses
//
//! defvar: globaladdressbookfile
//! A file containing global addressbook addresses. Can be in LDIF, Pine or CSV (Outlook Export, Excel) format. (File in real file  system or empty.)
//!  type: TYPE_STRING
//!  name: File
//

/*
 * If you visit a file that doesn't contain these lines at its end, please
 * cut and paste everything from here to that file.
 */

/*
 * Local Variables:
 * c-basic-offset: 2
 * c-set-style: k&r
 * End:
 *
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
