#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

// ============================================================================
//  SPELLCHECK screen container handler
// ============================================================================
string screen(mapping args, string contents, object id)
{
  string out = "";

  CSESSION->screen = "spellcheck";	// Admin screen name

  if ((CSESSION->checkword < 0) || (CSESSION->checkword >= sizeof (CSESSION->misspelled)))
    CSESSION->checkword = 0;

  contents = CAMAS.Parse.parse_html(contents,
                        ([
                         "camas_spelldone"    : tag_camas_spellcheck_common,
                         "camas_backtocompose": tag_camas_spellcheck_common,
                         ]),
                        ([
                         "camas_noerror"           : container_camas_spellcheck_noerror,
                         "camas_noerrors"          : container_camas_spellcheck_noerror,
                         "camas_error"             : container_camas_spellcheck_error,
                         "camas_errors"            : container_camas_spellcheck_error,
                         ]),
                        id);
  if(!id->misc->_xml_parser)
    if(QUERY(ent_parse))
      contents = parse_scopes(contents,cb_scopes,id);

  args->method = "post";
  args->name = "camasspellcheckform";

  args = CAMAS.Tools.set_target(id, args);
  
  out += CAMAS.Tools.make_container("form", args, contents);

  return out;
}

/* Code for error-independant spellcheck screen tags */
string tag_camas_spellcheck_common(string tag_name, mapping args, object id)
{
  string out = "";

  switch(tag_name)
  {
  case "camas_spelldone":
    //! tag: camas_spelldone
    //!  Button for finishing spellchecking process
    //! note: screen: spellcheck
    out += CAMAS.Tools.formdrawbutton(id,"m_spelldone", "actionspelldone", MSG(M_SPELLDONE), args);
    break;
  case "camas_backtocompose":
    //! tag: camas_backtocompose
    //!  Button to go back to compose screen
    //! note: screen: addressbook, addressbooktoccbcc
    out = CAMAS.Tools.formdrawbutton(id,"m_backtocompose", "actioncontinuecompose", MSG(M_BACKTOCOMPOSE), args);
    break;

  default:
    out = "<!-- "+tag_name+" is not supported yet -->";
    CDEBUG("tag_camas_spellcheck: "+tag_name+" is not supported yet");
  }

  return out;
}

//! container: noerror
//!  Zone for case there is no errors
//! note: screen: spellcheck
string container_camas_spellcheck_noerror(string tag_name, mapping args, string contents, object id)
{
  string out = "";

  if(CSESSION->misspelled && sizeof(CSESSION->misspelled) == 0)
  {
    out += contents;
  }

  return out;
}

//! container: error
//!  Zone for case there is errors in the text
//! childtag : camas_texttospell
//! childtag : camas_spellprevious
//! childtag : camas_spellnext
//! childtag : camas_spellreplacetype
//! childtag : camas_spellreplacetypefield
//! childtag : camas_spellselect
//! childtag : camas_spellselectlist
//! note: screen: spellcheck
string container_camas_spellcheck_error(string tag_name, mapping args, string contents, object id)
{
  string out = "";

  if(!(CSESSION->misspelled && sizeof(CSESSION->misspelled) == 0))
  {
    out +=  CAMAS.Parse.parse_html(contents,
                       ([
                      "camas_texttospell"            : container_camas_spellcheck_error_subtag,
                      "camas_spellprevious"          : container_camas_spellcheck_error_subtag,
                      "camas_spellnext"              : container_camas_spellcheck_error_subtag,
                      "camas_spellreplacetype"       : container_camas_spellcheck_error_subtag,
                      "camas_spellreplacetypefield"  : container_camas_spellcheck_error_subtag,
                      "camas_spellreplaceselect"     : container_camas_spellcheck_error_subtag,
                      "camas_spellreplaceselectlist" : container_camas_spellcheck_error_subtag,
                        ]),
                       ([
                        ]),
                       id);
  }

  return out;
}

/* code for container error subtags */
string container_camas_spellcheck_error_subtag(string tag_name, mapping args, object id)
{
  string out = "";
  string content = "";
	
  switch(tag_name)
  {
  case "camas_texttospell":
    //! tag: camas_texttospell
    //!  Text being spellchecked
		//! attributes: a_*
		//!  All attributes applicable to <a></>
		//! attributes: strong_*
		//!  All attributes applicable to <strong></>
    //! screen: spellcheck
    int i = 0;
    int j = -1;

		mapping a_args = CAMAS.Tools.extract_html_attributes(args, "a");
		mapping strong_args = CAMAS.Tools.extract_html_attributes(args, "strong");
		
    foreach (CSESSION->spelling, mixed foo)
    {
      j++;
      if (arrayp (foo))
      {
        if ((CSESSION->misspelled)[CSESSION->checkword] == j)
        {
					out += CAMAS.Tools.make_container("strong", strong_args, HTML_ENCODE_STRING (foo[1]));
          i++;
        }
        else
        {
					i++;

					mapping hrefargs = 
						([
							"actioncheckword" : "1",
							"word"            : (string)i,
						]);
				
					a_args->href = CAMAS.Tools.make_get_url(id, a_args, hrefargs);
					
	  			out += CAMAS.Tools.make_container("a", a_args, HTML_ENCODE_STRING (foo[1]));
        }
      }
      else
      {
        out += HTML_ENCODE_STRING (foo);
      }
    }

		string brtag = CAMAS.Tools.make_tag("br", ([ ]));

		out = replace (out, "\n", brtag+"\n");

    break;

  case "camas_spellprevious":
    //! tag: camas_spellprevious
    //!  Button for checking previous word
    //! note: screen: spellcheck
    if(sizeof (CSESSION->misspelled))
    {
      if(CSESSION->checkword > 0)
      {
        out += CAMAS.Tools.formdrawbutton(id,"m_spellprev", "actionspellprev", MSG(M_SPELLPREV), args);
      }
    }
    break;

  case "camas_spellnext":
    //! tag: camas_spellnext
    //!  Button for checking next word
    //! note: screen: spellcheck
    if(sizeof (CSESSION->misspelled))
    {
      if(CSESSION->checkword < (sizeof(CSESSION->misspelled) - 1))
      {
        out += CAMAS.Tools.formdrawbutton(id,"m_spellnext", "actionspellnext", MSG(M_SPELLNEXT), args);
      }
    }
    break;

  case "camas_spellreplacetype":
    //! tag: camas_spellchangeto
    //!  Button for changing current word with word typed
    //! note: works with camas_spellreplacetypefield
    //! note: screen: spellcheck
    out += CAMAS.Tools.formdrawbutton(id,"m_spellchangeto", "actionspellreplace", MSG(M_SPELLCHANGETO) + ":", args);
    break;

  case "camas_spellreplacetypefield":
    //! tag: camas_spellreplacefield
    //!  Field for typing a another spell for the current word
    //! note: works with camas_spellreplacetype
    //! note: screen: spellcheck
    args -> name = "newword";
    args -> value= HTML_ENCODE_STRING ((CSESSION->spelling)[(CSESSION->misspelled)[CSESSION->checkword]][1]);
    out += CAMAS.Tools.make_tag("input", args);
    break;

  case "camas_spellreplaceselect":
    //! tag: camas_spellreplaceselect
    //!  Button for changing current word with word selected from list
    //! note: works with camas_spellreplaceselectlist
    //! note: screen: spellcheck
    out += CAMAS.Tools.formdrawbutton(id,"m_spellchangeto", "actionspellselect", MSG(M_SPELLCHANGETO) + ":", args);
    break;

  case "camas_spellreplaceselectlist":
    //! tag: camas_spellreplaceselectlist
    //!  List for choosing an alternate spelling for current word
    //! note: works with camas_replaceselect
    //! note: screen: spellcheck
    int k = 0;

    foreach ((CSESSION->spelling)[(CSESSION->misspelled)[CSESSION->checkword]][2..], string word)
    {
      args -> value = (string)k;
      content += CAMAS.Tools.make_container("option", args, HTML_ENCODE_STRING (word));
      k++;
    }
    args -> name = "selectedword";
    args -> value= HTML_ENCODE_STRING ((CSESSION->spelling)[(CSESSION->misspelled)[CSESSION->checkword]][1]);
    out += CAMAS.Tools.make_container("select", args, content);
    break;

  default:
    out = "<!-- "+tag_name+" is not supported yet -->";
    CDEBUG("tag_camas_spellcheck_error: "+tag_name+" is not supported yet");
  }
  return out;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
