#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

// ============================================================================
//  EDITADDRESS screen container handler
// ============================================================================
string screen(mapping args, string contents, object id)
{
  array addressbooks = id->conf->get_providers("camas_addressbook");
  if(sizeof(addressbooks) == 0)
    return "<!-- You must load at least one addressbook module to have this screen -->";
  string out = "";
  CSESSION->screen = "editaddress";	// Admin screen name
  string|int address = CSESSION->editaddress;
  array(mapping(int:array(string))) contact = ({ ([ ]) });
  if(address)
    contact[0] += ([ AD_MAIL: ({ address }) ]);
  if(CSESSION->editname)
    contact[0] += ([ AD_NAME: ({ CSESSION->editname }) ]);
  // if we have a valid email address to modify
  if(address && CSESSION->editaddressmode == "modify")
  {
    // modify case 
    object addressbook = CAMAS.AddressBook2.get_currentaddrbook(id);
    contact = addressbook->get(([ AD_MAIL: address ]), id);
    contents = CAMAS.Tools.make_tag("input",
    ([ 
       "type" : "hidden", 
       "value": address,
       "name" : "address"
    ])) + contents;
  }

  mapping tags = ([ 
      "camas_saveaddress"       : tag_camas_editaddressbutton,
      "camas_deleteaddress"     : tag_camas_editaddressbutton,
      "camas_canceladdress"     : tag_camas_editaddressbutton ]);

  foreach(indices(ldapattributes2input), string internaltagname)
    tags += ([ "camas_" + lower_case(internaltagname): tag_camas_editaddress ]);
 
  contents = CAMAS.Parse.parse_html(contents,
                         tags,
                        ([
                         ]),
                        id, contact);
  if(CSESSION->editaddressmode == "new")
  {
    // selected address book must hide read only addressbooks in editaddress
    contents = CAMAS.Parse.parse_html(contents,
                          ([ "camas_select_selectaddressbook": tag_camas_select_addressbook,
                           ]), ([ ]), id, 1);
  }
  else if(CSESSION->editaddressmode == "modify")
    contents = CAMAS.Parse.parse_html(contents,
                          ([ "camas_select_selectaddressbook": 
                           lambda() { return 
                           "<!-- tag camas_select_selectaddressbook only available when creating entries -->\n";
                           } ]), ([ ]));

  if(!id->misc->_xml_parser && QUERY(ent_parse))
    contents = parse_scopes(contents,cb_scopes,id);

  args->method = "post";
  args->name = "camaseditaddressform";

  args = CAMAS.Tools.set_target(id, args);

  out += CAMAS.Tools.make_container("form", args, contents);
  out += "<!-- End of screen_EDITADDRESS -->";
  return out;
}

/* code for editaddress value for each contact */
//! tag: camas_cn
//! tag: camas_sn
//! tag: camas_givenName
//! tag: camas_homePhone
//! tag: camas_telephoneNumber
//! tag: camas_title
//! tag: camas_o
//! tag: camas_ou
//! tag: camas_homePostalAddress
//! tag: camas_postalAddress
//! tag: camas_l
//! tag: camas_st
//! tag: camas_c
//! tag: camas_pager
//! tag: camas_mobile
//! tag: camas_labeledURI
//! tag: camas_description
//! tag: camas_seeAlso
//! tag: camas_mail
//! tag: camas_postalCode
string tag_camas_editaddress(string tag_name, mapping args, object id, array(mapping(int:array(string))) contact)
{
  string out = "";
  // is it a valid tag name ?
  int valid_tag = 0;
  string internaltagname;
  int writeable = 0;
  if(CAMAS.AddressBook2.get_currentaddrbook(id)->writeable())
    writeable = 1;

  foreach(indices(ldapattributes2input), internaltagname)
    if(lower_case(tag_name) == "camas_" + lower_case(internaltagname))
    {
      valid_tag = 1;
      break;
    }
  if(valid_tag)
  {
    if(writeable)
    {
      args->name = internaltagname;
      args->type = "text";
      if(contact && contact[0][ldapattributes2input[internaltagname]])
        args->value = contact[0][ldapattributes2input[internaltagname]] * ",";
      out += CAMAS.Tools.make_tag("input", args);
    }
    else
    {
      if(contact && contact[0][ldapattributes2input[internaltagname]])
        out += contact[0][ldapattributes2input[internaltagname]] * ",";
      else
        out += "&nbsp;";
    }
  }
  else
    out += "<!-- The tag '"+tag_name+"' is not available -->\n";
  return out;
}

/* code for most editaddress screen buttons */
string tag_camas_editaddressbutton(string tag_name, mapping args, object id)
{
  string out = "";
  int writeable = 0;
  if(CAMAS.AddressBook2.get_currentaddrbook(id)->writeable())
    writeable = 1;

  switch(tag_name)
  {
  case "camas_saveaddress":
    //! tag: camas_saveadress
    //!  Button for saving the address
    //! note: screen: editaddress
    if(writeable)
      out += CAMAS.Tools.formdrawbutton(id,"m_saveaddress", "actioneditaddressdone2", MSG(M_SAVEADDRESS), args);
    break;

  case "camas_deleteaddress":
    //! tag: camas_deleteaddress
    //!  Button for deleting address
    //! note: screen: editaddress
    if(CSESSION->editaddressmode == "modify" && writeable)
      out += CAMAS.Tools.formdrawbutton(id,"m_deleteaddress", "actiondeleteaddress2", MSG(M_DELETEADDRESS), args);
    break;

  case "camas_canceladdress":
    //! tag: camas_canceledit
    //!  Button for cancelling address edition
    //! note: screen: editaddress
    out += CAMAS.Tools.formdrawbutton(id,"m_canceladdress", "actioncanceleditaddress", MSG(M_CANCELADDRESS), args);
    break;
  }

  return out;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
