/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: CSV.pmod,v 1.4 2004/01/13 11:01:38 vida Exp $
 */

array(string) parse_escapes(array(string) escaped_string, string separator)
{
  for(int i = 0; i + 1 < sizeof(escaped_string); i++)
  {
    // escape char for CSV file is " (ok it's dumb but it's MS power)
    // example of an escaped string: "foo, bar"
    // example of a non escaped string: "foo\",\"bar"
    if(sizeof(escaped_string[i]) > 0 && sizeof(escaped_string[i+1]) > 0 
       && escaped_string[i][0] == '\"' && escaped_string[i+1][-1] == '\"'
       && escaped_string[i][-1] != '\"' && escaped_string[i+1][0] != '\"')
    {
      string s = escaped_string[i..i+1] * separator;
      s = s[1..sizeof(s)-2];
      // we have to remove one element from the array
      if(sizeof(escaped_string) > i + 2)
      {
        if(i > 1)
          escaped_string = escaped_string[0..i-1] 
	    + ({ s }) + escaped_string[i+2..];
	else
	  escaped_string = ({ s }) + escaped_string[i+2..];
      }
      else
      {
        if(i > 1)
	  escaped_string = escaped_string[0..i-1]
	    + ({ s });
	else
	  escaped_string = ({ s });
      }
    }
  }
  return escaped_string;
}

//! file: CSV.pmod
//!   CSV (M$ Outlook export format, Excel, etc...) address book handler for Camas
//! cvs_version: $Id: CSV.pmod,v 1.4 2004/01/13 11:01:38 vida Exp $

//! method: int|array(array(string)) imp(string adds, string separator)
//!  Return the address book from ldif format handler
int|array(array(string)) imp(string adds, string separator)
{
  adds = replace(adds, "\r", "");
  array(string) abook = adds / "\n" - ({ "" });
  array(string) first_fields = abook[0] / separator;
  array(array(string)) result = allocate(sizeof(first_fields), ({ }));

  // first parse one line, be sure to escape characters and so on
  for(int i = 0; i < sizeof(abook); i++)
  {
    array(string) fields = abook[i] / separator;
    fields = parse_escapes(fields, separator);
    fields = map(fields, lambda(string field)
      {
        return replace(field, "\"\"", "\"");
      });
    if(sizeof(fields) != sizeof(first_fields))
    {
      werror("Number of fields in the first line of the CVS file "
      "is not equal to the number of fields in the line %s\n%O\n", abook[i], fields);
      // remove the offending line
      continue;
    }
    // now build the result array
    for(int j = 0; j < sizeof(first_fields); j++)
    {
      result[j] += ({ fields[j] });
    }
  }
  return result;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

