/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: module.pmod,v 1.10 2004/01/13 11:01:38 vida Exp $
 */

//! file: module.pmod
//!   Adressbook handler
//! cvs_version: $Id: module.pmod,v 1.10 2004/01/13 11:01:38 vida Exp $

//! method: string impabook(string file)
//!  Returns address book from "magic" filters
//! returns:
//!  Addressbook in a string in the following format : "name:email\nname:email"
string impabook(string file) {
  string adds = replace(file, "\r", "");
  array (string) lines = adds / "\n";
  if (sizeof(lines) > 0) {
    string name="", address="";
    if (sscanf(lines[0], "%s\t%s", name, address) == 2)
      return master ()->resolve ("CAMAS.AddressBook.Pine")->imp(adds);
    if (sscanf(lines[0], "dn: %s", address) == 1)
      return master ()->resolve ("CAMAS.AddressBook.LDIF")->imp(adds);
    if (sscanf(lines[0], "%s;%s;%*s",name, address) >=2)
      return master ()->resolve ("CAMAS.AddressBook.CSV")->imp(lines - ({ "" }));
  }
  return "";	// Unknown format :)
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

