
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>

#include "brightoninternals.h"

brightonDisplay *dlist = 0;

void *
brightonInterface(brightonApp *app)
{
	brightonDisplay *display;

	/*
	 * Connect to the display.
	 */
	if ((display = brightonOpenDisplay(NULL)) == 0)
		return(0);

	/*
	 * Link it into our list.
	 */
	display->next = dlist;
	if (dlist)
		dlist->last = display;
	dlist = display;

	/*
	 * Request a new toplevel window for this app.
	 */
	if (display->bwin = (struct brightonWindow *) brightonCreateWindow(display,
		app,
		BRIGHTON_CMAP_SIZE,
		BRIGHTON_DEFAULT_ICON))
	{
		int i;

		if (app->init)
			app->init(display->bwin);

		((brightonWindow *) display->bwin)->display = display;

		/*
		 * Map its panels and devices. Devices can be menus as well.
		brightonBuildWindow(display->bwin, app);
		 */
		brightonCreateInterface((brightonWindow *) display->bwin, app);
printf("done create interface: %x, %x\n", display, display->bwin);

		//brightonEventLoop(&dlist);

		return((void *) display->bwin);
	}

	return(0);
}

brightonEventMgr()
{
	brightonEventLoop(&dlist);
}

brightonRemoveInterface(brightonWindow *bwin)
{
	brightonDisplay *d;

printf("brightonRemoveInterface(%x)\n", bwin);

	if ((d = brightonFindDisplay(dlist, (brightonDisplay *) bwin->display))
		== 0)
		return;

	if (bwin->template->destroy != 0)
		bwin->template->destroy(bwin);

	brightonDestroyInterface(bwin);

	/*
	 * Unlink the display
	 */
	if (d->next)
		d->next->last = d->last;

	if (d->last)
		d->last->next = d->next;
	else
		dlist = d->next;

	if (dlist == 0)
	{
		brightonDestroyWindow(bwin);
		cleanout(bwin);
	}

	/*
	 * Remove window and its contents.
	 */
	brightonDestroyWindow(bwin);
}

