
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include "brightoninternals.h"
#include <brightonX11.h>

brightonDisplay *
brightonOpenDisplay(char *displayname)
{
	brightonDisplay *display, *available = NULL;

	/*
	 * This should be moved to a more generic init() procedure, it is not 
	 * required for each display connection, but at the same time we will
	 * probably only connect to one anyway.
	 */
	initSqrtTab();

	display = (brightonDisplay *) brightonmalloc(sizeof(brightonDisplay));

	if (displayname == NULL)
		if ((displayname = getenv("DISPLAY")) == NULL)
			displayname = BRIGHTON_DEFAULT_DISPLAY;

	sprintf(&display->name[0], displayname);

	if ((display->display = BOpenDisplay(display, displayname)) == NULL)
	{
		printf("brightonOpenDisplay(): cannot open %s\n", displayname);
		brightonfree(display);
		return(0);
	}

	return(display);
}

brightonDisplay *
brightonFindDisplay(brightonDisplay *dlist, brightonDisplay *display)
{
	if (dlist == 0)
		return(0);

	if (dlist == display)
		return(display);

	return(brightonFindDisplay(dlist->next, display));
}

int
brightonCloseDisplay(brightonDisplay *display)
{
	brightonDisplay *d;

	BCloseDisplay(display->display);

	brightonfree(display);

	return(0);
}

