#ifndef _TIMEBAR_H_
#define _TIMEBAR_H_

#include <qlabel.h>

class Part;

/**
 * This class draws the timebar at the top of the PartCanvas
 * @author Jan Wuerthner
 * @version 0.95
 */

class TimeBar : public QLabel
{
  Q_OBJECT

private:
  // QtPartCanvas * pcanvas;
  Part * master;
  int met0;
  int met1;
  int _xpos;
  int _xpos2;
  long _xticks;
  long _xticks2;
  long _old_xticks;
  long _old_xticks2;
  int _offset;
  long _cursorpos;
  double _pixpertick;

public:
  TimeBar( QWidget *parent=0, const char *name=0);

  // QtPartCanvas * gPartCanvas();

  // double gBarLength();
  int canvasMarginLeft;
  int canvasMarginRight;
  void setOffset( int );
  void setCursorPosition( long );
  void setPixPerTick( double );

public slots:
  void paintEvent( QPaintEvent * pe );
  void mousePressEvent( QMouseEvent * me );
  void mouseMoveEvent( QMouseEvent * me );
  void mouseReleaseEvent( QMouseEvent * me );
};


#endif
