#ifndef _QTSCOREADDONS_H_
#define _QTSCOREADDONS_H_

#include <qpen.h>

#include "element.h"
#include "note.h"
#include "position.h"

class QPainter;
class QPixmap;
class QtScore;
class ofstream;

#define Atom Element

class MupPhrase
{
  Position start;
  Position end;
  MupPhrase * next;
  Part * master;
  int met0;
  int met1;
  char * help;

 public:
  MupPhrase(Position,int,Part*,int,int);
  ~MupPhrase();
  char * Range();
  MupPhrase * Next();
  void append(MupPhrase*);
};

class MupLyrics
{
  int cli;
  int dot;
  MupLyrics * next;
  char * lyrics;
  char * help;

 public:
  MupLyrics(int,int,const char*);
  ~MupLyrics();
  char * text();
  char * lengths();
  MupLyrics * Next();
  void append(MupLyrics*);
};

class NotePtr
{
 private:
  Note * note;
  NotePtr * next;
  void append(NotePtr*);

 public:
  NotePtr(Note*);
  Note * gNote();
  NotePtr * Next();
  NotePtr * insert(Note*);
};

class NoteChord
{
private:
  NotePtr * top;
  NoteChord * next;
  NotePtr * Bottom();
  Position off;
  int _xPos;
  int _stemPos;
  int _stemDir;
  int _yBottom;
  int _yTop;
  bool _middle;
  static int xx;
  static int xxShift;
  static int yy;
  static int yyOld;

 public:
  NoteChord(Note*,Position);
  ~NoteChord();
  NoteChord * append(Note*);
  Position gOffset();
  int center();
  int len();
  int xPos();
  int stemPos(int stemDir=0);
  int stemDir();
  int stemUp();
  int stemDown();
  int yBottom();
  int yTop();
  Position Pos();
  int maxFreq();
  int minFreq();
  NoteChord * Next();
  void sNext(NoteChord*);
  void print();
  void draw(QPainter*,Position,double,int,int,int,Atom*,Position,Position,bool,bool);
  int DOT(int);
  void tex(Position,int);
  void mup(Position,int,ofstream*,Part*,int,int);
  void specifyAtts(int,ofstream*);
};


class QtScoreGroup
{
 protected:
  QtScoreGroup * next;
  
 public:
  QtScoreGroup();
  virtual ~QtScoreGroup();
  virtual Position start() = 0;
  virtual Position end() = 0;
  virtual Position gOffset() = 0;
  virtual QtScoreGroup * append(Note*,Position,Part*,int,int) = 0;
  virtual QtScoreGroup * Next() = 0;
  virtual void sNext(QtScoreGroup*) = 0;
  virtual void print() = 0;
  virtual void draw(QPainter*,Position,double,int,int,int,Part*,int,int,Atom*,Position,Position,bool,bool) = 0;
  virtual void tex(Position,int,Part*,int,int) = 0;
  virtual void mup(Position,int,Part*,int,int,ofstream*) = 0;
};


class NoteGroup : public QtScoreGroup
{
 private:
  NoteChord * first;
  NoteChord * last();
  void append(NoteChord*);
  
 public:
  NoteGroup(NoteChord* ch, NoteGroup * gr=0);
  NoteGroup(Note*,Position);
  int center();
  int number();
  virtual ~NoteGroup();
  virtual Position start();
  virtual Position end();
  virtual Position gOffset();
  virtual QtScoreGroup * append(Note*,Position,Part*,int,int);
  virtual QtScoreGroup * Next();
  virtual void sNext(QtScoreGroup*);
  virtual void print();
  virtual void draw(QPainter*,Position,double,int,int,int,Part*,int,int,Atom*,Position,Position,bool,bool);
  virtual void tex(Position,int,Part*,int,int);
  virtual void mup(Position,int,Part*,int,int,ofstream*);
};




class BreakGroup : public QtScoreGroup
{
 private:
  Position pos;
  int length;
  Position off;
  void drawBreak(int,Position,int,QPainter*,int,int,double);
  void texBreak(int,Position,int,int,Part*,int,int);
  void mupBreak(int,Position,int,int,Part*,int,int,ofstream*);

 public:
  BreakGroup(Position,int,Position);
  virtual ~BreakGroup();
  virtual Position start();
  virtual Position end();
  virtual Position gOffset();
  virtual QtScoreGroup * append(Note*,Position,Part*,int,int);
  virtual QtScoreGroup * Next();
  virtual void sNext(QtScoreGroup*);
  virtual void print();
  virtual void draw(QPainter*,Position,double,int,int,int,Part*,int,int,Atom*,Position,Position,bool,bool);
  virtual void tex(Position,int,Part*,int,int);
  virtual void mup(Position,int,Part*,int,int,ofstream*);
};


// for MusicTex / MUP print features:

class NoteBar
{
  QtScoreGroup * top;
  NoteBar * next;
  
 public:
  NoteBar(QtScoreGroup*);
  void sNext(NoteBar*);
  NoteBar * Next();
  Position start();
  void fill(Part*,int,int);
  NoteBar * append(QtScoreGroup*,Part*,int,int);
  void tex(Position,int,Part*,int,int);
  void mup(Position,int,Part*,int,int,ofstream*,int);
  void print(Part*,int,int);
};

#endif
