#include <string.h>
#include "dns.h"

int dns_dots_to_name(const char* dots, str* name)
{
  const char* start;
  while (*dots != 0) {
    while (*dots == '.') ++ dots;
    start = dots;
    while (*dots != 0 && *dots != '.') ++dots;
    if (dots > start) {
      unsigned len = dots - start;
      if (len > DNS_MAX_LABEL) return -1;
      if (!str_catc(name, (uint8)len)) return 0;
      if (!str_catb(name, start, len)) return 0;
    }
  }
  return str_catc(name, 0);
}

int dns_name_to_dots(const uint8* name, unsigned namelen, str* dots)
{
  const uint8* end;
  unsigned len;
  int add_dot;
  len = -1;
  end = name + namelen;
  add_dot = 0;
  while (name < end && (len = *name++) != 0) {
    if (len > DNS_MAX_LABEL || name + len >= end) return -1;
    if (add_dot) if (!str_catc(dots, '.')) return 0;
    if (dots->len + len > DNS_MAX_NAME) return -1;
    if (!str_catb(dots, name, len)) return 0;
    name += len;
    add_dot = 1;
  }
  return (len == 0) ? 1 : -1;
}

int dns_uncompress_name(const uint8* name, unsigned namelen,
			const str* packet, str* out)
{
  const uint8* end;
  unsigned len;
  end = name + namelen;
  len = -1;
  while (name < end && (len = *name++) != 0) {
    if (len >= 0xc0) {
      uint16 ptr;
      if (name >= end) return -1;
      /* Compressed pointer */
      ptr = ((len & 0x3f) << 8) + *name++;
      /* Check for pointer past end of packet */
      if (ptr >= packet->len) return -1;
      /* Check for illegal forward pointer */
      if (name >= (uint8*)packet->s && name < (uint8*)packet->s+packet->len)
	if ((uint8*)packet->s+ptr >= name-2) return -1;
      return dns_uncompress_name(packet->s+ptr, packet->len-ptr, packet, out);
    }
    if (len > DNS_MAX_LABEL || name + len >= end) return -1;
    if (!str_catb(out, name-1, len+1)) return 0;
    name += len;
  }
  if (len != 0) return -1;
  return str_catc(out, 0);
}
