# Copyright (C) 1999, 2000 Jay Beale
# Copyright (C) 2002 Hewlett Packard Company
# Licensed under the GNU General Public License

package Bastille::FTP;
use lib "/usr/lib";

use Bastille::API;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";




#######################################################################
##                                  FTP                              ##
#######################################################################

#&ConfigureProFTP;
&LimitFTPbyUserType;
&RestrictUserLogin;

sub ConfigureProFTP {
   #&ActionLog("# sub ConfigureProFTP\n");
   # Let's offer the option to install ProFTP here.  Either way, we'll
   # still tighten wu-ftpd, as so many people use it.
}


sub LimitFTPbyUserType {

    if ((&getGlobalConfig("FTP","anonftp") eq "Y") or (&getGlobalConfig("FTP","userftp") eq "Y")) {
	&ActionLog("# sub LimitFTPbyUserType\n");

	# Are we using WU-FTPd?
	if ( -e '/etc/ftpaccess') {

	    # Optionally disable user and/or anonymous ftp
	    
	    # Construct the class line, based on what is disabled...  
	    # note: based on our tests, it is completely safe to have a line which lists no classes: no logins wil be allowed
	    #       in that case, which is what we want...
	    
	    my $class_line="class   all   ";
	    
	    unless (&getGlobalConfig("FTP","userftp") eq "Y") {
		$class_line .= "real,guest";
		unless (&getGlobalConfig("FTP","anonftp") eq "Y") {
		    $class_line .= ",";
		}
	    }
	    unless (&getGlobalConfig("FTP","anonftp") eq "Y") {
		$class_line .= "anonymous";
	    }
	    $class_line .= "   *\n";
	    
	    # put the line in place...
	    
	    &B_replace_line ("/etc/ftpaccess",'^\s*class',$class_line);
	}

	# vsftpd has been a common option on RH7.x.  It's the default in RH8.0

	if ( -e '/etc/vsftpd.conf' ) {
	    if (getGlobalConfig("FTP","anonftp") eq "N") {
		&B_replace_line ('/etc/vsftpd.conf','^anonymous_enable\s*=','anonymous_enable=NO\n');
		&B_append_line('/etc/vsftpd.conf','^anonymous_enable\s*=\s*NO','anonymous_enable=NO\n');
	    }
	    if (getGlobalConfig("FTP","userftp") eq "N") {
		&B_replace_line ('/etc/vsftpd.conf','^local_enable\s*=','local_enable=NO\n');
		&B_append_line('/etc/vsftpd.conf','^local_enable\s*=\s*NO','local_enable=NO\n');
	    }
	}
   }
}

sub RestrictUserLogin {
    if ( (&getGlobalConfig("FTP","ftpusers") eq "Y") ) {
	&ActionLog("# sub RestrictUserLogin\n");
	# List of users to be disallowed ftp login
	my @restrictedUser = ("root","daemon","bin","sys","adm","uucp","lp","nuucp","hpdb","guest");

	foreach my $user (@restrictedUser) {
	    # append login unless it is already present inside of the file
	    if(! -e &getGlobal('FILE',"ftpusers")){
		&B_create_file(&getGlobal('FILE',"ftpusers"));
	    }
	    &B_append_line(&getGlobal('FILE',"ftpusers"),"^\\s*$user\\s*"  . '$',"$user\n");
	}
    }
}
1;
