<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    setup-system.php                                        */
/* Author:      Paul Waite                                              */
/* Description: Maintenance page for system configuration.              */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");

// -----------------------------------------------------------------------
$HEADING = "System Setup";

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page($HEADING, "maint", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("form-defs.php");
include_once("button-defs.php");

// -----------------------------------------------------------------------
// AUTHORISATION
// Must have authorisation code of valid admin user by now..
$AUTH_CODE_HIDDEN = "<input type=hidden name=auth_code value='$auth_code'>";


// No guests allowed to see content..
if (!$RESPONSE->ismemberof_group("Admin")) {
  $RESPONSE->send();
  exit;
}

// -----------------------------------------------------------------------
// INITIALISE VARS
if (!isset($mode)) $mode = "edit";  // Determines the action(s) we take

// -----------------------------------------------------------------------
// MAIN CONTENT

//debug_on(DBG_DUMP|DBG_SQL|DBG_DIAGNOSTIC);
//debug_on(DBG_ALL);

// #######################################################################
// FORM ELEMENTS

// Put in some javascript to prevent accidental deletes..
$RESPONSE->body->add_script(
    "function delWarn() {\n"
  . " var msg = \"WARNING:\\n\\n\";\n"
  . " msg+=\"Do you really want to delete this element?\\n\\n\";\n"
  . " var rc = confirm(msg);\n"
  . " if (rc) {\n"
  . "   document.forms.main_fm.mode.value='remove';\n"
  . "   document.forms.main_fm.submit();\n"
  . " }\n"
  . " else alert(\"Data lives to fight another day.\");\n"
  . "}\n"
);

// -----------------------------------------------------------------------
// SYSTEM SETUP DETAILS

$msgs = array();
$s = "";

// Instantiate the configuration..
$sysconfig = new configurator("sys_control");
$s .= "<tr><td align=center valign=top>" . $sysconfig->render() . "</td></tr>\n";

// Deal with Lucene indexing if available..
if ( isset($CONTEXT) && $CONTEXT->configvalue("Lucene Site Indexing") ) {
  // Bulk indexer button..
  $bix = new image_button("goindex", "", "", "", "$LIBDIR/img/_go.gif", 42, 15, "Index all site content");
  $T = new table();
  $T->setwidth("65%");
  $T->td( "Lucene Indexing is enabled for this site, and Managed Content also exists. "
        . "To re-index all content on the site, click the button below.."
        );
  $T->td_alignment("center");
  $T->tr();
  $T->td( $bix->render() );
  $T->td_alignment("center");
  $s .= "<tr><td><hr noshade></td></tr>\n";
  $s .= "<tr><td align=center valign=top>" . $T->render() . "</td></tr>\n";

  if (isset($goindex_x)) {

    // If they clicked the button, then re-index here. We only index site pages
    // which are flagged as being content managed. For these pages we retrieve
    // the disk content, and extract the layout ID. From there we make a layout
    // object and index it, which indexes all blocks in that layout. This is
    // really only an infrequent option, and mostly site pages will be indexed
    // as they are individually modified.

    include_once("layout-defs.php");
    include_once("catalog-defs.php");
    include_once("lucene-defs.php");

    // Check if any content management blocks exist..
    $chk = dbrecordset("SELECT COUNT(*) FROM ax_block");
    if ($chk->rowcount > 0) {

      // This is also the place where we re-affirm the layout<->sitepage
      // linkages. We refresh all of these here, before indexing..
      $sitepages = dbrecordset("SELECT * FROM ax_sitepage");
      if ($sitepages->hasdata) {
        do {
          $page_id = $sitepages->field("page_id");
          $path    = $RESPONSE->site_docroot . $sitepages->field("page_path");
          $page    = new inputfile($path);
          if ($page->opened) {
            $content = $page->readall();
            $page->closefile();
            if (stristr($content, "layoutid") || stristr($content, "layout_id")) {
              $matches = array();
              // Literal layout name/ID embedded in the page..
              $litpatt = '/<!--layoutid=\\\\"([^$]+)\\\\"-->/i';
              preg_match_all($litpatt, $content, $matches);
              if (count($matches[0]) == 0) {
                // CM created page with layout name/ID variable..
                $varpatt = '/LAYOUT_ID  = \"(.+)\";/i';
                preg_match_all($varpatt, $content, $matches);
              }
              for ($i=0; $i< count($matches[0]); $i++) {
                $layouttag = $matches[0][$i];
                $layoutname = $matches[1][$i];
                $LSq  = "SELECT * FROM ax_layout_set";
                $LSq .= " WHERE layout_name='". addslashes($layoutname) . "'";
                $LS = dbrecordset($LSq);
                if ($LS->hasdata) {
                  $pgid = $LS->field("page_id");
                  // Fix up erroneous page reference..
                  if ($pgid != $page_id) {
                    $LSup = new dbupdate("ax_layout_set");
                    $LSup->set("page_id", $page_id);
                    $LSup->where("layout_name='" . addslashes($layoutname) . "'");
                    $LSup->execute();
                  }
                }
                else {
                  // Create absent layout set linkage..
                  $LSin = new dbinsert("ax_layout_set");
                  $LSin->set("page_id", $page_id);
                  $LSin->set("layout_name", $layoutname);
                  $LSin->execute();
                }
              }
            }
          }
        } while ($sitepages->get_next());
      }

      // INDEX ALL NAMED LAYOUTS..
      $q  = "SELECT *";
      $q .= "  FROM ax_layout_set ls, ax_sitepage pg";
      $q .= " WHERE pg.page_id=ls.page_id";
      $layouts = dbrecordset($q);
      $totix = 0;
      if ($layouts->hasdata) {
        do {
          $layoutname = $layouts->field("layout_name");
          $enabled    = $layouts->istrue("enabled");
          $managed    = $layouts->istrue("managed");
          $mylayout = new named_layout($layoutname, VERSION_LIVE);
          if ($enabled && $managed) {
            $mylayout->index();
            $totix += 1;
          }
          else {
            $mylayout->unindex();
          }
        } while ($layouts->get_next());
        $msgs[] = "$totix layouts were indexed.";
      }
    }
    // INDEX ALL CATALOG ITEMS..
    $cats = dbrecordset("SELECT * FROM ax_catalog");
    if ($cats->hasdata) {
      do {
        $catid = $cats->field("cat_id");
        $cat = new catalogitem($catid);
        $cat->index();
      } while($cats->get_next());
      $msgs[] = "$cats->rowcount catalog items were indexed.";
    }
  }
}
// Append any messages..
if (count($msgs) > 0) {
  foreach ($msgs as $msg) {
    $s .= "<tr><td align=center valign=top><span style=\"color:red\">$msg</span></td></tr>\n";
  }
}
// Assign content..
$SYS_DETAILS = $s;

// -----------------------------------------------------------------------
// ERROR MESSAGES
// Messages added to the errmsgs[] array above..
$s = "";
if (isset($errmsgs)) {
  foreach ($errmsgs as $errmsg) {
    $s .= "$errmsg<br>";
  }
}
$ERROR_MSG = $s;

// -----------------------------------------------------------------------
// mode field
$mod = new form_hiddenfield("mode", "$mode");
$MODE_HIDDEN = $mod->render();

// #######################################################################
// CONTENT HTML LAYOUT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
  <form class="axform" name="mainfm" method="post">
  <!--AUTH_CODE_HIDDEN-->
  <!--MODE_HIDDEN-->
  <table border=0 cellspacing=3 cellpadding=0 width="100%" align=center>
    <tr class="axtitle">
      <td colspan=2 align="center" class="axtitle"><!--HEADING--></td>
    </tr>
    <tr>
      <td align=center colspan=2 class=error><!--ERROR_MSG--></td>
    </tr>
    <tr>
      <td valign=top colspan=2><!--SYS_DETAILS--></td>
    </tr>
  </table>
  </form>
<?php
$RESPONSE->plugin_inline();

// #######################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..
$RESPONSE->plugin("AUTH_CODE_HIDDEN", $AUTH_CODE_HIDDEN);
$RESPONSE->plugin("MODE_HIDDEN",      $MODE_HIDDEN);
$RESPONSE->plugin("HEADING",          $HEADING);
$RESPONSE->plugin("ERROR_MSG",        $ERROR_MSG);
$RESPONSE->plugin("SYS_DETAILS",      $SYS_DETAILS);

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>