#!/bin/bash

# Install debian package in repository..

PACKAGE=`head -n 1 debian/control | cut -f2 -d' '`
PACKAGE_DOC=${PACKAGE}-doc
ALL_PACKAGES="$PACKAGE $PACKAGE_DOC"
USER=${1:-"`grep -e \"Maintainer:\" debian/control|cut -d\":\" -f2`"}
VERSION=`head -n 1 debian/changelog | cut -f2 -d\( | cut -f1 -d')' | cut -f1 -d-`

# Ensure we have a repository..
REPOSITORY="../debian-repository"
if [ ! -d "$REPOSITORY" ]
then
  mkdir $REPOSITORY
fi
cd $REPOSITORY

for PKG in $ALL_PACKAGES
do
  FILECNT=`ls ${PKG}_* | wc -l`
  if [ $FILECNT -gt 0 ]
  then
    echo "removing old $PKG files.."
    rm ./${PKG}_*
  fi
  echo "installing new $PKG files.."
  cp ../debian-builds/${PACKAGE}/${PKG}_${VERSION}* .
done

if [ -f override ]
then
  echo "using override file provided"
  OVERRIDE_FILE=override
else
  echo "no override file present"
  OVERRIDE_FILE=/dev/null
fi

echo "packaging sources ${ALL_PACKAGES}.."
dpkg-scansources . $OVERRIDE_FILE | gzip -9c > Sources.gz
echo "done."

echo "packaging binaries ${ALL_PACKAGES}.."
dpkg-scanpackages . $OVERRIDE_FILE | gzip -9c > Packages.gz
echo "done."

# ENDS
