dnl Available from the GNU Autoconf Macro Archive at:
dnl http://www.gnu.org/software/ac-archive/htmldoc/ax_boost_signals.html
dnl
AC_DEFUN([AX_BOOST_SIGNALS],
[AC_REQUIRE([AC_CXX_NAMESPACES])dnl
AC_CACHE_CHECK(whether the Boost::Signal library is available,
ax_cv_boost_signal,
[AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 AC_COMPILE_IFELSE(AC_LANG_PROGRAM([[#include <boost/signal.hpp>]],
			   [[boost::signal<void ()> sig; return 0;]]),
  			   ax_cv_boost_signal=yes, ax_cv_boost_signal=no)
 AC_LANG_RESTORE
])
if test "$ax_cv_boost_signal" = yes; then
  AC_DEFINE(HAVE_BOOST_SIGNALS,,[define if the Boost::Signal library is available])
fi
  dnl Now determine the appropriate file names
  AC_ARG_WITH([boost-signals],AS_HELP_STRING([--with-boost-signals],
  [specify the boost signals library or suffix to use]),
  [if test "x$with_boost_signals" != "xno"; then
    ax_signals_lib=$with_boost_signals
    ax_boost_signals_lib=boost_signals-$with_boost_signals
  fi])
  for ax_lib in $ax_signals_lib $ax_boost_signals_lib boost_signals; do
    AC_CHECK_LIB($ax_lib, main, [BOOST_SIGNALS_LIB=$ax_lib break])
  done
  AC_SUBST(BOOST_SIGNALS_LIB)
])dnl
