/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*================================================*/
/*	Configuration dialog
 *
 *	by Tony Sideris	(06:45PM Apr 28, 2002)
 *================================================*/
#include "arson.h"

#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qfontmetrics.h>
#include <qpainter.h>
#include <qstyle.h>
#include <qvbox.h>

#include <kiconloader.h>
#include <kstddirs.h>
#include <klocale.h>

#include "programpage.h"
#include "optionpage.h"
#include "ripperpage.h"
#include "devicepage.h"
#include "isopage.h"
#include "burnerpage.h"
#include "pathpage.h"

/*========================================================*/

ArsonConfigDlg::ArsonConfigDlg (ArsonConfig &cfg, int page, QWidget *parent)
	: KDialogBase(IconList,
		i18n("arson Configuration"),
		Ok | Apply | Cancel,
		Ok), m_cfg(cfg)
{
	enableButtonSeparator(true);
	createPages();

	if (page > 0 && page < COUNT)
		showPage(page);
}

/*========================================================*/

void ArsonConfigDlg::configure_devices (void)
{
	showPage(DEVICE);
}

/*========================================================*/

void ArsonConfigDlg::adjustSize (void)
{
	int paranoid;

	for (paranoid = 1200; paranoid > 0; --paranoid)
	{
		const QSize was = minimumSizeHint();

		resize(was.width(), was.height() - 2);

		if (was == size())
			break;
	}

	Trace("paranoid == %d\n", paranoid);
}

/*========================================================*/

QPixmap loadIcon (const char *name)
{
	return KGlobal::iconLoader()->loadIcon(
		name, KIcon::Desktop, KIcon::SizeMedium);
}

void ArsonConfigDlg::createPages (void)
{
	QWidget *pages[] = {
		new ArsonBurnerPage(m_cfg, this,
			addVBoxPage(
				i18n("Burner"), i18n("CD burner configuration"),
				loadIcon("cdwriter_unmount"))),

		new ArsonOptionPage(m_cfg, this,
			addVBoxPage(
				i18n("General"), i18n("Various program options"),
				loadIcon("configure"))),

		new ArsonRipperPage(m_cfg, this,
			addVBoxPage(
				i18n("Ripper"), i18n("CD ripper configuration"),
				loadIcon("cdaudio_unmount"))),

		new ArsonDevicePage(m_cfg, this,
			addVBoxPage(
				i18n("Devices"), i18n("Device configuration"),
				loadIcon("hdd_unmount"))),

		new ArsonPathPage(m_cfg, this,
			addVBoxPage(
				i18n("Paths"), i18n("Configure paths to worker programs, and configuration."),
				loadIcon("folder_open"))),

		new ArsonProgramPage(m_cfg, this,
			addVBoxPage(
				i18n("Programs"), i18n("Worker program selection"),
				loadIcon("run"))),

		new ArsonIsoPage(m_cfg, this,
			addVBoxPage(
				i18n("ISO Settings"), i18n("Configure ISO filesystem presets"),
				loadIcon("binary"))),
	};

	for (int index = 0; index < ARRSIZE(pages); ++index)
	{
		QObject::connect(this, SIGNAL(applyClicked()),
			pages[index], SLOT(on_accept()));

		QObject::connect(this, SIGNAL(okClicked()),
			pages[index], SLOT(on_accept()));
	}

	QObject::connect(pages[DEVICE],
		SIGNAL(devsChanged(const ArsonDeviceList &)),
		pages[BURNER],
		SLOT(on_dev_changed(const ArsonDeviceList &)));

	QObject::connect(pages[DEVICE],
		SIGNAL(devsChanged(const ArsonDeviceList &)),
		pages[RIPPER],
		SLOT(on_dev_changed(const ArsonDeviceList &)));
}

/*========================================================*/
