/* $Id: ArkString.h,v 1.19 2002/10/11 20:36:31 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_STRING_H
#define ARK_STRING_H

#include <string>

#include <Ark/ArkTypes.h>

namespace Ark
{
    typedef std::string String;

    /** Put quotes around this string, and escapes linefeeds, carriage
     * returns, quotes, etc.
     */
    extern ARK_DLL_API String  QuoteString (const String&);

    /** Remove quotes from this string (if there are some) and replace \\n
     * by a linefeed, \\t by a tab, etc.
     */
    extern ARK_DLL_API String  UnquoteString (const String&);

    /** Try to convert this string to a scalar (float).
     * \return true if the conversion is successful
     */
    extern ARK_DLL_API bool  StringToScalar(const String&, scalar&);

    /** Try to convert this string to an integer
     * \return true if the conversion is successful
     */
    extern ARK_DLL_API bool  StringToInt(const String&, int&);


    /** Replace the "." referring to the current working dir (cwd) if
     * it exists in the file name (fname) by the directory part of the
     * reference file name (reffname)
     */
    extern ARK_DLL_API String  ReplaceCwd (const String &fname, const String &reffname);

    /** Get the basename of a filename (ie the filename without the directory
     * nor the extension).
     */
    extern ARK_DLL_API String  Basename (const String &path);

    /** Get the extension part of a filename. */
    extern ARK_DLL_API String  Extension (const String &path);

    /** Get the directory part of a filename. */
    extern ARK_DLL_API String  Dirname (const String & path);
}


#endif
