/* $Id: ArkInvSqrt.cpp,v 1.5 2003/03/12 00:51:58 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// === FAST INVERSE SQUARE ROOT  ===
// From "Graphics Gems V", Alan Paeth (Editor)
// ISBN 0125434553/9649-1547332-306386
// Published by Ap Profession, 1995

#include "config.h"
#include <Ark/ArkMath.h>
#include <math.h>

namespace Ark
{

enum
{
  /* Specified parameters */
  LOOKUP_BITS = 6,                     /* Number of mantissa bits for
                                       ** lookup */
  EXP_POS     = 23,                    /* Position of the exponent */
  EXP_BIAS    = 127,                   /* Bias of exponent */
                                       /* The mantissa is assumed to be
                                       ** just down from the exponent */

  /* Derived parameters */
  LOOKUP_POS  = (EXP_POS-LOOKUP_BITS), /* Position of mantissa lookup */
  SEED_POS    = (EXP_POS-8),           /* Position of mantissa seed   */
  TABLE_SIZE  = (2 << LOOKUP_BITS),    /* Number of entries in table  */
  LOOKUP_MASK = (TABLE_SIZE - 1),      /* Mask for table input        */
};

static inline int GetExp (int a)
{
  return (((a) >> EXP_POS) & 0xFF);
}

/* Extract exponent */
#define GetExp(a)\
  (((a) >> EXP_POS) & 0xFF)

/* Set exponent */
#define SetExp(a)\
  ((a) << EXP_POS)

/* Extended mantissa  MSB's */
#define GetEMant(a)\
    (((a) >> LOOKUP_POS) & LOOKUP_MASK)

/* Set mantissa 8 MSB's */
#define SetMantSeed(a)\
    (((unsigned long)(a)) << SEED_POS)

static unsigned char iSqrt[TABLE_SIZE];

union _flint
{
  unsigned long    i;
  float            f;
};

void
Math::MakeInvSqrtTable ()
{
  register long f;
  register unsigned char *h;
  union _flint fi, fo;

  h = iSqrt;
  for (f = 0, h = iSqrt; f < TABLE_SIZE; f++)
  {
    fi.i = ((EXP_BIAS-1) << EXP_POS) | (f << LOOKUP_POS);
    fo.f = (float) (1.0 / sqrt(fi.f));

    /* Rounding */
    *h++ = (unsigned char)
           (((fo.i + (1<<(SEED_POS-2))) >> SEED_POS) & 0xFF);
  }

  iSqrt[TABLE_SIZE / 2] = 0xFF;    /* Special case for 1.0 */
}

// Compute the Inverse Square Root
// of an IEEE Single Precision Floating-Point number.
// Written by Ken Turkowski.
scalar FASTCALL
Math::InvSqrt (scalar x)
{
  union _flint seed;

  unsigned long a = ((union _flint*)(&x))->i;
  scalar arg = x;
  scalar r;

  seed.i = SetExp (((3*EXP_BIAS-1) - GetExp(a)) >> 1)
         | SetMantSeed (iSqrt[GetEMant (a)]);

  /* Seed: accurate to LOOKUP_BITS */
  r = seed.f;

  /* First iteration: accurate to 2*LOOKUP_BITS */
  r = (float) ((3.0 - r * r * arg) * r * 0.5);

#if 0  /* Wow!  We don't need this much precision! */
  /* Second iteration: accurate to 4*LOOKUP_BITS */
  r = (float) ((3.0 - r * r * arg) * r * 0.5);
#endif

  return r;
}

}

