Petit guide pour l'installation d'amavis-stats sur FreeBSD
----------------------------------------------------
(c) Loic Pefferkorn (pef) <loic AT dev DOT erodia DOT net>

Le document original est disponible ici : http://www.erodia.net/doc/

Ce guide comporte les informations suivantes :

1.Introduction
1.1 A propos du guide
1.2 Qu'est-ce que amavis-stats ?
1.3 Elments requis
2.Installation
2.1 Tlcharger les sources et les installer
2.2 Configurer Apache
2.3 Mettre les droits adquats
2.4 Crer l'utilisateur amavis
2.5 Modifier les fichiers
3.Etapes finales
3.1 Test de l'installation
3.2 Cron job
4.Divers


1.Introdution
-------------

1.1 A propos du guide
---------------------
Ceci est un petit guide expliquant l'installation d'amavis-stats sur FreeBSD. 
J'ai la version STABLE-4.9, avec une autre version ou un autre *BSD, il ne doit
pas y avoir de grandes diffrences.

Comme il n'y a pas de package tout prt, tout sera fait " la main".

1.2 Qu'est-ce que amavis-stats ?
--------------------------------
Amavis-stats sert  gnrer des statistiques sur amavis, en utilisant rrdtool.
Il gnre des graphiques des e-mails "propres", des spams et des virus classs par nom.
Pour cela il utilise les logs produits par amavis.

Vous pouvez voir des exemples de graph produits  la page suivante :

http://rekudos.net/amavis-stats/node/view/7

1.3 Elments requis
-------------------
Amavis-stats a besoin d'un module perl fourni par le package rrdtool.

Vous pouvez l'installer en utilisant les sources :
	cd /usr/ports/net/rrdtool ; make all && make install
	
Ou avec le package binaire :
	pkg_add ftp://ftp.freebsd.org/pub/FreeBSD/ports/i386/packages-4-stable/net/rrdtool-1.0.45.tgz

note : merci d'utiliser un mirroir FreeBSD http://mirrorlist.freebsd.org/ 

Un serveur apache fonctionnel est ncessaire, avec php.

Ma configuration :
-apache2 avec mod_php4.
-Postfix-2
-Amavis-new
-Clamav-0.65

Je considre qu'Amavisd est configur de la sorte :
-$DO_SYSLOG = 1;

note : ce paramtre est modifiable dans le fichier amavisd.conf, habituellement situ dans /usr/local/etc

Les logs peuvent tre envoys dans un fichier spar, dans ce cas veillez  ce que l'utilisateur amavis puisse le lire.

2.Installation
-------------

2.1 Tlcharger les sources et les installer
--------------------------------------------
Tlchargez le tarball contenant la dernire version :
	wget http://rekudos.net/download/amavis-stats.tar.gz

Dcompressez-la :
	tar xvzf amavis-stats.tar.gz
	cd amavis-stats-xx
	
Copiez le fichier amavis-stats dans /usr/local/sbin :
	cp amavis-stats /usr/local/sbin
	
Crez les rpertoires ncessaires :
	mkdir  /usr/local/www/amavis-stats
	mkdir -p /usr/local/lib/amavis-stats/img
	ln -s /usr/local/lib/amavis-stats/img /usr/local/www/amavis-stats/img

Copiez le fichier amavis-stats.php dans /usr/local/www/amavis-stats 
et faites un lien symbolique pointant vers un fichier index :
	cp amavis-stats.php /usr/local/www/amavis-stats
	cd /usr/local/www/amavis-stats && ln -s amavis-stats.php index.php

note : index.php est un fichier d'index de rpertoire, 
       dfini par "DirectoryIndex" dans la configuration d'apache.
	
2.2 Configurer d'Apache
-----------------------
Dans le fichier apache.conf fourni modifiez les chemins :

Alias /amavis-stats /usr/local/www/amavis-stats

<Directory /usr/local/www/amavis-stats>
(...)

Ajoutez le dans le httpd.conf d'Apache :
	cat apache.conf >> /usr/local/etc/apache2/httpd.conf

note : 	au lieu d'ajouter le fichier, vous pouvez l'inclure, renommez apache.conf en amavis.httpd.conf, 
	dplacez-le dans /usr/local/etc/apache2, puis ajoutez dans le fichier httpd.conf d'apache :
	Include etc/apache2/amavis.httpd.conf
	
Relancez apache
	apachectl restart

2.3 Mettre les droits adquats
------------------------------
Maintenant il faut l'utilisateur et le groupe sous lesquels tourne apache :
	grep ^User\  /usr/local/etc/apache2/httpd.conf (2 espaces aprs User\)
	grep ^Group\  /usr/local/etc/apache2/httpd.conf (2 espaces aprs User\)


Je trouve www comme utilisateur et www comme groupe. Si vous n'avez pas la mme chose, 
remplacez juste www:www par VotreUtilisateur:VotreGroupe dans la commande chown qui suit.

Mettez les droits adquats sur le rpertoire img avec ce que nous venons de trouver  :
(le fichier php va crire les images dans ce rpertoire, donc apache doit pouvoir y crire)
	chown www:www /usr/local/lib/amavis-stats/img

2.4 Crer l'utilisateur amavis
------------------------------
Il faut un utilisateur amavis, qui va maintenir les statistiques  jour en lancant un cron job toutes les 5 minutes.

Crons le  l'aide de adduser ou de sysinstall :
	useradd amavis

Choisissez les valeurs par dfaut, pour son rpertoire personnel mettez /usr/ocal/lib/amavis-stats.

note :  Le groupe additionnel wheel est indispensable pour avoir le droit de lire /var/log/maillog, 
	si toutefois amavisd est configur pour envoyer ses log  syslog.

Maintenant les droits pour les rpertoires auxquels l'utilisateur amavis 
doit avoir accs en criture durant le cron job :
	chown amavis /usr/local/lib/amavis-stats
	chown amavis /usr/local/www/amavis-stats


2.5 Modifier les fichiers
-------------------------
Maintenant modifions certains fichiers :

Editez le fichier amavis-stats et changez :
ligne 79 en:
	$lockfile = "/var/tmp/$pkg";
ligne 80 en:
	$libdir = "/usr/local/lib/$pkg";


Editez le fichier amavis-stats.php et changez :
ligne 282 en :
	$as_libdir = "/usr/local/lib/amavis-stats";

3. Etapes finales
-----------------

3.1 Test de l'installation
--------------------------
note : 	pour les instructions suivantes, mettez /var/log/maillog dans le cas ou amavisd est configur 
	pour envoyer les logs  syslog, sinon mettez le fichier de log que vous avez dfini.

Logguez vous sous le compte amavis, et vrifiez que tout se passe bien :
	su amavis
	/usr/local/sbin/amavis-stats /var/log/maillog

Cette commande a cre des fichiers dans /usr/local/lib/amavis-stats :

1.rrd                   amavis-stats.count      amavis-stats.state
2.rrd                   amavis-stats.names      img
3.rrd                   amavis-stats.seen


A prsent regardez si la page php marche, allez  http://LeNomDeVotreServeur/amavis-stats avec votre naviguateur favori.
Si vous avez des erreurs du genre "write denied" revrifiez les droits sur les rpertoires 
(voir section 2.3 Mettre les droits adquats).

3.2 Cron job
-----------
Mettons en place un cronjob pour que les donnes soient mises  jour rgulirement :
	crontab -e -u amavis
	
Ecrivez ceci dans l'diteur qui vient de s'ouvrir :

*/5 * * * * /usr/local/sbin/amavis-stats /var/log/maillog 2>&1 > /dev/null



Comme l'utilisateur amavis n'a pas besoin de se logguer, vous pouvez par mesure de scurit lui ter son shell :
	chsh -s /sbin/nologin amavis


4. Divers
---------

Retours d'exprience
--------------------
Je suis intrss par tous vos retours d'exprience, bons ou mauvais concernant ce guide.
N'hsitez pas  me contacter si vous trouvez des erreurs ou si quelque chose manque.

<loic AT dev DOT erodia DOT net>


Historique
----------
v 1.0 (31 jan 2004) version initiale
v 1.1 (2 fev 2004) modifications mineures, corrections version anglaise
v 1.2 (6 fev 2004) mise en page, modifications mineures


Copyright
---------
(c) 2004 Loic Pefferkorn

Cette documentation peut tre reproduite entirement ou partiellement, sans frais, mais doit suivre les restrictions suivantes :

	*La mention copyright et cette notification de la license doivent tre prserves sur toutes les copies.
	*Toute traduction ou travail driv doit tre approuv par l'auteur avant d'tre distribu.
	*Si vous distribuez des parties de ce document, il vous faut mettre les instructions ncessaires pour obtenir la version complte.
	*Ce document est plac sous la license GPL (voir http://www.gnu.org/licenses/gpl.html)

Remerciements
-------------
-Aux auteurs d'amavis.
-A Mark Lawrence, pour amavis-stats
-A Bosco L Parisi, pour ses conseils aviss.


