// ---------------------------------------------------------------------------
// - t_vector.cpp                                                            -
// - standard object library - vector class tester                           -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Vector.hpp"
#include "String.hpp"

int main (int, char**) {
  using namespace aleph;

  // create a new vector
  Vector  vecobj;
  String* hello  = new String ("hello");
  String* world  = new String ("world");
  
  // insert out favorite message
  vecobj.append (hello);
  vecobj.append (world);

  // check vector size
  if (vecobj.length () != 2) return 1;

  // get first object
  Object* object = vecobj.get (0);
  String* strobj = dynamic_cast <String*> (object);

  // check for string
  if (strobj  == nilp)    return 1;
  if (*strobj != "hello") return 1;

  // query next string
  object = vecobj.get (1);
  strobj = dynamic_cast <String*> (object);

  // check for string
  if (strobj  == nilp)     return 1;
  if (*strobj != "world") return 1;

  // ok - everything is fine
  return 0;
}
