// ---------------------------------------------------------------------------
// - t_buffer.cpp                                                            -
// - standard object library - buffer class tester                           -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Buffer.hpp"
#include "Exception.hpp"

int main (int, char**) {
  using namespace aleph;

  // try to create a buffer with negative size
  try {
    Buffer* wrong = new Buffer ((long) -1);
    delete wrong;
  } 

  // we should catch this exception
  catch (const Exception& e) {
  } 

  // if we are here it is an error
  catch (...) {
    return 1;
  }

  // create a default buffer with 0 size
  Buffer* buffer = new Buffer ((long) 0);

  // check for length equal to 0
  if (buffer->length () != 0) return 1;

  // add the magic string into it
  const char* magic = "hello world";
  int         size  = 11;

  for (int i = 0; i < size; i++)
    buffer->add (magic[i]);

  // check for the length again
  if (buffer->length () != size) return 1;

  // check the result string - make sure the value is destroyed !!!
  String value = buffer->tostring ();
  if (value != magic) return 1;

  // reset the buffer and check string and size
  buffer->reset ();
  if (buffer->length () != 0)   return 1;

  // finally - no failure
  delete buffer;
  return 0;
}
