// ---------------------------------------------------------------------------
// - Enum.hpp                                                               -
// - aleph engine - enumeration class definition                            -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_ENUM_HPP
#define  ALEPH_ENUM_HPP

#ifndef  ALEPH_QARRAY_HPP
#include "Qarray.hpp"
#endif

namespace aleph {

  /// The Enum class is a container object for an enumeration. By default
  /// an enumeration is empty but can be filled with symbol. Evaluating an
  /// enumeration returns an enumeration item. Such item encapsulate the
  /// enumeration object and the item index.
  /// @author amaury darsch

  class Enum : public Object {
  private:
    /// the enum quark array
    Qarray d_enum;

  public:
    /// create a default enumaration
    Enum (void);

    /// @return the class name
    String repr (void) const;

    /// @return true if an item exists
    bool exists (const long quark) const;

    /// add an item by name to this enumeration
    /// @param name the item name to add
    void add (const String& name);

    /// add an item to this enumeration
    /// @param quark the quark to add
    void add (const long quark);
 
    /// generate a new enumeration
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// evaluate an enumeration member by quark
    /// @param robj   robj the current runnable
    /// @param nset   the current nameset    
    /// @param quark  the quark to evaluate
    Object* eval (Runnable* robj, Nameset* nset, const long quark);
  
    /// apply this enumeration with a set of arguments and a quark
    /// @param robj   the current runnable
    /// @param nset   the current nameset    
    /// @param quark  the quark to apply these arguments
    /// @param argv   the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
		   Vector* argv);

  private:
    // make the copy constructor private
    Enum (const Enum&);
    // make the assignment operator private
    Enum& operator = (const Enum&);
  };
}

#endif
