// ---------------------------------------------------------------------------
// - Axdopts.hpp                                                             -
// - aleph cross debugger - options class definitions                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef ALEPH_AXDOPTS_HPP
#define ALEPH_AXDOPTS_HPP

#ifndef  ALEPH_STRVEC_HPP
#include "Strvec.hpp"
#endif

namespace aleph {

  /// The Axdopts class is the class used by the aleph cross debugger to 
  /// store user options. The instance is simply created with the standard 
  /// main program arguments.
  /// @author amaury darsch

  class Axdopts {
  private:
    /// the argument list
    Strvec d_argv;
    /// the paths list
    Strvec d_path;
    /// the initial file name
    String d_fname;
    /// the assert flag
    bool d_assert;
    /// the emacs options
    bool d_emacs;

  public:
    /// create a new option class from the main arguments
    /// @param argc the number of arguments
    /// @param argv the argument array
    Axdopts (int argc, char** argv);

    /// @return the string vector of arguments
    const Strvec& getargs (void) const;

    /// @return the string vector of paths
    const Strvec& getpath (void) const;

    /// @return the assert flag
    bool getassert (void) const;

    /// @return the emacs flag
    bool getemacs (void) const;
    
    /// @return the optional file name
    String getfname (void) const;

  private:
    // make the copy constructor private
    Axdopts (const Axdopts&);
    // make the assignment operator private
    Axdopts& operator = (const Axdopts&);
  };
}

#endif
