/**********************************************************************
 ** NewFuncts functions: A non-OO list of functions that should be used
 **                      to create or delete objects, to keep it safe
 **
 **   Note: new functs are in the format new_<type>(any parameters);
 **         they will not be documented unless they have parameters
 **         and then the parameters will be described briefly
 **
 **
 **
 ** Last reviewed:
 **
 **
 ** Copyright (C) 2000 George Noel (Slate), Kelly Gerke, Ed Boraas
 **
 **   This program is free software; you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as
 **   published by the Free Software Foundation; either version 2 of the 
 **   License, or any later version. 
 **
 **   This program is distributed in the hope that it will be useful, but 
 **   WITHOUT ANY WARRANTY; without even the implied warranty of 
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 **   General Public License for more details. 
 **
 **   You should have received a copy of the GNU General Public License 
 **   along with this program (in the docs dir); if not, write to the Free
 **   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 **
 **********************************************************************/

#ifndef NEWFUNCTS_C
#define NEWFUNCTS_C

#include "config.h"
#include "sysdep.h"
#include "memchk.h"
#include "flags.h"
#include "action.h"
#include "text.h"
#include "level.h"
#include "quest.h"
#include "marker.h"
#include "location.h"
#include "door.h"
#include "moveable.h"
#include "wearable.h"
#include "rope.h"
#include "weapon.h"
#include "merger.h"
#include "key.h"
#include "boat.h"
#include "book.h"
#include "mobile.h"
#include "money.h"
#include "food.h"
#include "specials.h"
#include "spell.h"
#include "skill.h"
#include "area_dbase.h"
#include "shop.h"
#include "pager.h"
#include "strings.h"
#include "btree.h"
#include "code.h"
#include "mailer.h"
#include "individual.h"
#include "lextree.h"
#include "mud.h"
#include "input.h"
#include "linkedlist.h"
#include "errlog.h"
#include "syslog.h"
#include "data_log.h"
#include "user_dbase.h"
#ifdef WIN32
#include "../win32/winport.h"
#else
#include "port.h"
#endif
#include "race.h"
#include "inclination.h"
#include "talent.h"
#include "access_list.h"
#include "objtype.h"
#include "bulletin.h"
#include "configs.h"
#include "newfuncts.h"
#include "mask.h"
#include "verb_list.h"
#include "chatline.h"

/***********************************************************************
 ** new_Flags
 **
 ** Parameters: the_num - the number of flag units of 32 to create
 **
 ***********************************************************************/
/*
Flags *new_Flags(int the_num)
{
#ifdef DEBUG_MEM
   add_mem_unit("flags");
#endif
   return new Flags(the_num);
}

void delete_Flags(Flags *the_flag)
{
   if (the_flag != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("flags");
#endif
      delete the_flag;
   }
}
*/

/***********************************************************************
 ** new_Action
 **
 ** Parameters: the_name - the name to give the action
 **
 ***********************************************************************/

Action *new_Action(char *the_name)
{
#ifdef DEBUG_MEM
   add_mem_unit("actions");
#endif
   return new Action(the_name);
}

void delete_Action(Action *the_action)
{
   if (the_action != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("actions");
#endif      
      delete the_action;
   }
}


/***********************************************************************
 ** new_ChatLine
 **
 ** Parameters: the_name - the name to give the chatline
 **
 ***********************************************************************/

ChatLine *new_ChatLine(char *the_name)
{
#ifdef DEBUG_MEM
   add_mem_unit("chatline");
#endif
   return new ChatLine(the_name);
}

void delete_ChatLine(ChatLine *the_chatline)
{
   if (the_chatline != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("chatline");
#endif      
      delete the_chatline;
   }
}


/***********************************************************************
 ** new_Text
 **
 ** Parameters: the_name - the name to give the action
 **             text_type - the type of text this is
 **
 ***********************************************************************/

Text *new_Text(char *the_name, int text_type)
{
#ifdef DEBUG_MEM
   add_mem_unit("texts");
#endif
   return new Text(the_name, text_type);
}

void delete_Text(Text *the_text)
{
   if (the_text != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("texts");
#endif
      delete the_text;
   }
}


/***********************************************************************
 ** new_Level
 **
 ** Parameters: the_name - the name to give the level
 **
 ***********************************************************************/

/*Level *new_Level(char *the_name)
{
#ifdef DEBUG_MEM
   add_mem_unit("levels");
#endif
   return new Level(the_name);
}

void delete_Level(Level *the_level)
{
   if (the_level != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("levels");
#endif
      delete the_level;
   }
}*/

/***********************************************************************
 ** new_Quest
 **
 ** Parameters: the_name - the name to give the level
 **
 ***********************************************************************/

Quest *new_Quest(char *the_name)
{
#ifdef DEBUG_MEM
   add_mem_unit("quests");
#endif
   return new Quest(the_name);
}

void delete_Quest(Quest *the_quest)
{
   if (the_quest != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("quests");
#endif
      delete the_quest;
   }
}


/***********************************************************************
 ** new_Marker
 **
 ** Parameters: the_name - the name to give this
 **             the_area - the area this belongs to 
 **
 ***********************************************************************/

Marker *new_Marker(char *the_name, char *the_area)
{
#ifdef DEBUG_MEM
   add_mem_unit("markers");
#endif
   return new Marker(the_name, the_area);
}

void delete_Marker(Marker *the_marker)
{
   if (the_marker != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("markers");
#endif
      delete the_marker;
   }
}


/***********************************************************************
 ** new_Location
 **
 ** Parameters: the_name - the name to give this
 **             the_area - the area this belongs to 
 **
 ***********************************************************************/

Location *new_Location(char *the_name, char *the_area)
{
#ifdef DEBUG_MEM
   add_mem_unit("locations");
#endif
   return new Location(the_name, the_area);
}

void delete_Location(Location *the_loc)
{
   if (the_loc != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("locations");
#endif
      delete the_loc;
   }
}


/***********************************************************************
 ** new_Door
 **
 ** Parameters: the_name - the name to give this
 **             the_area - the area this belongs to 
 **
 ***********************************************************************/

Door *new_Door(char *the_name, char *the_area)
{
#ifdef DEBUG_MEM
   add_mem_unit("doors");
#endif
   return new Door(the_name, the_area);
}

void delete_Door(Door *the_door)
{
   if (the_door != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("doors");
#endif
      delete the_door;
   }
}


/***********************************************************************
 ** new_Moveable
 **
 ** Parameters: the_name - the name to give this
 **             the_area - the area this belongs to 
 **
 ***********************************************************************/

Moveable *new_Moveable(char *the_name, char *the_area)
{
#ifdef DEBUG_MEM
   add_mem_unit("moveables");
#endif
   return new Moveable(the_name, the_area);
}

void delete_Moveable(Moveable *the_moveable)
{
   if (the_moveable != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("moveables");
#endif
      if (the_moveable->get_type() != OBJ_TYPE_MOVEABLE)
         RAISE(1);

      delete the_moveable;
   }
}


/***********************************************************************
 ** new_Wearable
 **
 ** Parameters: the_name - the name to give this
 **             the_area - the area this belongs to 
 **
 ***********************************************************************/
/*
Wearable *new_Wearable(char *the_name, char *the_area)
{
#ifdef DEBUG_MEM
   add_mem_unit("wearables");
#endif
   return new Wearable(the_name, the_area);
}

void delete_Wearable(Wearable *the_wearable)
{
   if (the_wearable != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("wearables");
#endif
      delete the_wearable;
   }
}
*/

/***********************************************************************
 ** new_Rope
 **
 ** Parameters: the_name - the name to give this
 **             the_area - the area this belongs to 
 **
 ***********************************************************************/

Rope *new_Rope(char *the_name, char *the_area)
{
#ifdef DEBUG_MEM
   add_mem_unit("ropes");
#endif
   return new Rope(the_name, the_area);
}

void delete_Rope(Rope *the_rope)
{
   if (the_rope != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("ropes");
#endif
      delete the_rope;
   }
}


/***********************************************************************
 ** new_Weapon
 **
 ** Parameters: the_name - the name to give this
 **             the_area - the area this belongs to 
 **
 ***********************************************************************/

Weapon *new_Weapon(char *the_name, char *the_area)
{
#ifdef DEBUG_MEM
   add_mem_unit("weapons");
#endif
   return new Weapon(the_name, the_area);
}

void delete_Weapon(Weapon *the_weapon)
{
   if (the_weapon != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("weapons");
#endif
      delete the_weapon;
   }
}


/***********************************************************************
 ** new_Merger
 **
 ** Parameters: the_name - the name to give this
 **             the_area - the area this belongs to 
 **
 ***********************************************************************/

Merger *new_Merger(char *the_name, char *the_area)
{
#ifdef DEBUG_MEM
   add_mem_unit("mergers");
#endif
   return new Merger(the_name, the_area);
}

void delete_Merger(Merger *the_merger)
{
   if (the_merger != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("mergers");
#endif

      if (the_merger->get_type() != OBJ_TYPE_MERGER)
         RAISE(1);

      delete the_merger;
   }
}


/***********************************************************************
 ** new_Key
 **
 ** Parameters: the_name - the name to give this
 **             the_area - the area this belongs to 
 **
 ***********************************************************************/

Key *new_Key(char *the_name, char *the_area)
{
#ifdef DEBUG_MEM
   add_mem_unit("keys");
#endif
   return new Key(the_name, the_area);
}

void delete_Key(Key *the_key)
{
   if (the_key != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("keys");
#endif
      delete the_key;
   }
}


/***********************************************************************
 ** new_Boat
 **
 ** Parameters: the_name - the name to give this
 **             the_area - the area this belongs to 
 **
 ***********************************************************************/

Boat *new_Boat(char *the_name, char *the_area)
{
#ifdef DEBUG_MEM
   add_mem_unit("boats");
#endif
   return new Boat(the_name, the_area);
}

void delete_Boat(Boat *the_boat)
{
   if (the_boat != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("boats");
#endif
      delete the_boat;
   }
}


/***********************************************************************
 ** new_Book
 **
 ** Parameters: the_name - the name to give this
 **             the_area - the area this belongs to 
 **
 ***********************************************************************/

Book *new_Book(char *the_name, char *the_area)
{
#ifdef DEBUG_MEM
   add_mem_unit("books");
#endif
   return new Book(the_name, the_area);
}

void delete_Book(Book *the_book)
{
   if (the_book != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("books");
#endif
      delete the_book;
   }
}


/***********************************************************************
 ** new_Mobile
 **
 ** Parameters: the_name - the name to give this
 **             the_area - the area this belongs to 
 **
 ***********************************************************************/

Mobile *new_Mobile(char *the_name, char *the_area)
{
#ifdef DEBUG_MEM
   add_mem_unit("mobiles");
#endif
   return new Mobile(the_name, the_area);
}

void delete_Mobile(Mobile *the_mobile)
{
   if (the_mobile != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("mobiles");
#endif
      delete the_mobile;
   }
}


/***********************************************************************
 ** new_Money
 **
 ** Parameters: the_name - the name to give this
 **             the_area - the area this belongs to 
 **
 ***********************************************************************/

Money *new_Money(char *the_name, char *the_area)
{
#ifdef DEBUG_MEM
   add_mem_unit("money");
#endif
   return new Money(the_name, the_area);
}

void delete_Money(Money *the_money)
{
   if (the_money != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("money");
#endif
      delete the_money;
   }
}


/***********************************************************************
 ** new_Food
 **
 ** Parameters: the_name - the name to give this
 **             the_area - the area this belongs to 
 **
 ***********************************************************************/

Food *new_Food(char *the_name, char *the_area)
{
#ifdef DEBUG_MEM
   add_mem_unit("food");
#endif
   return new Food(the_name, the_area);
}

void delete_Food(Food *the_food)
{
   if (the_food != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("food");
#endif
      delete the_food;
   }
}


/***********************************************************************
 ** new_Specials
 **
 ** Parameters: the_name - the name to give this
 **             the_area - the area this belongs to 
 **
 ***********************************************************************/
/*
Specials *new_Specials(char *the_name, char *the_area)
{
#ifdef DEBUG_MEM
   add_mem_unit("specials");
#endif
   return new Specials(the_name, the_area);
}

void delete_Specials(Specials *the_special)
{
   if (the_special != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("specials");
#endif
      delete the_special;
   }
}

*/
/***********************************************************************
 ** new_Spell
 **
 ** Parameters: the_name - the name to give this
 **
 ***********************************************************************/
/*
Spell *new_Spell(char *the_name)
{
#ifdef DEBUG_MEM
   add_mem_unit("spells");
#endif
   return new Spell(the_name);
}

void delete_Spell(Spell *the_spell)
{
   if (the_spell != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("spells");
#endif
      delete the_spell;
   }
}
*/

/***********************************************************************
 ** new_Skill
 **
 ** Parameters: the_name - the name to give this 
 **
 ***********************************************************************/

Skill *new_Skill(char *the_name)
{
#ifdef DEBUG_MEM
   add_mem_unit("skills");
#endif
   return new Skill(the_name);
}

void delete_Skill(Skill *the_skill)
{
   if (the_skill != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("skills");
#endif
      delete the_skill;
   }
}


reload_obj_info *new_reload_obj_info()
{
#ifdef DEBUG_MEM
   add_mem_unit("reload_obj_info");
#endif
   return new reload_obj_info;
}

void delete_reload_obj_info(reload_obj_info *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("reload_obj_info");
#endif
      delete the_obj;
   }
}


Com_List *new_Com_List()
{
#ifdef DEBUG_MEM
   add_mem_unit("com_list");
#endif
   return new Com_List;
}

void delete_Com_List(Com_List *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("com_list");
#endif
      delete the_obj;
   }
}


Shop *new_Shop()
{
#ifdef DEBUG_MEM
   add_mem_unit("shops");
#endif
   return new Shop();
}

void delete_Shop(Shop *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("shops");
#endif
      delete the_obj;
   }
}


/***********************************************************************
 ** new_Pager
 **
 ** Parameters: filename - the name of the file to open
 **             num_lines - the number of lines to display at a time 
 **
 ***********************************************************************/

Pager *new_Pager(char *filename, int num_lines)
{
#ifdef DEBUG_MEM
   add_mem_unit("pagers");
#endif
   return new Pager(filename, num_lines);
}


/***********************************************************************
 ** new_Pager
 **
 ** Parameters: the_str - the string object to page
 **             num_lines - the number of lines to display at a time 
 **
 ***********************************************************************/

Pager *new_Pager(Strings *the_str, int num_lines)
{
#ifdef DEBUG_MEM
   add_mem_unit("pagers");
#endif
   return new Pager(the_str, num_lines);
}

void delete_Pager(Pager *the_pager)
{
   if (the_pager != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("pagers");
#endif
      delete the_pager;
   }
}

/*
b_node_a *new_b_node_a()
{
#ifdef DEBUG_MEM
   add_mem_unit("b_node_a");
#endif
   return new b_node_a;
}

void delete_b_node_a(b_node_a *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("b_node_a");
#endif
	  
      delete the_obj;
   }
}


b_node *new_b_node_l()
{
#ifdef DEBUG_MEM
   add_mem_unit("b_node_l");
#endif
   return new b_node_l;
}

void delete_b_node_l(b_node_l *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("b_node_l");
#endif
      delete the_obj;
   }
}
*/

/***********************************************************************
 ** new_char
 **
 ** Parameters: num_char - the number of chars in the string
 **
 ***********************************************************************/

/* char *new_char(int num_char)
{
#ifdef DEBUG_MEM
   add_mem_unit("char");
#endif
   return new char[num_char];
}

void delete_char(char *the_char)
{
   if (the_char != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("char");
#endif
      delete the_char;
   }
} */

#ifdef WIN32

/***********************************************************************
 ** new_Connection
 **
 ** Parameters: sock_num - the socket number
 **
 ***********************************************************************/

Connection *new_Connection()
{
#ifdef DEBUG_MEM
   add_mem_unit("connection");
#endif
   return new Connection();
}

#else

Connection *new_Connection(int sock_num, MudObject *sock_own)
{
#ifdef DEBUG_MEM
   add_mem_unit("connection");
#endif
   return new Connection(sock_num, sock_own);
}

#endif


void delete_Connection(Connection *the_conn)
{
   if (the_conn != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("connection");
#endif
      delete the_conn;
   }
}


/***********************************************************************
 ** new_Editor
 **
 ** Parameters: the_str - the socket number
 **
 ***********************************************************************/

/*Editor *new_Editor(char *the_str)
{
#ifdef DEBUG_MEM
   add_mem_unit("editor");
#endif
   return new Editor(the_str);
}

Editor *new_Editor()
{
#ifdef DEBUG_MEM
   add_mem_unit("editor");
#endif
   return new Editor();
}*/

/***********************************************************************
 ** new_Editor
 **
 ** Parameters: the_file - the file to edit
 **
 ***********************************************************************/

/* Editor *new_Editor(FILE *the_file)
{
#ifdef DEBUG_MEM
   add_mem_unit("editor");
#endif
   return new Editor(the_file);
}

void delete_Editor(Editor *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("editor");
#endif
      delete the_obj;
   }
} */

/***********************************************************************
 ** new_Area_Dbase
 **
 ** Parameters: areaname - the area we are creating
 **
 ***********************************************************************/
/*
Area_Dbase *new_Area_Dbase(char *areaname)
{
#ifdef DEBUG_MEM
   add_mem_unit("area_dbase");
#endif
   return new Area_Dbase(areaname);
}

void delete_Area_Dbase(Area_Dbase *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("area_dbase");
#endif
      delete the_obj;
   }
}
*/
/*

params *new_params()
{
#ifdef DEBUG_MEM
   add_mem_unit("params");
#endif
   return new params;
}

void delete_params(params *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("params");
#endif
      delete the_obj;
   }
}

*/

/***********************************************************************
 ** new_Strings
 **
 ** Parameters: the_str - the string to set this String object to
 **
 ***********************************************************************/
/*
Strings *new_Strings(char *the_str)
{
#ifdef DEBUG_MEM
   add_mem_unit("strings");
#endif
   return new Strings(the_str);
}


Strings *new_Strings()
{
#ifdef DEBUG_MEM
   add_mem_unit("strings");
#endif
   return new Strings();
}


void delete_Strings(Strings *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("strings");
#endif  
      delete the_obj;
   }
}
*/
/*long *new_long()
{
#ifdef DEBUG_MEM
   add_mem_unit("long");
#endif
   return new long;
}

void delete_long(long *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("long");
#endif
      delete the_obj;
   }
}*/

int *new_int()
{
#ifdef DEBUG_MEM
   add_mem_unit("int");
#endif
   return new int;
}

void delete_int(int *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("int");
#endif
      delete the_obj;
   }
}

/***********************************************************************
 ** new_Code
 **
 ** Parameters: the_str - the code to set this Code object to
 **
 ***********************************************************************/
/*
Code *new_Code(char *the_str)
{
#ifdef DEBUG_MEM
   add_mem_unit("code");
#endif
   return new Code(the_str);
}*/


/***********************************************************************
 ** new_Code
 **
 ** Parameters: the_func - the function to set this Code object to
 **
 ***********************************************************************/
/*
Code *new_Code(Spec_Func the_func)
{
#ifdef DEBUG_MEM
   add_mem_unit("code");
#endif
   return new Code(the_func);
} 

void delete_Code(Code *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("code");
#endif
      delete the_obj;
   }
}
*/

/***********************************************************************
 ** new_Player
 **
 ** Parameters: the_str - the string to set this object to
 **
 ***********************************************************************/

Player *new_Player(char *the_str)
{
#ifdef DEBUG_MEM
   add_mem_unit("player");
#endif
   return new Player(the_str);
}

Player *new_Player()
{
#ifdef DEBUG_MEM
   add_mem_unit("player");
#endif
   return new Player();
}

void delete_Player(Player *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("player");
#endif
      delete the_obj;
   }
}


Letter *new_Letter()
{
#ifdef DEBUG_MEM
   add_mem_unit("letter");
#endif
   return new Letter();
}

void delete_Letter(Letter *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("letter");
#endif
      delete the_obj;
   }
}


/***********************************************************************
 ** new_Mailer
 **
 ** Parameters: the_username - the name of the user who has this mailer
 **             the_mode - the mode of the mailer to load
 **             
 **
 ***********************************************************************/

Mailer *new_Mailer(char *the_username, load_type the_mode)
{
#ifdef DEBUG_MEM
   add_mem_unit("mailer");
#endif
   return new Mailer(the_username, the_mode);
}

void delete_Mailer(Mailer *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("mailer");
#endif
      delete the_obj;
   }
}


BullEntry *new_BullEntry(Bulletin *assign_board)
{
#ifdef DEBUG_MEM
   add_mem_unit("bullentry");
#endif
   return new BullEntry(assign_board);
}

void delete_BullEntry(BullEntry *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("bullentry");
#endif
      delete the_obj;
   }
}


/***********************************************************************
 ** new_Bulletin
 **
 ** Parameters: the_name - the name of the bulletin
 **             
 **
 ***********************************************************************/

Bulletin *new_Bulletin(char *the_name, int build_port)
{
#ifdef DEBUG_MEM
   add_mem_unit("bulletin");
#endif
   return new Bulletin(the_name, build_port);
}

void delete_Bulletin(Bulletin *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("bulletin");
#endif
      delete the_obj;
   }
}


Edit_Line *new_Edit_Line()
{
#ifdef DEBUG_MEM
   add_mem_unit("edit_line");
#endif
   return new Edit_Line;
}

void delete_Edit_Line(Edit_Line *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("edit_line");
#endif
      delete the_obj;
   }
}

/*flag_long_int *new_flag_long_int()
{
#ifdef DEBUG_MEM
   add_mem_unit("flag_long_int");
#endif
   return new flag_long_int;
}*/

/*void delete_flag_long_int(flag_long_int *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("flag_long_int");
#endif
      delete the_obj;
   }
}*/

/*
worn_item *new_worn_item()
{
#ifdef DEBUG_MEM
   add_mem_unit("worn_items");
#endif
   return new worn_item;
}

void delete_worn_item(worn_item *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("worn_items");
#endif
      delete the_obj;
   }
}
*/

handler_struct *new_handler_struct()
{
#ifdef DEBUG_MEM
   add_mem_unit("handler_struct");
#endif
   return new handler_struct;
}

void delete_handler_struct(handler_struct *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("handler_struct");
#endif
      delete the_obj;
   }
}


special_holder *new_special_holder()
{
#ifdef DEBUG_MEM
   add_mem_unit("special_holder");
#endif
   return new special_holder;
}

void delete_special_holder(special_holder *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("special_holder");
#endif
      delete the_obj;
   }
}


chain_link *new_chain_link()
{
#ifdef DEBUG_MEM
   add_mem_unit("chain_link");
#endif
   return new chain_link;
}

void delete_chain_link(chain_link *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("chain_link");
#endif
      delete the_obj;
   }
}


token_data *new_token_data()
{
#ifdef DEBUG_MEM
   add_mem_unit("token_data");
#endif
   return new token_data;
}

void delete_token_data(token_data *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("token_data");
#endif
      delete the_obj;
   }
}


lex_holder *new_lex_holder()
{
#ifdef DEBUG_MEM
   add_mem_unit("lex_holder");
#endif
   return new lex_holder;
}

void delete_lex_holder(lex_holder *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("lex_holder");
#endif
      delete the_obj;
   }
}

mem_unit *new_mem_unit()
{
#ifdef DEBUG_MEM
   add_mem_unit("mem_unit");
#endif
   return new mem_unit;
}

void delete_mem_unit(mem_unit *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("mem_unit");
#endif
      delete the_obj;
   }
}

fighting_ind *new_fighting_ind()
{
#ifdef DEBUG_MEM
   add_mem_unit("fighting_ind");
#endif
   return new fighting_ind;
}

void delete_fighting_ind(fighting_ind *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("fighting_ind");
#endif
      delete the_obj;
   }
}

rank_list *new_rank_list()
{
#ifdef DEBUG_MEM
   add_mem_unit("rank_list");
#endif
   return new rank_list;
}

void delete_rank_list(rank_list *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("rank_list");
#endif
      delete the_obj;
   }
}

level_list *new_level_list()
{
#ifdef DEBUG_MEM
   add_mem_unit("level_list");
#endif
   return new level_list;
}

void delete_level_list(level_list *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("level_list");
#endif
      delete the_obj;
   }
}

quest_list *new_quest_list()
{
#ifdef DEBUG_MEM
   add_mem_unit("quest_list");
#endif
   return new quest_list;
}

void delete_quest_list(quest_list *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("quest_list");
#endif
      delete the_obj;
   }
}

vars *new_vars()
{
#ifdef DEBUG_MEM
   add_mem_unit("vars");
#endif
   return new vars;
}

void delete_vars(vars *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("vars");
#endif
      delete the_obj;
   }
}

status_type *new_status_type()
{
#ifdef DEBUG_MEM
   add_mem_unit("status_type");
#endif
   return new status_type;
}

void delete_status_type(status_type *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("status_type");
#endif
      delete the_obj;
   }
}


Input *new_Input()
{
#ifdef DEBUG_MEM
   add_mem_unit("inputs");
#endif
   return new Input();
}

void delete_Input(Input *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("inputs");
#endif
      delete the_obj;
   }
}


/***********************************************************************
 ** new_Parse
 **
 ** Parameters: the_input - the player's input
 **             the_verb - the verb to parse for
 **
 ***********************************************************************/

Parse *new_Parse(char *the_input, Entity *the_verb)
{
#ifdef DEBUG_MEM
   add_mem_unit("parse");
#endif
   return new Parse(the_input, the_verb);
}

void delete_Parse(Parse *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("parse");
#endif
      delete the_obj;
   }
}


/***********************************************************************
 ** new_Level_Chain
 **
 ** Parameters: the_chain - the name of the chain
 **
 ***********************************************************************/

Level_Chain *new_Level_Chain(char *the_chain)
{
#ifdef DEBUG_MEM
   add_mem_unit("level_chain");
#endif
   return new Level_Chain(the_chain);
}

void delete_Level_Chain(Level_Chain *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("level_chain");
#endif
      delete the_obj;
   }
}


/***********************************************************************
 ** new_LinkedNode
 **
 ** Parameters: the_node - the name of the node
 **
 ***********************************************************************/
/*
LinkedNode *new_LinkedNode(MudObject *the_node)
{
#ifdef DEBUG_MEM
   add_mem_unit("linkednode");
#endif
   return new LinkedNode(the_node);
}

void delete_LinkedNode(LinkedNode *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("linkednode");
#endif
      delete the_obj;
   }
}
*/

Mud *new_Mud(bool quiet_mode)
{
#ifdef DEBUG_MEM
   add_mem_unit("mud");
#endif
   return new Mud(quiet_mode);
}

void delete_Mud(Mud *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("mud");
#endif
      delete the_obj;
   }
}


ErrLog *new_ErrLog()
{
#ifdef DEBUG_MEM
   add_mem_unit("errlog");
#endif
   return new ErrLog();
}

void delete_ErrLog(ErrLog *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("errlog");
#endif
      delete the_obj;
   }
}


SysLog *new_SysLog()
{
#ifdef DEBUG_MEM
   add_mem_unit("syslog");
#endif
   return new SysLog();
}

void delete_SysLog(SysLog *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("syslog");
#endif

      delete the_obj;
   }
}

Data_Log *new_Data_Log(char *log_name, char *file_name)
{
#ifdef DEBUG_MEM
   add_mem_unit("data_log");
#endif
   return new Data_Log(log_name, file_name);
}

void delete_Data_Log(Data_Log *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("data_log");
#endif
      delete the_obj;
   }
}


User_Dbase *new_User_Dbase()
{
#ifdef DEBUG_MEM
   add_mem_unit("user_dbase");
#endif
   return new User_Dbase();
}

void delete_User_Dbase(User_Dbase *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("user_dbase");
#endif
      delete the_obj;
   }
}


Configs *new_Configs()
{
#ifdef DEBUG_MEM
   add_mem_unit("configs");
#endif
   return new Configs();
}

void delete_Configs(Configs *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("configs");
#endif
      delete the_obj;
   }
}


/***********************************************************************
 ** new_Port
 **
 ** Parameters: the_port - the port number to open the port at
 **             quiet_mode - display output or not
 **
 ***********************************************************************/

Port *new_Port(int the_port, bool quiet_mode)
{
#ifdef DEBUG_MEM
   add_mem_unit("port");
#endif
   return new Port(the_port, quiet_mode);
}

void delete_Port(Port *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("port");
#endif
      delete the_obj;
   }
}


/***********************************************************************
 ** new_Access_List
 **
 ** Parameters: filename - the name of the file to open
 **
 ***********************************************************************/

Access_List *new_Access_List(char *filename)
{
#ifdef DEBUG_MEM
   add_mem_unit("access_list");
#endif
   return new Access_List(filename);
}

void delete_Access_List(Access_List *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("access_list");
#endif
      delete the_obj;
   }
}


/***********************************************************************
 ** new_Verb_List
 **
 ** Parameters: filename - the name of the file to open
 **
 ***********************************************************************/

Verb_List *new_Verb_List(verb_data the_data[])
{
#ifdef DEBUG_MEM
   add_mem_unit("verb_list");
#endif
   return new Verb_List(the_data);
}

void delete_Verb_List(Verb_List *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("verb_list");
#endif
      delete the_obj;
   }
}


/***********************************************************************
 ** new_Object_List
 **
 ** Parameters: the_log - the errlog that we write to
 **             quiet_mode - display output or not?
 **
 ***********************************************************************/

Object_List *new_Object_List(ErrLog *the_log, bool quiet_mode)
{
#ifdef DEBUG_MEM
   add_mem_unit("object_list");
#endif
   return new Object_List(the_log, quiet_mode);
}

void delete_Object_List(Object_List *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("object_list");
#endif
      delete the_obj;
   }
}


/***********************************************************************
 ** new_Level_List
 **
 ** Parameters: the_log - the errlog that we write to
 **             obj_dbase - the object dbase that stores all the obj
 **
 ***********************************************************************/

Level_List *new_Level_List(ErrLog *the_log, Object_List *obj_dbase)
{
#ifdef DEBUG_MEM
   add_mem_unit("level_list");
#endif
   return new Level_List(the_log, obj_dbase);
}

void delete_Level_List(Level_List *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("level_list");
#endif
      delete the_obj;
   }
}

Builder *new_Builder()
{
#ifdef DEBUG_MEM
   add_mem_unit("builder");
#endif
   return new Builder();
}

Builder *new_Builder(Connection *the_conn)
{
#ifdef DEBUG_MEM
   add_mem_unit("builder");
#endif
   return new Builder(the_conn);
}

void delete_Builder(Builder *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("builder");
#endif
      delete the_obj;
   }
}


/***********************************************************************
 ** new_Verb
 **
 ** Parameters: the_name - the name to give the verb
 **
 ***********************************************************************/

Verb *new_Verb(char *the_name)
{
#ifdef DEBUG_MEM
   add_mem_unit("verb");
#endif
   return new Verb(the_name);
}

void delete_Verb(Verb *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("verb");
#endif
      delete the_obj;
   }
}

/***********************************************************************
 ** new_Race
 **
 ** Parameters: the_name - the name to give the race
 **
 ***********************************************************************/

/*
Race *new_Race(char *the_name)
{
#ifdef DEBUG_MEM
   add_mem_unit("race");
#endif
   return new Race(the_name);
}

void delete_Race(Race *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("race");
#endif
      delete the_obj;
   }
}
*/

/***********************************************************************
 ** new_Inclination
 **
 ** Parameters: the_name - the name to give the inclination
 **
 ***********************************************************************/
/*
Inclination *new_Inclination(char *the_name)
{
#ifdef DEBUG_MEM
   add_mem_unit("inclination");
#endif
   return new Inclination(the_name);
}

void delete_Inclination(Inclination *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("inclination");
#endif
      delete the_obj;
   }
} */

/***********************************************************************
 ** new_Talent
 **
 ** Parameters: the_name - the name to give the talent
 **
 ***********************************************************************/
/*
Talent *new_Talent(char *the_name)
{
#ifdef DEBUG_MEM
   add_mem_unit("talent");
#endif
   return new Talent(the_name);
}

void delete_Talent(Talent *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("talent");
#endif
      delete the_obj;
   }
}
*/

/***********************************************************************
 ** new_Mask
 **
 ** Parameters: the_name - the name to give the mask
 **
 ***********************************************************************/

Mask *new_Mask(char *the_name)
{
#ifdef DEBUG_MEM
   add_mem_unit("mask");
#endif
   return new Mask(the_name);
}

void delete_Mask(Mask *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("mask");
#endif
      delete the_obj;
   }
}


shop_item *new_shop_item()
{
#ifdef DEBUG_MEM
   add_mem_unit("shop_item");
#endif
   return new shop_item;
}

void delete_shop_item(shop_item *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("shop_item");
#endif
      delete the_obj;
   }
}

buy_request *new_buy_request()
{
#ifdef DEBUG_MEM
   add_mem_unit("buy_request");
#endif
   return new buy_request;
}

void delete_buy_request(buy_request *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("buy_request");
#endif
      delete the_obj;
   }
}

token_record *new_token_record()
{
#ifdef DEBUG_MEM
   add_mem_unit("token_record");
#endif
   return new token_record;
}

void delete_token_record(token_record *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("token_record");
#endif
      delete the_obj;
   }
}


string_record *new_string_record()
{
#ifdef DEBUG_MEM
   add_mem_unit("string_record");
#endif
   return new string_record;
}

void delete_string_record(string_record *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("string_record");
#endif
      delete the_obj;
   }
}


brief_stack *new_brief_stack()
{
#ifdef DEBUG_MEM
   add_mem_unit("brief_stack");
#endif
   return new brief_stack;
}

void delete_brief_stack(brief_stack *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("brief_stack");
#endif
      delete the_obj;
   }
}


prompt_stack *new_prompt_stack()
{
#ifdef DEBUG_MEM
   add_mem_unit("prompt_stack");
#endif
   return new prompt_stack;
}

void delete_prompt_stack(prompt_stack *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("prompt_stack");
#endif
      delete the_obj;
   }
}


snoop_struct *new_snoop_struct()
{
#ifdef DEBUG_MEM
   add_mem_unit("snoop_struct");
#endif
   return new snoop_struct;
}

void delete_snoop_struct(snoop_struct *the_obj)
{
   if (the_obj != NULL)
   {
#ifdef DEBUG_MEM
      del_mem_unit("snoop_struct");
#endif
      delete the_obj;
   }
}

#endif



















