#ifndef PAGER_H_
#define PAGER_H_

#include "strings.h"
#include <stdio.h>

class Connection;

class Pager {
public:
   Pager(char *fn, int disp_lines);
   Pager(Strings *the_str, int disp_lines);
   ~Pager();
   
   int     paged_read(Connection *the_connection);
   int     open_pagefile(char *fn);
   int     close_pagefile();
   int     file_available();

private:

   int read_file(Connection *the_connection);
   int read_string(Connection *the_connection);

   FILE    *page_fp;
   Strings pager_file;

   Strings *pager_str;
   int     the_offset;

   int     num_lines;
};


#endif
