#ifndef _FOOD_H
#define _FOOD_H

#ifdef USE_PTHREAD
#include <pthread.h>
#endif
#include "strings.h"
#include "merger.h"
#include "builder.h"

class Food : public Merger
{
public:

   Food(char *the_name, char *the_area);
   virtual ~Food();

   virtual void write_object(FILE *the_file, int build_format);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_builder);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   int      get_energy();
   int      set_energy(int the_number);
 
   int      copy_food(Food *copy_from);
   Food     *operator = (Food *copy_from);
   int      read_food_attrib(FILE *read_file, ErrLog *error_log);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();

 protected:

   Food();

 private:

   int      energy;

};

#endif
